/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics;

import java.io.PrintStream;
import java.util.List;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.By;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;

@By(value=DataSource.REFERENCE_ORDERED_DATA)
public class CoveredByNSamplesSites
extends RodWalker<GenomeLoc, Integer>
implements TreeReducible<Integer> {
    @Output(fullName="OutputIntervals", shortName="out", doc="Name of file for output intervals", required=true)
    PrintStream outputStream;
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Argument(fullName="minCoverage", shortName="minCov", doc="only samples that have covarage bigger then minCoverage will be counted", required=false)
    int minCoverage = 10;
    @Argument(fullName="precentageOfSamples", shortName="percentage", doc="only sites where at list percentageOfSamples of the samples have good coverage, will be emited", required=false)
    double percentageOfSamples = 0.9;

    @Override
    public GenomeLoc map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return null;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        if (VCs.size() == 0) {
            return null;
        }
        if (VCs.size() != 1) {
            throw new RuntimeException("there are more then one vc: " + VCs.size());
        }
        boolean emitSite = false;
        for (VariantContext vc : VCs) {
            int coveredSamples = 0;
            GenotypesContext genotypes = vc.getGenotypes();
            int numOfGenotypes = genotypes.size();
            for (Genotype g : genotypes) {
                if (g.getDP() < this.minCoverage) continue;
                ++coveredSamples;
            }
            if (!((double)coveredSamples / (double)numOfGenotypes > this.percentageOfSamples)) continue;
            emitSite = true;
        }
        if (emitSite) {
            return ref.getLocus();
        }
        return null;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(GenomeLoc value, Integer sum) {
        if (value != null) {
            this.outputStream.println(value);
            Integer n = sum;
            Integer n2 = sum = Integer.valueOf(sum + 1);
        }
        return sum;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info(result + " sites that have " + this.percentageOfSamples * 100.0 + "% of the samples with at list " + this.minCoverage + " coverage.\n");
    }
}

