/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics;

import java.io.PrintStream;
import java.util.List;
import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
public class ReadLengthDistribution
extends ReadWalker<Integer, Integer> {
    @Output
    public PrintStream out;
    private GATKReport report;

    @Override
    public void initialize() {
        List<SAMReadGroupRecord> readGroups = this.getToolkit().getSAMFileHeader().getReadGroups();
        this.report = new GATKReport();
        this.report.addTable("ReadLengthDistribution", "Table of read length distributions", 1 + (readGroups.isEmpty() ? 1 : readGroups.size()));
        GATKReportTable table = this.report.getTable("ReadLengthDistribution");
        table.addColumn("readLength");
        if (readGroups.isEmpty()) {
            table.addColumn("SINGLE_SAMPLE");
        } else {
            for (SAMReadGroupRecord rg : readGroups) {
                table.addColumn(rg.getSample());
            }
        }
    }

    @Override
    public boolean filter(ReferenceContext ref, GATKSAMRecord read) {
        return !read.getReadPairedFlag() || read.getReadPairedFlag() && read.getFirstOfPairFlag();
    }

    @Override
    public Integer map(ReferenceContext referenceContext, GATKSAMRecord samRecord, RefMetaDataTracker RefMetaDataTracker2) {
        GATKReportTable table = this.report.getTable("ReadLengthDistribution");
        int length = Math.abs(samRecord.getReadLength());
        String sample = samRecord.getReadGroup().getSample();
        table.increment(length, sample);
        return null;
    }

    @Override
    public Integer reduceInit() {
        return null;
    }

    @Override
    public Integer reduce(Integer integer, Integer integer1) {
        return null;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        this.report.print(this.out);
    }
}

