/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.diagnostics.targets;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.walkers.LocusWalker;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;

public class BaseCoverageDistribution
extends LocusWalker<ArrayList<Integer>, Map<Integer, ArrayList<Long>>> {
    @Output(required=true, doc="The output GATK Report table")
    private PrintStream out;
    @Argument(required=false, shortName="del", fullName="include_deletions", doc="whether or not to include reads with deletions on the loci in the pileup")
    private boolean includeDeletions = true;
    @Argument(required=false, shortName="fd", fullName="filtered_distribution", doc="calculate and report the filtered coverage distribution of bases")
    private boolean calculateFilteredDistribution = false;
    @Argument(required=false, shortName="mmq", fullName="minimum_mapping_quality", doc="minimum mapping quality of a read to include it in the filtered coverage distribution")
    private byte minMappingQuality = (byte)20;
    @Argument(required=false, shortName="mbq", fullName="minimum_base_quality", doc="minimum base quality of a base to include it in the filtered coverage distribution")
    private byte minBaseQuality = (byte)17;
    private GenomeLoc previousLocus = null;
    private long uncoveredBases = 0L;
    private final LinkedList<GenomeLoc> intervalList = new LinkedList();

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return this.includeDeletions;
    }

    @Override
    public void initialize() {
        if (this.getToolkit().getIntervals() != null) {
            this.intervalList.addAll(this.getToolkit().getIntervals());
        }
    }

    @Override
    public ArrayList<Integer> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        ArrayList<Integer> result = new ArrayList<Integer>(2);
        GenomeLoc currentLocus = ref.getLocus();
        this.tallyUncoveredBases(currentLocus);
        this.previousLocus = currentLocus;
        result.add(context.getBasePileup().getReads().size());
        if (this.calculateFilteredDistribution) {
            result.add(context.getBasePileup().getBaseAndMappingFilteredPileup(this.minBaseQuality, this.minMappingQuality).getReads().size());
        } else {
            result.add((Integer)result.get(0));
        }
        return result;
    }

    @Override
    public Map<Integer, ArrayList<Long>> reduceInit() {
        return new HashMap<Integer, ArrayList<Long>>(10000);
    }

    @Override
    public Map<Integer, ArrayList<Long>> reduce(ArrayList<Integer> value, Map<Integer, ArrayList<Long>> sum) {
        int unfilteredCoverage = value.get(0);
        int filteredCoverage = value.get(1);
        this.incrementSumArray(sum, unfilteredCoverage, 0);
        this.incrementSumArray(sum, filteredCoverage, 1);
        return sum;
    }

    @Override
    public void onTraversalDone(Map<Integer, ArrayList<Long>> result) {
        GATKReport report;
        this.tallyUncoveredBasesTillEndOfTraversal();
        if (this.calculateFilteredDistribution) {
            report = GATKReport.newSimpleReport("BaseCoverageDistribution", "Coverage", "Count", "Filtered");
        } else {
            report = GATKReport.newSimpleReport("BaseCoverageDistribution", "Coverage", "Count");
            report.addRow(0, this.uncoveredBases);
        }
        for (Map.Entry<Integer, ArrayList<Long>> entry : result.entrySet()) {
            ArrayList<Long> values = entry.getValue();
            int coverage = entry.getKey();
            if (this.calculateFilteredDistribution) {
                if (coverage == 0) {
                    report.addRow(coverage, this.uncoveredBases, this.uncoveredBases + values.get(1));
                    continue;
                }
                report.addRow(coverage, values.get(0), values.get(1));
                continue;
            }
            report.addRow(coverage, values.get(0));
        }
        if (this.calculateFilteredDistribution && !result.containsKey(0)) {
            report.addRow(0, this.uncoveredBases, this.uncoveredBases);
        }
        report.print(this.out);
    }

    private ArrayList<Long> initializeSumArray(Map<Integer, ArrayList<Long>> sum, int coverage) {
        ArrayList<Long> curr = sum.get(coverage);
        if (curr == null) {
            curr = new ArrayList(2);
            curr.add(0L);
            curr.add(0L);
            sum.put(coverage, curr);
        }
        return curr;
    }

    private void incrementSumArray(Map<Integer, ArrayList<Long>> sum, int coverage, int arrayIndex) {
        ArrayList<Long> currentTally = this.initializeSumArray(sum, coverage);
        currentTally.set(arrayIndex, currentTally.get(arrayIndex) + 1L);
    }

    private void tallyUncoveredBasesTillEndOfTraversal() {
        GenomeLoc lastLocus;
        GenomeLocParser parser = this.getToolkit().getGenomeLocParser();
        if (this.intervalList.isEmpty()) {
            int lastContigIndex = this.getToolkit().getSAMFileHeader().getSequenceDictionary().size() - 1;
            int lastContigLength = this.getToolkit().getSAMFileHeader().getSequence(lastContigIndex).getSequenceLength();
            String lastContigName = this.getToolkit().getSAMFileHeader().getSequence(lastContigIndex).getSequenceName();
            lastLocus = parser.createGenomeLoc(lastContigName, lastContigIndex, lastContigLength, lastContigLength);
        } else {
            GenomeLoc lastInterval = this.intervalList.getLast();
            lastLocus = parser.createGenomeLoc(lastInterval.getContig(), lastInterval.getContigIndex(), lastInterval.getStop(), lastInterval.getStop());
        }
        this.tallyUncoveredBases(lastLocus);
    }

    private void tallyUncoveredBases(GenomeLoc currentLocus) {
        long distance = 0L;
        if (this.previousLocus == null) {
            GenomeLocParser parser = this.getToolkit().getGenomeLocParser();
            if (this.intervalList.isEmpty()) {
                GenomeLoc zeroLoc = parser.createGenomeLoc(this.getToolkit().getSAMFileHeader().getSequence(0).getSequenceName(), 0, 1, 1);
                distance += currentLocus.distanceAcrossContigs(zeroLoc, this.getToolkit().getSAMFileHeader());
            } else {
                while (!this.intervalList.peek().containsP(currentLocus)) {
                    GenomeLoc interval = this.intervalList.removeFirst();
                    distance += (long)interval.size();
                }
                distance += (long)(currentLocus.getStart() - this.intervalList.peek().getStart());
            }
        } else {
            GenomeLoc previousInterval = this.intervalList.peekFirst();
            distance = currentLocus.distanceAcrossContigs(this.previousLocus, this.getToolkit().getSAMFileHeader()) - 1L;
            if (previousInterval != null && !previousInterval.containsP(currentLocus)) {
                this.intervalList.removeFirst();
                GenomeLoc currentInterval = this.intervalList.peekFirst();
                distance -= currentInterval.distanceAcrossContigs(previousInterval, this.getToolkit().getSAMFileHeader()) - 1L;
            }
        }
        this.uncoveredBases += distance;
    }
}

