/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.fasta;

import java.io.PrintStream;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RefWalker;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
public class FastaStats
extends RefWalker<Byte, FastaStatistics> {
    @Output
    PrintStream out;

    @Override
    public Byte map(RefMetaDataTracker rodData, ReferenceContext ref, AlignmentContext context) {
        return ref.getBase();
    }

    @Override
    public FastaStatistics reduceInit() {
        return new FastaStatistics();
    }

    @Override
    public FastaStatistics reduce(Byte base, FastaStatistics stats) {
        ++stats.nBases;
        if (BaseUtils.isRegularBase(base)) {
            ++stats.nRegBases;
        }
        return stats;
    }

    @Override
    public void onTraversalDone(FastaStatistics sum) {
        this.out.printf("Total bases   %d%n", sum.nBases);
        this.out.printf("Regular bases %d%n", sum.nRegBases);
    }

    protected class FastaStatistics {
        long nBases = 0L;
        long nRegBases = 0L;

        protected FastaStatistics() {
        }
    }
}

