/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.ErrorModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public abstract class GeneralPloidyGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    protected final UnifiedArgumentCollection UAC;

    protected GeneralPloidyGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.UAC = UAC;
    }

    protected VariantContext getTrueAlleles(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts) {
        if (this.UAC.referenceSampleName == null) {
            return null;
        }
        AlignmentContext context = contexts.get(this.UAC.referenceSampleName);
        ArrayList<Allele> trueReferenceAlleles = new ArrayList<Allele>();
        if (tracker == null || context == null) {
            return null;
        }
        VariantContext referenceSampleVC = tracker.getFirstValue(this.UAC.referenceSampleRod, context.getLocation());
        if (referenceSampleVC == null) {
            trueReferenceAlleles.add(Allele.create(ref.getBase(), true));
            return new VariantContextBuilder("pc", ref.getLocus().getContig(), ref.getLocus().getStart(), ref.getLocus().getStop(), trueReferenceAlleles).make();
        }
        Genotype referenceGenotype = referenceSampleVC.getGenotype(this.UAC.referenceSampleName);
        List<Allele> referenceAlleles = referenceGenotype.getAlleles();
        return new VariantContextBuilder("pc", referenceSampleVC.getChr(), referenceSampleVC.getStart(), referenceSampleVC.getEnd(), referenceSampleVC.getAlleles()).genotypes(new GenotypeBuilder(this.UAC.referenceSampleName, referenceAlleles).GQ(referenceGenotype.getGQ()).make()).make();
    }

    public static Set<String> parseLaneIDs(Collection<String> readGroups) {
        HashSet<String> result = new HashSet<String>();
        for (String readGroup : readGroups) {
            result.add(GeneralPloidyGenotypeLikelihoodsCalculationModel.getLaneIDFromReadGroupString(readGroup));
        }
        return result;
    }

    public static String getLaneIDFromReadGroupString(String readGroupID) {
        String[] parsedID = readGroupID.split("\\.");
        if (parsedID.length > 1) {
            return parsedID[0] + "." + parsedID[1];
        }
        return parsedID[0] + ".0";
    }

    protected List<Allele> determineAlternateAlleles(List<PoolGenotypeData> sampleDataList) {
        if (sampleDataList.isEmpty()) {
            return Collections.emptyList();
        }
        boolean REFERENCE_IDX = false;
        List<Allele> allAlleles = sampleDataList.get((int)0).GL.getAlleles();
        double[] likelihoodSums = new double[allAlleles.size()];
        for (PoolGenotypeData sampleData : sampleDataList) {
            Pair<int[], Double> mlACPair = sampleData.GL.getMostLikelyACCount();
            double topLogGL = (Double)mlACPair.second;
            if (sampleData.GL.getAlleles().size() != allAlleles.size()) {
                throw new ReviewedStingException("BUG: inconsistent size of alleles!");
            }
            if (sampleData.GL.alleles.get(0).isNonReference()) {
                throw new ReviewedStingException("BUG: first allele in list is not reference!");
            }
            double refGL = sampleData.GL.getLikelihoods()[0];
            if (((int[])mlACPair.first)[0] == sampleData.GL.numChromosomes) continue;
            for (int i = 0; i < ((int[])mlACPair.first).length; ++i) {
                if (i == 0 || ((int[])mlACPair.first)[i] <= 0) continue;
                int n = i;
                likelihoodSums[n] = likelihoodSums[n] + (topLogGL - refGL);
            }
        }
        ArrayList<Allele> allelesToUse = new ArrayList<Allele>();
        for (int i = 0; i < likelihoodSums.length; ++i) {
            if (!(likelihoodSums[i] > 0.0)) continue;
            allelesToUse.add(allAlleles.get(i));
        }
        return allelesToUse;
    }

    @Override
    public VariantContext getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, List<Allele> allAllelesToUse, boolean useBAQedPileup, GenomeLocParser locParser, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        HashMap<String, ErrorModel> perLaneErrorModels = this.getPerLaneErrorModels(tracker, ref, contexts);
        if (perLaneErrorModels == null && this.UAC.referenceSampleName != null) {
            return null;
        }
        if (this.UAC.TREAT_ALL_READS_AS_SINGLE_POOL) {
            AlignmentContext mergedContext = AlignmentContextUtils.joinContexts(contexts.values());
            HashMap<String, AlignmentContext> newContext = new HashMap<String, AlignmentContext>();
            newContext.put("DummySample1", mergedContext);
            contexts = newContext;
        }
        if (contextType == AlignmentContextUtils.ReadOrientation.COMPLETE) {
            perReadAlleleLikelihoodMap.clear();
        }
        ArrayList<Allele> allAlleles = new ArrayList<Allele>();
        if (allAllelesToUse == null || allAllelesToUse.isEmpty()) {
            allAlleles.addAll(this.getInitialAllelesToUse(tracker, ref, contexts, contextType, locParser, allAllelesToUse));
        } else {
            allAlleles.addAll(allAllelesToUse);
        }
        if (allAlleles.isEmpty()) {
            return null;
        }
        ArrayList<PoolGenotypeData> GLs = new ArrayList<PoolGenotypeData>(contexts.size());
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            GeneralPloidyGenotypeLikelihoods GL;
            int nGoodBases;
            if (this.UAC.referenceSampleName != null && sample.getKey().equals(this.UAC.referenceSampleName)) continue;
            ReadBackedPileup pileup = AlignmentContextUtils.stratify(sample.getValue(), contextType).getBasePileup();
            if (!perReadAlleleLikelihoodMap.containsKey(sample.getKey())) {
                perReadAlleleLikelihoodMap.put(sample.getKey(), new PerReadAlleleLikelihoodMap());
            }
            if ((nGoodBases = (GL = this.getPoolGenotypeLikelihoodObject(allAlleles, null, this.UAC.samplePloidy, perLaneErrorModels, useBAQedPileup, ref, this.UAC.IGNORE_LANE_INFO, perReadAlleleLikelihoodMap.get(sample.getKey()))).add(pileup, this.UAC)) <= 0) continue;
            GLs.add(new PoolGenotypeData(sample.getKey(), GL, this.getFilteredDepth(pileup), allAlleles));
        }
        List<Allele> alleles = this.getFinalAllelesToUse(tracker, ref, allAllelesToUse, GLs);
        if (alleles == null || alleles.isEmpty() || alleles.size() == 1 && alleles.get(0).isReference()) {
            return null;
        }
        GenomeLoc loc = ref.getLocus();
        int endLoc = this.getEndLocation(tracker, ref, alleles);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), endLoc, alleles);
        builder.alleles((Collection<Allele>)alleles);
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (this.UAC.referenceSampleName != null && perLaneErrorModels != null) {
            attributes.put("REFDEPTH", ErrorModel.getTotalReferenceDepth(perLaneErrorModels));
        }
        builder.attributes(attributes);
        GenotypesContext genotypes = GenotypesContext.create();
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        for (PoolGenotypeData sampleData : GLs) {
            double[] myLikelihoods = GeneralPloidyGenotypeLikelihoods.subsetToAlleles(sampleData.GL.getLikelihoods(), sampleData.GL.numChromosomes, allAlleles, alleles);
            GenotypeBuilder gb = new GenotypeBuilder(sampleData.name, noCall);
            gb.DP(sampleData.depth);
            gb.PL(MathUtils.normalizeFromLog10(myLikelihoods, false, true));
            genotypes.add(gb.make());
        }
        return builder.genotypes(genotypes).make();
    }

    protected HashMap<String, ErrorModel> getPerLaneErrorModels(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts) {
        VariantContext refVC = this.getTrueAlleles(tracker, ref, contexts);
        AlignmentContext refContext = null;
        if (this.UAC.referenceSampleName != null) {
            refContext = contexts.get(this.UAC.referenceSampleName);
        }
        ReadBackedPileup refPileup = null;
        if (refContext != null) {
            HashMap<String, ErrorModel> perLaneErrorModels = new HashMap<String, ErrorModel>();
            refPileup = refContext.getBasePileup();
            Set<String> laneIDs = new TreeSet<String>();
            if (this.UAC.TREAT_ALL_READS_AS_SINGLE_POOL || this.UAC.IGNORE_LANE_INFO) {
                laneIDs.add("Lane1");
            } else {
                laneIDs = GeneralPloidyGenotypeLikelihoodsCalculationModel.parseLaneIDs(refPileup.getReadGroups());
            }
            for (String laneID : laneIDs) {
                ReadBackedPileup refLanePileup = refPileup;
                if (refPileup != null && !this.UAC.TREAT_ALL_READS_AS_SINGLE_POOL && !this.UAC.IGNORE_LANE_INFO) {
                    refLanePileup = refPileup.getPileupForLane(laneID);
                }
                perLaneErrorModels.put(laneID, new ErrorModel(this.UAC, refLanePileup, refVC, ref));
            }
            return perLaneErrorModels;
        }
        return null;
    }

    protected abstract GeneralPloidyGenotypeLikelihoods getPoolGenotypeLikelihoodObject(List<Allele> var1, double[] var2, int var3, HashMap<String, ErrorModel> var4, boolean var5, ReferenceContext var6, boolean var7, PerReadAlleleLikelihoodMap var8);

    protected abstract List<Allele> getInitialAllelesToUse(RefMetaDataTracker var1, ReferenceContext var2, Map<String, AlignmentContext> var3, AlignmentContextUtils.ReadOrientation var4, GenomeLocParser var5, List<Allele> var6);

    protected abstract List<Allele> getFinalAllelesToUse(RefMetaDataTracker var1, ReferenceContext var2, List<Allele> var3, ArrayList<PoolGenotypeData> var4);

    protected abstract int getEndLocation(RefMetaDataTracker var1, ReferenceContext var2, List<Allele> var3);

    protected static class PoolGenotypeData {
        public final String name;
        public final GeneralPloidyGenotypeLikelihoods GL;
        public final int depth;
        public final List<Allele> alleles;

        public PoolGenotypeData(String name, GeneralPloidyGenotypeLikelihoods GL, int depth, List<Allele> alleles) {
            this.name = name;
            this.GL = GL;
            this.depth = depth;
            this.alleles = alleles;
        }
    }
}

