/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.ErrorModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyIndelGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.IndelGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.Allele;

public class GeneralPloidyIndelGenotypeLikelihoodsCalculationModel
extends GeneralPloidyGenotypeLikelihoodsCalculationModel {
    private static final int MAX_NUM_ALLELES_TO_GENOTYPE = 4;
    private PairHMMIndelErrorModel pairModel;
    private LinkedHashMap<Allele, Haplotype> haplotypeMap;

    protected GeneralPloidyIndelGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, UAC.pairHMM);
        this.haplotypeMap = new LinkedHashMap();
    }

    @Override
    protected GeneralPloidyGenotypeLikelihoods getPoolGenotypeLikelihoodObject(List<Allele> alleles, double[] logLikelihoods, int ploidy, HashMap<String, ErrorModel> perLaneErrorModels, boolean useBQAedPileup, ReferenceContext ref, boolean ignoreLaneInformation, PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap) {
        return new GeneralPloidyIndelGenotypeLikelihoods(alleles, logLikelihoods, ploidy, perLaneErrorModels, ignoreLaneInformation, this.pairModel, this.haplotypeMap, ref, perReadAlleleLikelihoodMap);
    }

    @Override
    protected List<Allele> getInitialAllelesToUse(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenomeLocParser locParser, List<Allele> allAllelesToUse) {
        List<Allele> alleles = IndelGenotypeLikelihoodsCalculationModel.getInitialAlleleList(tracker, ref, contexts, contextType, locParser, this.UAC, true);
        if (alleles.size() > 4) {
            alleles = alleles.subList(0, 4);
        }
        if (contextType == AlignmentContextUtils.ReadOrientation.COMPLETE) {
            this.haplotypeMap.clear();
        }
        IndelGenotypeLikelihoodsCalculationModel.getHaplotypeMapFromAlleles(alleles, ref, ref.getLocus(), this.haplotypeMap);
        if (this.haplotypeMap.isEmpty()) {
            alleles.clear();
        }
        return alleles;
    }

    @Override
    protected List<Allele> getFinalAllelesToUse(RefMetaDataTracker tracker, ReferenceContext ref, List<Allele> allAllelesToUse, ArrayList<GeneralPloidyGenotypeLikelihoodsCalculationModel.PoolGenotypeData> GLs) {
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        if (allAllelesToUse != null) {
            alleles.addAll(allAllelesToUse);
        } else if (!GLs.isEmpty()) {
            alleles.addAll(GLs.get((int)0).alleles);
        }
        return alleles;
    }

    @Override
    protected int getEndLocation(RefMetaDataTracker tracker, ReferenceContext ref, List<Allele> allelesToUse) {
        return ref.getLocus().getStart() + allelesToUse.get(0).length() - 1;
    }
}

