/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.ErrorModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidySNPGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class GeneralPloidySNPGenotypeLikelihoodsCalculationModel
extends GeneralPloidyGenotypeLikelihoodsCalculationModel {
    protected GeneralPloidySNPGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
    }

    @Override
    protected GeneralPloidyGenotypeLikelihoods getPoolGenotypeLikelihoodObject(List<Allele> alleles, double[] logLikelihoods, int ploidy, HashMap<String, ErrorModel> perLaneErrorModels, boolean useBQAedPileup, ReferenceContext ref, boolean ignoreLaneInformation, PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap) {
        return new GeneralPloidySNPGenotypeLikelihoods(alleles, null, this.UAC.samplePloidy, perLaneErrorModels, useBQAedPileup, this.UAC.IGNORE_LANE_INFO);
    }

    @Override
    protected List<Allele> getInitialAllelesToUse(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenomeLocParser locParser, List<Allele> allAllelesToUse) {
        if (allAllelesToUse != null) {
            return allAllelesToUse;
        }
        byte refBase = ref.getBase();
        ArrayList<Allele> allAlleles = new ArrayList<Allele>();
        allAlleles.add(Allele.create(refBase, true));
        for (byte b : BaseUtils.BASES) {
            if (refBase == b) continue;
            allAlleles.add(Allele.create(b));
        }
        return allAlleles;
    }

    @Override
    protected List<Allele> getFinalAllelesToUse(RefMetaDataTracker tracker, ReferenceContext ref, List<Allele> allAllelesToUse, ArrayList<GeneralPloidyGenotypeLikelihoodsCalculationModel.PoolGenotypeData> GLs) {
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        if (allAllelesToUse != null) {
            alleles.addAll(allAllelesToUse);
        } else if (this.UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vc = UnifiedGenotyperEngine.getVCFromAllelesRod(tracker, ref, ref.getLocus(), true, this.logger, this.UAC.alleles);
            if (vc == null || !vc.isSNP()) {
                return null;
            }
            alleles.addAll(vc.getAlleles());
        } else {
            alleles.add(Allele.create(ref.getBase(), true));
            alleles.addAll(this.determineAlternateAlleles(GLs));
            if (alleles.size() == 1) {
                int indexOfRefBase = BaseUtils.simpleBaseToBaseIndex(ref.getBase());
                if (this.UAC.OutputMode != UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY) {
                    alleles.add(Allele.create(BaseUtils.baseIndexToSimpleBase(indexOfRefBase == 0 ? 1 : 0)));
                }
            }
        }
        return alleles;
    }

    @Override
    protected int getEndLocation(RefMetaDataTracker tracker, ReferenceContext ref, List<Allele> alternateAllelesToUse) {
        return ref.getLocus().getStart();
    }
}

