/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.genotyper.ConsensusAlleleCounter;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.indels.PairHMMIndelErrorModel;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class IndelGenotypeLikelihoodsCalculationModel
extends GenotypeLikelihoodsCalculationModel {
    private static final int HAPLOTYPE_SIZE = 80;
    private boolean DEBUG = false;
    private boolean ignoreSNPAllelesWhenGenotypingIndels = false;
    private PairHMMIndelErrorModel pairModel;
    private LinkedHashMap<Allele, Haplotype> haplotypeMap;
    private List<Allele> alleleList = new ArrayList<Allele>();
    private static final EnumSet<VariantContext.Type> allowableTypes = EnumSet.of(VariantContext.Type.INDEL, VariantContext.Type.MIXED);

    protected IndelGenotypeLikelihoodsCalculationModel(UnifiedArgumentCollection UAC, Logger logger) {
        super(UAC, logger);
        this.pairModel = new PairHMMIndelErrorModel(UAC.INDEL_GAP_OPEN_PENALTY, UAC.INDEL_GAP_CONTINUATION_PENALTY, UAC.OUTPUT_DEBUG_INDEL_INFO, UAC.pairHMM);
        this.DEBUG = UAC.OUTPUT_DEBUG_INDEL_INFO;
        this.haplotypeMap = new LinkedHashMap();
        this.ignoreSNPAllelesWhenGenotypingIndels = UAC.IGNORE_SNP_ALLELES;
    }

    protected static List<Allele> computeConsensusAlleles(ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenomeLocParser locParser, UnifiedArgumentCollection UAC) {
        ConsensusAlleleCounter counter = new ConsensusAlleleCounter(locParser, true, UAC.MIN_INDEL_COUNT_FOR_GENOTYPING, UAC.MIN_INDEL_FRACTION_PER_SAMPLE);
        return counter.computeConsensusAlleles(ref, contexts, contextType);
    }

    @Override
    public VariantContext getLikelihoods(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, List<Allele> allAllelesToUse, boolean useBAQedPileup, GenomeLocParser locParser, Map<String, PerReadAlleleLikelihoodMap> perReadAlleleLikelihoodMap) {
        GenomeLoc loc = ref.getLocus();
        if (contextType == AlignmentContextUtils.ReadOrientation.COMPLETE) {
            this.haplotypeMap.clear();
            perReadAlleleLikelihoodMap.clear();
            this.alleleList = IndelGenotypeLikelihoodsCalculationModel.getInitialAlleleList(tracker, ref, contexts, contextType, locParser, this.UAC, this.ignoreSNPAllelesWhenGenotypingIndels);
            if (this.alleleList.isEmpty()) {
                return null;
            }
        }
        IndelGenotypeLikelihoodsCalculationModel.getHaplotypeMapFromAlleles(this.alleleList, ref, loc, this.haplotypeMap);
        if (this.haplotypeMap == null || this.haplotypeMap.isEmpty()) {
            return null;
        }
        int endLoc = loc.getStart() + this.alleleList.get(0).length() - 1;
        int eventLength = IndelGenotypeLikelihoodsCalculationModel.getEventLength(this.alleleList);
        VariantContextBuilder builder = new VariantContextBuilder("UG_call", loc.getContig(), loc.getStart(), endLoc, this.alleleList);
        GenotypesContext genotypes = GenotypesContext.create();
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        for (Map.Entry<String, AlignmentContext> sample : contexts.entrySet()) {
            ReadBackedPileup pileup;
            AlignmentContext context = AlignmentContextUtils.stratify(sample.getValue(), contextType);
            if (!perReadAlleleLikelihoodMap.containsKey(sample.getKey())) {
                perReadAlleleLikelihoodMap.put(sample.getKey(), new PerReadAlleleLikelihoodMap());
            }
            if ((pileup = context.getBasePileup()) == null) continue;
            GenotypeBuilder b = new GenotypeBuilder(sample.getKey());
            double[] genotypeLikelihoods = this.pairModel.computeDiploidReadHaplotypeLikelihoods(pileup, this.haplotypeMap, ref, eventLength, perReadAlleleLikelihoodMap.get(sample.getKey()), this.UAC.getSampleContamination().get(sample.getKey()), this.UAC.contaminationLog);
            b.PL(genotypeLikelihoods);
            b.DP(this.getFilteredDepth(pileup));
            genotypes.add(b.make());
            if (!this.DEBUG) continue;
            System.out.format("Sample:%s Alleles:%s GL:", sample.getKey(), this.alleleList.toString());
            for (int k = 0; k < genotypeLikelihoods.length; ++k) {
                System.out.format("%1.4f ", genotypeLikelihoods[k]);
            }
            System.out.println();
        }
        return builder.genotypes(genotypes).make();
    }

    public static void getHaplotypeMapFromAlleles(List<Allele> alleleList, ReferenceContext ref, GenomeLoc loc, LinkedHashMap<Allele, Haplotype> haplotypeMap) {
        if (loc.getStart() <= 80) {
            haplotypeMap.clear();
        } else if (ref.getWindow().getStop() < loc.getStop() + 80) {
            haplotypeMap.clear();
        } else if (alleleList.isEmpty()) {
            haplotypeMap.clear();
        } else {
            int eventLength = IndelGenotypeLikelihoodsCalculationModel.getEventLength(alleleList);
            int hsize = ref.getWindow().size() - Math.abs(eventLength) - 1;
            int numPrefBases = ref.getLocus().getStart() - ref.getWindow().getStart() + 1;
            if (hsize <= 0) {
                haplotypeMap.clear();
            } else {
                haplotypeMap.putAll(Haplotype.makeHaplotypeListFromAlleles(alleleList, loc.getStart(), ref, hsize, numPrefBases));
            }
        }
    }

    public static int getEventLength(List<Allele> alleleList) {
        Allele refAllele = alleleList.get(0);
        Allele altAllele = alleleList.get(1);
        int maxLenDiff = 0;
        for (Allele a : alleleList) {
            int lenDiff;
            if (!a.isNonReference() || (lenDiff = Math.abs(a.getBaseString().length() - refAllele.getBaseString().length())) <= maxLenDiff) continue;
            maxLenDiff = lenDiff;
            altAllele = a;
        }
        return altAllele.getBaseString().length() - refAllele.getBaseString().length();
    }

    public static List<Allele> getInitialAlleleList(RefMetaDataTracker tracker, ReferenceContext ref, Map<String, AlignmentContext> contexts, AlignmentContextUtils.ReadOrientation contextType, GenomeLocParser locParser, UnifiedArgumentCollection UAC, boolean ignoreSNPAllelesWhenGenotypingIndels) {
        ArrayList<Allele> alleles = new ArrayList();
        if (UAC.GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            VariantContext vc = null;
            for (VariantContext vc_input : tracker.getValues(UAC.alleles, ref.getLocus())) {
                if (vc_input == null || !allowableTypes.contains((Object)vc_input.getType()) || ref.getLocus().getStart() != vc_input.getStart()) continue;
                vc = vc_input;
                break;
            }
            if (vc == null) {
                return alleles;
            }
            if (ignoreSNPAllelesWhenGenotypingIndels) {
                for (Allele a : vc.getAlleles()) {
                    if (a.isNonReference() && a.getBases().length == vc.getReference().getBases().length) continue;
                    alleles.add(a);
                }
            } else {
                alleles.addAll(vc.getAlleles());
            }
        } else {
            alleles = IndelGenotypeLikelihoodsCalculationModel.computeConsensusAlleles(ref, contexts, contextType, locParser, UAC);
        }
        return alleles;
    }

    @Override
    protected int getFilteredDepth(ReadBackedPileup pileup) {
        int count = 0;
        for (PileupElement p : pileup) {
            if (!p.isDeletion() && !BaseUtils.isRegularBase(p.getBase())) continue;
            count += p.getRepresentativeCount();
        }
        return count;
    }
}

