/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcFactory;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcTestBuilder;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactCallLogger;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class AFCalcPerformanceTest {
    static final Logger logger = Logger.getLogger(AFCalcPerformanceTest.class);

    public static void main(String[] args) throws Exception {
        TTCCLayout layout = new TTCCLayout();
        layout.setThreadPrinting(false);
        layout.setCategoryPrefixing(false);
        layout.setContextPrinting(false);
        logger.addAppender(new ConsoleAppender(layout));
        Operation op = Operation.valueOf(args[0]);
        switch (op) {
            case ANALYZE: {
                AFCalcPerformanceTest.analyze(args);
                break;
            }
            case SINGLE: {
                AFCalcPerformanceTest.profileBig(args);
                break;
            }
            case EXACT_LOG: {
                AFCalcPerformanceTest.exactLog(args);
                break;
            }
            default: {
                throw new IllegalAccessException("unknown operation " + (Object)((Object)op));
            }
        }
    }

    private static void exactLog(String[] args) throws Exception {
        File ref = new File(args[1]);
        File exactLogFile = new File(args[2]);
        LinkedList<Integer> startsToUse = new LinkedList<Integer>();
        for (int i = 3; i < args.length; ++i) {
            startsToUse.add(Integer.valueOf(args[i]));
        }
        CachingIndexedFastaSequenceFile seq = new CachingIndexedFastaSequenceFile(ref);
        GenomeLocParser parser = new GenomeLocParser(seq);
        BufferedReader reader = new BufferedReader(new FileReader(exactLogFile));
        List<ExactCallLogger.ExactCall> loggedCalls = ExactCallLogger.readExactLog(reader, startsToUse, parser);
        for (ExactCallLogger.ExactCall call : loggedCalls) {
            AFCalcTestBuilder testBuilder = new AFCalcTestBuilder(call.vc.getNSamples(), 1, AFCalcFactory.Calculation.EXACT_INDEPENDENT, AFCalcTestBuilder.PriorType.human);
            logger.info(call);
            SimpleTimer timer = new SimpleTimer().start();
            AFCalcResult result = testBuilder.makeModel().getLog10PNonRef(call.vc, testBuilder.makePriors());
            long newNanoTime = timer.getElapsedTimeNano();
            if (call.originalCall.anyPolymorphic(-1.0) || result.anyPolymorphic(-1.0)) {
                logger.info("**** ONE IS POLY");
            }
            logger.info("\t\t getLog10PosteriorOfAFGT0: " + call.originalCall.getLog10PosteriorOfAFGT0() + " vs " + result.getLog10PosteriorOfAFGT0());
            double speedup = (double)call.runtime / (1.0 * (double)newNanoTime);
            logger.info("\t\t runtime:                  " + call.runtime + " vs " + newNanoTime + " speedup " + String.format("%.2f", speedup) + "x");
            for (Allele a : call.originalCall.getAllelesUsedInGenotyping()) {
                if (!a.isNonReference()) continue;
                String warningmeMLE = call.originalCall.getAlleleCountAtMLE(a) != result.getAlleleCountAtMLE(a) ? " DANGER-MLE-DIFFERENT" : "";
                logger.info("\t\t   MLE       " + a + ":            " + call.originalCall.getAlleleCountAtMLE(a) + " vs " + result.getAlleleCountAtMLE(a) + warningmeMLE);
                String warningmePost = call.originalCall.getLog10PosteriorOfAFEq0ForAllele(a) == 0.0 && result.getLog10PosteriorOfAFEq0ForAllele(a) < -10.0 ? " DANGER-POSTERIORS-DIFFERENT" : "";
                logger.info("\t\t   Posterior " + a + ":            " + call.originalCall.getLog10PosteriorOfAFEq0ForAllele(a) + " vs " + result.getLog10PosteriorOfAFEq0ForAllele(a) + warningmePost);
            }
        }
    }

    private static void profileBig(String[] args) throws Exception {
        int nSamples = Integer.valueOf(args[1]);
        int ac = Integer.valueOf(args[2]);
        AFCalcTestBuilder testBuilder = new AFCalcTestBuilder(nSamples, 1, AFCalcFactory.Calculation.EXACT_INDEPENDENT, AFCalcTestBuilder.PriorType.human);
        VariantContext vc = testBuilder.makeACTest(new int[]{ac}, 0, 100);
        SimpleTimer timer = new SimpleTimer().start();
        AFCalcResult resultTracker = testBuilder.makeModel().getLog10PNonRef(vc, testBuilder.makePriors());
        long runtime = timer.getElapsedTimeNano();
        logger.info("result " + resultTracker.getLog10PosteriorOfAFGT0());
        logger.info("runtime " + runtime);
    }

    private static void analyze(String[] args) throws Exception {
        List<String> coreColumns = Arrays.asList("iteration", "n.alt.alleles", "n.samples", "exact.model", "prior.type", "runtime", "n.evaluations");
        PrintStream out = new PrintStream(new FileOutputStream(args[1]));
        List<ModelParams> modelParams = Arrays.asList(new ModelParams(AFCalcFactory.Calculation.EXACT_REFERENCE, 10000, 10), new ModelParams(AFCalcFactory.Calculation.EXACT_INDEPENDENT, 10000, 1000));
        boolean ONLY_HUMAN_PRIORS = false;
        List<AFCalcTestBuilder.PriorType> priorTypes = Arrays.asList(AFCalcTestBuilder.PriorType.human);
        ArrayList<Analysis> analyzes = new ArrayList<Analysis>();
        analyzes.add(new AnalyzeByACAndPL(coreColumns));
        analyzes.add(new AnalyzeBySingletonPosition(coreColumns));
        for (int iteration = 0; iteration < 1; ++iteration) {
            Iterator<Object> i$ = Arrays.asList(1, 2).iterator();
            while (i$.hasNext()) {
                int nAltAlleles = (Integer)i$.next();
                for (int nSamples : Arrays.asList(1, 10, 100, 1000, 10000)) {
                    for (ModelParams modelToRun : modelParams) {
                        if (!modelToRun.meetsConstraints(nAltAlleles, nSamples)) continue;
                        for (AFCalcTestBuilder.PriorType priorType : priorTypes) {
                            AFCalcTestBuilder testBuilder = new AFCalcTestBuilder(nSamples, nAltAlleles, modelToRun.modelType, priorType);
                            for (Analysis analysis : analyzes) {
                                logger.info(Utils.join("\t", Arrays.asList(new Serializable[]{Integer.valueOf(iteration), Integer.valueOf(nAltAlleles), Integer.valueOf(nSamples), modelToRun.modelType, priorType, analysis.getName()})));
                                List<Object> values = Arrays.asList(new Serializable[]{Integer.valueOf(iteration), Integer.valueOf(nAltAlleles), Integer.valueOf(nSamples), modelToRun.modelType, priorType});
                                analysis.run(testBuilder, values);
                            }
                        }
                    }
                }
            }
        }
        GATKReport report = new GATKReport();
        for (Analysis analysis : analyzes) {
            report.addTable(analysis.getTable());
        }
        report.print(out);
        out.close();
    }

    public static enum Operation {
        ANALYZE,
        SINGLE,
        EXACT_LOG;

    }

    private static class ModelParams {
        final AFCalcFactory.Calculation modelType;
        final int maxBiNSamples;
        final int maxTriNSamples;

        private ModelParams(AFCalcFactory.Calculation modelType, int maxBiNSamples, int maxTriNSamples) {
            this.modelType = modelType;
            this.maxBiNSamples = maxBiNSamples;
            this.maxTriNSamples = maxTriNSamples;
        }

        public boolean meetsConstraints(int nAltAlleles, int nSamples) {
            if (nAltAlleles == 1) {
                return nSamples <= this.maxBiNSamples;
            }
            if (nAltAlleles == 2) {
                return nSamples <= this.maxTriNSamples;
            }
            throw new IllegalStateException("Unexpected number of alt alleles " + nAltAlleles);
        }
    }

    private static class AnalyzeByNonInformative
    extends Analysis {
        public AnalyzeByNonInformative(List<String> columns) {
            super("AnalyzeByNonInformative", Utils.append(columns, "non.type.pls", "n.non.informative"));
        }

        @Override
        public void run(AFCalcTestBuilder testBuilder, List<Object> coreValues) {
            SimpleTimer timer = new SimpleTimer();
            for (int nonTypePL : Arrays.asList(100)) {
                AFCalc calc = testBuilder.makeModel();
                double[] priors = testBuilder.makePriors();
                int[] ac = new int[testBuilder.numAltAlleles];
                ac[0] = 1;
                for (int nNonInformative = 0; nNonInformative < testBuilder.nSamples; ++nNonInformative) {
                    VariantContext vc = testBuilder.makeACTest(ac, nNonInformative, nonTypePL);
                    timer.start();
                    AFCalcResult resultTracker = calc.getLog10PNonRef(vc, priors);
                    long runtime = timer.getElapsedTimeNano();
                    LinkedList<Object> columns = new LinkedList<Object>(coreValues);
                    columns.addAll(Arrays.asList(runtime, resultTracker.getnEvaluations(), nonTypePL, nNonInformative));
                    this.report.addRowList(columns);
                }
            }
        }
    }

    private static class AnalyzeBySingletonPosition
    extends Analysis {
        public AnalyzeBySingletonPosition(List<String> columns) {
            super("AnalyzeBySingletonPosition", Utils.append(columns, "non.type.pls", "position.of.singleton"));
        }

        @Override
        public void run(AFCalcTestBuilder testBuilder, List<Object> coreValues) {
            SimpleTimer timer = new SimpleTimer();
            for (int nonTypePL : Arrays.asList(100)) {
                AFCalc calc = testBuilder.makeModel();
                double[] priors = testBuilder.makePriors();
                int[] ac = new int[testBuilder.numAltAlleles];
                ac[0] = 1;
                VariantContext vc = testBuilder.makeACTest(ac, 0, nonTypePL);
                for (int position : MathUtils.log10LinearRange(0, vc.getNSamples(), 0.1)) {
                    VariantContextBuilder vcb = new VariantContextBuilder(vc);
                    ArrayList<Genotype> genotypes = new ArrayList<Genotype>(vc.getGenotypes());
                    Collections.rotate(genotypes, position);
                    vcb.genotypes(genotypes);
                    timer.start();
                    AFCalcResult resultTracker = calc.getLog10PNonRef(vcb.make(), priors);
                    long runtime = timer.getElapsedTimeNano();
                    LinkedList<Object> columns = new LinkedList<Object>(coreValues);
                    columns.addAll(Arrays.asList(runtime, resultTracker.getnEvaluations(), nonTypePL, position));
                    this.report.addRowList(columns);
                }
            }
        }
    }

    private static class AnalyzeByACAndPL
    extends Analysis {
        public AnalyzeByACAndPL(List<String> columns) {
            super("AnalyzeByACAndPL", Utils.append(columns, "non.type.pls", "ac", "n.alt.seg", "other.ac"));
        }

        @Override
        public void run(AFCalcTestBuilder testBuilder, List<Object> coreValues) {
            SimpleTimer timer = new SimpleTimer();
            for (int nonTypePL : Arrays.asList(100)) {
                AFCalc calc = testBuilder.makeModel();
                double[] priors = testBuilder.makePriors();
                for (int[] ACs : this.makeACs(testBuilder.numAltAlleles, testBuilder.nSamples * 2)) {
                    VariantContext vc = testBuilder.makeACTest(ACs, 0, nonTypePL);
                    timer.start();
                    AFCalcResult resultTracker = calc.getLog10PNonRef(vc, priors);
                    long runtime = timer.getElapsedTimeNano();
                    int otherAC = 0;
                    int nAltSeg = 0;
                    for (int i = 0; i < ACs.length; ++i) {
                        nAltSeg += ACs[i] > 0 ? 1 : 0;
                        if (i <= 0) continue;
                        otherAC += ACs[i];
                    }
                    LinkedList<Object> columns = new LinkedList<Object>(coreValues);
                    columns.addAll(Arrays.asList(runtime, resultTracker.getnEvaluations(), nonTypePL, ACs[0], nAltSeg, otherAC));
                    this.report.addRowList(columns);
                }
            }
        }

        private List<int[]> makeACs(int nAltAlleles, int nChrom) {
            if (nAltAlleles > 2) {
                throw new IllegalArgumentException("nAltAlleles must be < 3");
            }
            LinkedList<int[]> ACs = new LinkedList<int[]>();
            List<Integer> ACsToTry = MathUtils.log10LinearRange(0, nChrom, 0.1);
            for (int i : ACsToTry) {
                if (i >= nChrom) continue;
                if (nAltAlleles == 1) {
                    ACs.add(new int[]{i});
                    continue;
                }
                if (nAltAlleles == 2) {
                    for (int j : ACsToTry) {
                        if (j >= nChrom - i) continue;
                        ACs.add(new int[]{i, j});
                    }
                    continue;
                }
                throw new IllegalStateException("cannot get here");
            }
            return ACs;
        }
    }

    private static abstract class Analysis {
        final GATKReport report;

        public Analysis(String name, List<String> columns) {
            this.report = GATKReport.newSimpleReport(name, columns);
        }

        public abstract void run(AFCalcTestBuilder var1, List<Object> var2);

        public String getName() {
            return this.getTable().getTableName();
        }

        public GATKReportTable getTable() {
            return this.report.getTables().iterator().next();
        }
    }
}

