/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.variant.variantcontext.Allele;

public class AFCalcResult {
    private static final int AF0 = 0;
    private static final int AF1p = 1;
    private static final int LOG_10_ARRAY_SIZES = 2;
    private final double[] log10LikelihoodsOfAC;
    private final double[] log10PriorsOfAC;
    private final double[] log10PosteriorsOfAC;
    private final Map<Allele, Double> log10pRefByAllele;
    private final int[] alleleCountsOfMLE;
    int nEvaluations = 0;
    private List<Allele> allelesUsedInGenotyping = null;

    public AFCalcResult(int[] alleleCountsOfMLE, int nEvaluations, List<Allele> allelesUsedInGenotyping, double[] log10LikelihoodsOfAC, double[] log10PriorsOfAC, Map<Allele, Double> log10pRefByAllele) {
        if (allelesUsedInGenotyping == null || allelesUsedInGenotyping.size() < 1) {
            throw new IllegalArgumentException("allelesUsedInGenotyping must be non-null list of at least 1 value " + allelesUsedInGenotyping);
        }
        if (alleleCountsOfMLE == null) {
            throw new IllegalArgumentException("alleleCountsOfMLE cannot be null");
        }
        if (alleleCountsOfMLE.length != allelesUsedInGenotyping.size() - 1) {
            throw new IllegalArgumentException("alleleCountsOfMLE.length " + alleleCountsOfMLE.length + " != allelesUsedInGenotyping.size() " + allelesUsedInGenotyping.size());
        }
        if (nEvaluations < 0) {
            throw new IllegalArgumentException("nEvaluations must be >= 0 but saw " + nEvaluations);
        }
        if (log10LikelihoodsOfAC.length != 2) {
            throw new IllegalArgumentException("log10LikelihoodsOfAC must have length equal 2");
        }
        if (log10PriorsOfAC.length != 2) {
            throw new IllegalArgumentException("log10PriorsOfAC must have length equal 2");
        }
        if (log10pRefByAllele == null) {
            throw new IllegalArgumentException("log10pRefByAllele cannot be null");
        }
        if (log10pRefByAllele.size() != allelesUsedInGenotyping.size() - 1) {
            throw new IllegalArgumentException("log10pRefByAllele has the wrong number of elements: log10pRefByAllele " + log10pRefByAllele + " but allelesUsedInGenotyping " + allelesUsedInGenotyping);
        }
        if (!allelesUsedInGenotyping.containsAll(log10pRefByAllele.keySet())) {
            throw new IllegalArgumentException("log10pRefByAllele doesn't contain all of the alleles used in genotyping: log10pRefByAllele " + log10pRefByAllele + " but allelesUsedInGenotyping " + allelesUsedInGenotyping);
        }
        if (!MathUtils.goodLog10ProbVector(log10LikelihoodsOfAC, 2, false)) {
            throw new IllegalArgumentException("log10LikelihoodsOfAC are bad " + Utils.join(",", log10LikelihoodsOfAC));
        }
        if (!MathUtils.goodLog10ProbVector(log10PriorsOfAC, 2, true)) {
            throw new IllegalArgumentException("log10priors are bad " + Utils.join(",", log10PriorsOfAC));
        }
        this.alleleCountsOfMLE = alleleCountsOfMLE;
        this.nEvaluations = nEvaluations;
        this.allelesUsedInGenotyping = allelesUsedInGenotyping;
        this.log10LikelihoodsOfAC = Arrays.copyOf(log10LikelihoodsOfAC, 2);
        this.log10PriorsOfAC = Arrays.copyOf(log10PriorsOfAC, 2);
        this.log10PosteriorsOfAC = AFCalcResult.computePosteriors(log10LikelihoodsOfAC, log10PriorsOfAC);
        this.log10pRefByAllele = new HashMap<Allele, Double>(log10pRefByAllele);
    }

    public AFCalcResult withNewPriors(double[] log10PriorsOfAC) {
        return new AFCalcResult(this.alleleCountsOfMLE, this.nEvaluations, this.allelesUsedInGenotyping, this.log10LikelihoodsOfAC, log10PriorsOfAC, this.log10pRefByAllele);
    }

    @Ensures(value={"result != null"})
    public int[] getAlleleCountsOfMLE() {
        return this.alleleCountsOfMLE;
    }

    public int getAlleleCountAtMLE(Allele allele) {
        return this.getAlleleCountsOfMLE()[this.altAlleleIndex(allele)];
    }

    public int getnEvaluations() {
        return this.nEvaluations;
    }

    @Ensures(value={"result != null", "! result.isEmpty()"})
    public List<Allele> getAllelesUsedInGenotyping() {
        return this.allelesUsedInGenotyping;
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10PosteriorOfAFEq0() {
        return this.log10PosteriorsOfAC[0];
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10PosteriorOfAFGT0() {
        return this.log10PosteriorsOfAC[1];
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10LikelihoodOfAFEq0() {
        return this.log10LikelihoodsOfAC[0];
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10LikelihoodOfAFGT0() {
        return this.log10LikelihoodsOfAC[1];
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10PriorOfAFEq0() {
        return this.log10PriorsOfAC[0];
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10PriorOfAFGT0() {
        return this.log10PriorsOfAC[1];
    }

    public String toString() {
        LinkedList<String> byAllele = new LinkedList<String>();
        for (Allele a : this.getAllelesUsedInGenotyping()) {
            if (!a.isNonReference()) continue;
            byAllele.add(String.format("%s => MLE %d / posterior %.2f", a, this.getAlleleCountAtMLE(a), this.getLog10PosteriorOfAFEq0ForAllele(a)));
        }
        return String.format("AFCalc%n\t\tlog10PosteriorOfAFGT0=%.2f%n\t\t%s", this.getLog10LikelihoodOfAFGT0(), Utils.join("\n\t\t", byAllele));
    }

    @Requires(value={"MathUtils.goodLog10Probability(log10minPNonRef)"})
    public boolean isPolymorphic(Allele allele, double log10minPNonRef) {
        return this.getLog10PosteriorOfAFEq0ForAllele(allele) < log10minPNonRef;
    }

    public boolean isPolymorphicPhredScaledQual(Allele allele, double minPNonRefPhredScaledQual) {
        if (minPNonRefPhredScaledQual < 0.0) {
            throw new IllegalArgumentException("phredScaledQual " + minPNonRefPhredScaledQual + " < 0 ");
        }
        double log10Threshold = minPNonRefPhredScaledQual / -10.0;
        return this.isPolymorphic(allele, log10Threshold);
    }

    public boolean anyPolymorphic(double log10minPNonRef) {
        for (Allele a : this.getAllelesUsedInGenotyping()) {
            if (!a.isNonReference() || !this.isPolymorphic(a, log10minPNonRef)) continue;
            return true;
        }
        return false;
    }

    @Ensures(value={"MathUtils.goodLog10Probability(result)"})
    public double getLog10PosteriorOfAFEq0ForAllele(Allele allele) {
        Double log10pNonRef = this.log10pRefByAllele.get(allele);
        if (log10pNonRef == null) {
            throw new IllegalArgumentException("Unknown allele " + allele);
        }
        return log10pNonRef;
    }

    @Requires(value={"log10LikelihoodsOfAC.length == log10PriorsOfAC.length"})
    @Ensures(value={"MathUtils.goodLog10ProbVector(result, LOG_10_ARRAY_SIZES, true)"})
    private static double[] computePosteriors(double[] log10LikelihoodsOfAC, double[] log10PriorsOfAC) {
        double[] log10UnnormalizedPosteriors = new double[log10LikelihoodsOfAC.length];
        for (int i = 0; i < log10LikelihoodsOfAC.length; ++i) {
            log10UnnormalizedPosteriors[i] = log10LikelihoodsOfAC[i] + log10PriorsOfAC[i];
        }
        return MathUtils.normalizeFromLog10(log10UnnormalizedPosteriors, true, false);
    }

    @Requires(value={"allele != null"})
    @Ensures(value={"result >= 0", "result < allelesUsedInGenotyping.size() - 1"})
    private int altAlleleIndex(Allele allele) {
        if (allele.isReference()) {
            throw new IllegalArgumentException("Cannot get the alt allele index for reference allele " + allele);
        }
        int index = this.allelesUsedInGenotyping.indexOf(allele);
        if (index == -1) {
            throw new IllegalArgumentException("could not find allele " + allele + " in " + this.allelesUsedInGenotyping);
        }
        return index - 1;
    }
}

