/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcFactory;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class AFCalcTestBuilder {
    static final Allele A = Allele.create("A", true);
    static final Allele C = Allele.create("C");
    static final Allele G = Allele.create("G");
    static final Allele T = Allele.create("T");
    static final Allele AA = Allele.create("AA");
    static final Allele AT = Allele.create("AT");
    static final Allele AG = Allele.create("AG");
    static int sampleNameCounter = 0;
    final int nSamples;
    final int numAltAlleles;
    final AFCalcFactory.Calculation modelType;
    final PriorType priorType;

    public AFCalcTestBuilder(int nSamples, int numAltAlleles, AFCalcFactory.Calculation modelType, PriorType priorType) {
        this.nSamples = nSamples;
        this.numAltAlleles = numAltAlleles;
        this.modelType = modelType;
        this.priorType = priorType;
    }

    public String toString() {
        return String.format("AFCalcTestBuilder nSamples=%d nAlts=%d model=%s prior=%s", new Object[]{this.nSamples, this.numAltAlleles, this.modelType, this.priorType});
    }

    public int getNumAltAlleles() {
        return this.numAltAlleles;
    }

    public int getnSamples() {
        return this.nSamples;
    }

    public AFCalc makeModel() {
        return AFCalcFactory.createAFCalc(this.modelType, this.nSamples, this.getNumAltAlleles(), 2);
    }

    public double[] makePriors() {
        int nPriorValues = 2 * this.nSamples + 1;
        switch (this.priorType) {
            case flat: {
                return MathUtils.normalizeFromLog10(new double[nPriorValues], true);
            }
            case human: {
                double[] humanPriors = new double[nPriorValues];
                UnifiedGenotyperEngine.computeAlleleFrequencyPriors(nPriorValues - 1, humanPriors, 0.001);
                return humanPriors;
            }
        }
        throw new RuntimeException("Unexpected type " + (Object)((Object)this.priorType));
    }

    public VariantContext makeACTest(List<Integer> ACs, int nNonInformative, int nonTypePL) {
        return this.makeACTest(ArrayUtils.toPrimitive(ACs.toArray(new Integer[0])), nNonInformative, nonTypePL);
    }

    public VariantContext makeACTest(int[] ACs, int nNonInformative, int nonTypePL) {
        int nChrom = this.nSamples * 2;
        int[] nhet = new int[this.numAltAlleles];
        int[] nhomvar = new int[this.numAltAlleles];
        for (int i = 0; i < ACs.length; ++i) {
            double p = (double)ACs[i] / (1.0 * (double)nChrom);
            nhomvar[i] = (int)Math.floor((double)(this.nSamples - nNonInformative) * p * p);
            nhet[i] = ACs[i] - 2 * nhomvar[i];
            if (nhet[i] >= 0) continue;
            throw new IllegalStateException("Bug! nhet[i] < 0");
        }
        long calcAC = MathUtils.sum(nhet) + 2L * MathUtils.sum(nhomvar);
        if (calcAC != MathUtils.sum(ACs)) {
            throw new IllegalStateException("calculated AC " + calcAC + " not equal to desired AC " + Utils.join(",", ACs));
        }
        return this.makeACTest(nhet, nhomvar, nNonInformative, nonTypePL);
    }

    public VariantContext makeACTest(int[] nhet, int[] nhomvar, int nNonInformative, int nonTypePL) {
        List<Genotype> samples = new ArrayList<Genotype>(this.nSamples);
        for (int altI = 0; altI < nhet.length; ++altI) {
            int i;
            for (i = 0; i < nhet[altI]; ++i) {
                samples.add(this.makePL(GenotypeType.HET, nonTypePL, altI + 1));
            }
            for (i = 0; i < nhomvar[altI]; ++i) {
                samples.add(this.makePL(GenotypeType.HOM_VAR, nonTypePL, altI + 1));
            }
        }
        Genotype nonInformative = this.makeNonInformative();
        samples.addAll(Collections.nCopies(nNonInformative, nonInformative));
        int nRef = Math.max((int)((long)(this.nSamples - nNonInformative) - MathUtils.sum(nhet) - MathUtils.sum(nhomvar)), 0);
        samples.addAll(Collections.nCopies(nRef, this.makePL(GenotypeType.HOM_REF, nonTypePL, 0)));
        samples = samples.subList(0, this.nSamples);
        if (samples.size() > this.nSamples) {
            throw new IllegalStateException("too many samples");
        }
        VariantContextBuilder vcb = new VariantContextBuilder("x", "1", 1L, 1L, this.getAlleles());
        vcb.genotypes(samples);
        return vcb.make();
    }

    public List<Allele> getAlleles() {
        return Arrays.asList(A, C, G, T, AA, AT, AG).subList(0, this.numAltAlleles + 1);
    }

    public List<Allele> getAlleles(GenotypeType type, int altI) {
        switch (type) {
            case HOM_REF: {
                return Arrays.asList(this.getAlleles().get(0), this.getAlleles().get(0));
            }
            case HET: {
                return Arrays.asList(this.getAlleles().get(0), this.getAlleles().get(altI));
            }
            case HOM_VAR: {
                return Arrays.asList(this.getAlleles().get(altI), this.getAlleles().get(altI));
            }
        }
        throw new IllegalArgumentException("Unexpected type " + (Object)((Object)type));
    }

    public Genotype makePL(List<Allele> expectedGT, int ... pls) {
        GenotypeBuilder gb = new GenotypeBuilder("sample" + sampleNameCounter++);
        gb.alleles(expectedGT);
        gb.PL(pls);
        return gb.make();
    }

    private int numPLs() {
        return GenotypeLikelihoods.numLikelihoods(this.numAltAlleles + 1, 2);
    }

    public Genotype makeNonInformative() {
        int[] nonInformativePLs = new int[GenotypeLikelihoods.numLikelihoods(this.numAltAlleles, 2)];
        return this.makePL(Arrays.asList(Allele.NO_CALL, Allele.NO_CALL), nonInformativePLs);
    }

    public Genotype makePL(GenotypeType type, int nonTypePL, int altI) {
        GenotypeBuilder gb = new GenotypeBuilder("sample" + sampleNameCounter++);
        gb.alleles(this.getAlleles(type, altI));
        int[] pls = new int[this.numPLs()];
        Arrays.fill(pls, nonTypePL);
        int index = 0;
        switch (type) {
            case HOM_REF: {
                index = GenotypeLikelihoods.calculatePLindex(0, 0);
                break;
            }
            case HET: {
                index = GenotypeLikelihoods.calculatePLindex(0, altI);
                break;
            }
            case HOM_VAR: {
                index = GenotypeLikelihoods.calculatePLindex(altI, altI);
            }
        }
        pls[index] = 0;
        gb.PL(pls);
        return gb.make();
    }

    public static enum PriorType {
        flat,
        human;

    }
}

