/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.util.Arrays;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACcounts;
import org.broadinstitute.sting.utils.MathUtils;

public final class ExactACset {
    private final ExactACcounts ACcounts;
    private final double[] log10Likelihoods;
    int sum = -1;

    public ExactACset(int size, ExactACcounts ACcounts) {
        this.ACcounts = ACcounts;
        this.log10Likelihoods = new double[size];
        Arrays.fill(this.log10Likelihoods, Double.NEGATIVE_INFINITY);
    }

    public int getACsum() {
        if (this.sum == -1) {
            this.sum = (int)MathUtils.sum(this.getACcounts().getCounts());
        }
        return this.sum;
    }

    public boolean equals(Object obj) {
        return obj instanceof ExactACset && this.getACcounts().equals(((ExactACset)obj).getACcounts());
    }

    public ExactACcounts getACcounts() {
        return this.ACcounts;
    }

    public double[] getLog10Likelihoods() {
        return this.log10Likelihoods;
    }
}

