/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import com.google.java.contract.Requires;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.utils.AutoFormattingTime;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class ExactCallLogger
implements Cloneable {
    private PrintStream callReport = null;

    public ExactCallLogger(File outputFile) {
        try {
            this.callReport = new PrintStream(new BufferedOutputStream(new FileOutputStream(outputFile), 10000000));
            this.callReport.println(Utils.join("\t", Arrays.asList("loc", "variable", "key", "value")));
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotCreateOutputFile(outputFile, (Exception)e);
        }
    }

    protected final void printCallInfo(VariantContext vc, double[] log10AlleleFrequencyPriors, long runtimeNano, AFCalcResult result) {
        this.printCallElement(vc, "type", "ignore", (Object)vc.getType());
        int allelei = 0;
        for (Allele a : vc.getAlleles()) {
            this.printCallElement(vc, "allele", allelei++, a.getDisplayString());
        }
        for (Genotype g : vc.getGenotypes()) {
            this.printCallElement(vc, "PL", g.getSampleName(), g.getLikelihoodsString());
        }
        for (int priorI = 0; priorI < log10AlleleFrequencyPriors.length; ++priorI) {
            this.printCallElement(vc, "priorI", priorI, log10AlleleFrequencyPriors[priorI]);
        }
        this.printCallElement(vc, "runtime.nano", "ignore", runtimeNano);
        this.printCallElement(vc, "log10PosteriorOfAFEq0", "ignore", result.getLog10PosteriorOfAFEq0());
        this.printCallElement(vc, "log10PosteriorOfAFGt0", "ignore", result.getLog10PosteriorOfAFGT0());
        for (Allele allele : result.getAllelesUsedInGenotyping()) {
            if (!allele.isNonReference()) continue;
            this.printCallElement(vc, "MLE", allele, result.getAlleleCountAtMLE(allele));
            this.printCallElement(vc, "pRefByAllele", allele, result.getLog10PosteriorOfAFEq0ForAllele(allele));
        }
        this.callReport.flush();
    }

    @Requires(value={"vc != null", "variable != null", "key != null", "value != null", "callReport != null"})
    private void printCallElement(VariantContext vc, Object variable, Object key, Object value) {
        String loc = String.format("%s:%d", vc.getChr(), vc.getStart());
        this.callReport.println(Utils.join("\t", Arrays.asList(loc, variable, key, value)));
    }

    public static List<ExactCall> readExactLog(BufferedReader reader, List<Integer> startsToKeep, GenomeLocParser parser) throws IOException {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null");
        }
        if (startsToKeep == null) {
            throw new IllegalArgumentException("startsToKeep cannot be null");
        }
        if (parser == null) {
            throw new IllegalArgumentException("GenomeLocParser cannot be null");
        }
        LinkedList<ExactCall> calls = new LinkedList<ExactCall>();
        reader.readLine();
        reader.readLine();
        block0: while (true) {
            VariantContextBuilder builder = new VariantContextBuilder();
            ArrayList<Allele> alleles = new ArrayList<Allele>();
            ArrayList<Genotype> genotypes = new ArrayList<Genotype>();
            double[] posteriors = new double[2];
            double[] priors = MathUtils.normalizeFromLog10(new double[]{0.5, 0.5}, true);
            ArrayList<Integer> mle = new ArrayList<Integer>();
            HashMap<Allele, Double> log10pRefByAllele = new HashMap<Allele, Double>();
            long runtimeNano = -1L;
            GenomeLoc currentLoc = null;
            while (true) {
                String line;
                if ((line = reader.readLine()) == null) {
                    return calls;
                }
                String[] parts = line.split("\t");
                GenomeLoc lineLoc = parser.parseGenomeLoc(parts[0]);
                String variable = parts[1];
                String key = parts[2];
                String value = parts[3];
                if (currentLoc == null) {
                    currentLoc = lineLoc;
                }
                if (variable.equals("type")) {
                    if (!startsToKeep.isEmpty() && !startsToKeep.contains(currentLoc.getStart())) continue block0;
                    builder.alleles((Collection<Allele>)alleles);
                    int stop = currentLoc.getStart() + ((Allele)alleles.get(0)).length() - 1;
                    builder.chr(currentLoc.getContig()).start(currentLoc.getStart()).stop(stop);
                    builder.genotypes(genotypes);
                    int[] mleInts = ArrayUtils.toPrimitive(mle.toArray(new Integer[0]));
                    AFCalcResult result = new AFCalcResult(mleInts, 1, alleles, posteriors, priors, log10pRefByAllele);
                    calls.add(new ExactCall(builder.make(), runtimeNano, result));
                    continue block0;
                }
                if (variable.equals("allele")) {
                    boolean isRef = key.equals("0");
                    alleles.add(Allele.create(value, isRef));
                    continue;
                }
                if (variable.equals("PL")) {
                    GenotypeBuilder gb = new GenotypeBuilder(key);
                    gb.PL(GenotypeLikelihoods.fromPLField(value).getAsPLs());
                    genotypes.add(gb.make());
                    continue;
                }
                if (variable.equals("log10PosteriorOfAFEq0")) {
                    posteriors[0] = Double.valueOf(value);
                    continue;
                }
                if (variable.equals("log10PosteriorOfAFGt0")) {
                    posteriors[1] = Double.valueOf(value);
                    continue;
                }
                if (variable.equals("MLE")) {
                    mle.add(Integer.valueOf(value));
                    continue;
                }
                if (variable.equals("pRefByAllele")) {
                    Allele a = Allele.create(key);
                    log10pRefByAllele.put(a, Double.valueOf(value));
                    continue;
                }
                if (!variable.equals("runtime.nano")) continue;
                runtimeNano = Long.valueOf(value);
            }
            break;
        }
    }

    public static class ExactCall {
        final VariantContext vc;
        final long runtime;
        final AFCalcResult originalCall;

        public ExactCall(VariantContext vc, long runtime, AFCalcResult originalCall) {
            this.vc = vc;
            this.runtime = runtime;
            this.originalCall = originalCall;
        }

        public String toString() {
            return String.format("ExactCall %s:%d alleles=%s nSamples=%s orig.pNonRef=%.2f orig.runtime=%s", this.vc.getChr(), this.vc.getStart(), this.vc.getAlleles(), this.vc.getNSamples(), this.originalCall.getLog10PosteriorOfAFGT0(), new AutoFormattingTime(this.runtime).toString());
        }
    }
}

