/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.sting.gatk.walkers.genotyper.GeneralPloidyGenotypeLikelihoods;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACcounts;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACset;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactAFCalc;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;

public class GeneralPloidyExactAFCalc
extends ExactAFCalc {
    static final int MAX_LENGTH_FOR_POOL_PL_LOGGING = 10;
    private final int ploidy;
    private static final double MAX_LOG10_ERROR_TO_STOP_EARLY = 6.0;
    private static final boolean VERBOSE = false;
    private static final int PL_INDEX_OF_HOM_REF = 0;

    protected GeneralPloidyExactAFCalc(int nSamples, int maxAltAlleles, int ploidy) {
        super(nSamples, maxAltAlleles, ploidy);
        this.ploidy = ploidy;
    }

    @Override
    protected VariantContext reduceScope(VariantContext vc) {
        if (vc.getAlternateAlleles().size() > this.getMaxAltAlleles()) {
            this.logger.warn("this tool is currently set to genotype at most " + this.getMaxAltAlleles() + " alternate alleles in a given context, but the context at " + vc.getChr() + ":" + vc.getStart() + " has " + vc.getAlternateAlleles().size() + " alternate alleles so only the top alleles will be used; see the --max_alternate_alleles argument");
            ArrayList<Allele> alleles = new ArrayList<Allele>(this.getMaxAltAlleles() + 1);
            alleles.add(vc.getReference());
            alleles.addAll(GeneralPloidyExactAFCalc.chooseMostLikelyAlternateAlleles(vc, this.getMaxAltAlleles(), this.ploidy));
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            builder.alleles((Collection<Allele>)alleles);
            builder.genotypes(this.subsetAlleles(vc, alleles, false, this.ploidy));
            return builder.make();
        }
        return vc;
    }

    @Override
    public AFCalcResult computeLog10PNonRef(VariantContext vc, double[] log10AlleleFrequencyPriors) {
        this.combineSinglePools(vc.getGenotypes(), vc.getNAlleles(), this.ploidy, log10AlleleFrequencyPriors);
        return this.getResultFromFinalState(vc, log10AlleleFrequencyPriors);
    }

    private static List<Allele> chooseMostLikelyAlternateAlleles(VariantContext vc, int numAllelesToChoose, int ploidy) {
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        ExactAFCalc.LikelihoodSum[] likelihoodSums = new ExactAFCalc.LikelihoodSum[numOriginalAltAlleles];
        for (int i = 0; i < numOriginalAltAlleles; ++i) {
            likelihoodSums[i] = new ExactAFCalc.LikelihoodSum(vc.getAlternateAllele(i));
        }
        ArrayList<double[]> GLs = GeneralPloidyExactAFCalc.getGLs(vc.getGenotypes(), false);
        for (double[] likelihoods : GLs) {
            int PLindexOfBestGL = MathUtils.maxElementIndex(likelihoods);
            int[] acCount = GeneralPloidyGenotypeLikelihoods.getAlleleCountFromPLIndex(1 + numOriginalAltAlleles, ploidy, PLindexOfBestGL);
            for (int k = 1; k < acCount.length; ++k) {
                if (acCount[k] <= 0) continue;
                likelihoodSums[k - 1].sum += (double)acCount[k] * (likelihoods[PLindexOfBestGL] - likelihoods[0]);
            }
        }
        Collections.sort(Arrays.asList(likelihoodSums));
        ArrayList<Allele> bestAlleles = new ArrayList<Allele>(numAllelesToChoose);
        for (int i = 0; i < numAllelesToChoose; ++i) {
            bestAlleles.add(likelihoodSums[i].allele);
        }
        ArrayList<Allele> orderedBestAlleles = new ArrayList<Allele>(numAllelesToChoose);
        for (Allele allele : vc.getAlternateAlleles()) {
            if (!bestAlleles.contains(allele)) continue;
            orderedBestAlleles.add(allele);
        }
        return orderedBestAlleles;
    }

    protected void combineSinglePools(GenotypesContext GLs, int numAlleles, int ploidyPerPool, double[] log10AlleleFrequencyPriors) {
        ArrayList<double[]> genotypeLikelihoods = GeneralPloidyExactAFCalc.getGLs(GLs, true);
        int combinedPloidy = 0;
        CombinedPoolLikelihoods combinedPoolLikelihoods = new CombinedPoolLikelihoods();
        int[] zeroCounts = new int[numAlleles];
        ExactACset set = new ExactACset(1, new ExactACcounts(zeroCounts));
        set.getLog10Likelihoods()[0] = 0.0;
        combinedPoolLikelihoods.add(set);
        if (genotypeLikelihoods.size() <= 1) {
            this.getStateTracker().reset();
            this.getStateTracker().setLog10LikelihoodOfAFzero(0.0);
        } else {
            for (int p = 1; p < genotypeLikelihoods.size(); ++p) {
                this.getStateTracker().reset();
                combinedPoolLikelihoods = this.fastCombineMultiallelicPool(combinedPoolLikelihoods, genotypeLikelihoods.get(p), combinedPloidy, ploidyPerPool, numAlleles, log10AlleleFrequencyPriors);
                combinedPloidy = ploidyPerPool + combinedPloidy;
            }
        }
    }

    public CombinedPoolLikelihoods fastCombineMultiallelicPool(CombinedPoolLikelihoods originalPool, double[] newGL, int originalPloidy, int newGLPloidy, int numAlleles, double[] log10AlleleFrequencyPriors) {
        int newPloidy;
        LinkedList<ExactACset> ACqueue = new LinkedList<ExactACset>();
        HashMap<ExactACcounts, ExactACset> indexesToACset = new HashMap<ExactACcounts, ExactACset>();
        CombinedPoolLikelihoods newPool = new CombinedPoolLikelihoods();
        int[] zeroCounts = new int[numAlleles];
        zeroCounts[0] = newPloidy = originalPloidy + newGLPloidy;
        ExactACset zeroSet = new ExactACset(1, new ExactACcounts(zeroCounts));
        ACqueue.add(zeroSet);
        indexesToACset.put(zeroSet.getACcounts(), zeroSet);
        while (!ACqueue.isEmpty()) {
            this.getStateTracker().incNEvaluations();
            ExactACset ACset = (ExactACset)ACqueue.remove();
            double log10LofKs = this.calculateACConformationAndUpdateQueue(ACset, newPool, originalPool, newGL, log10AlleleFrequencyPriors, originalPloidy, newGLPloidy, ACqueue, indexesToACset);
            indexesToACset.remove(ACset.getACcounts());
        }
        return newPool;
    }

    private double calculateACConformationAndUpdateQueue(ExactACset set, CombinedPoolLikelihoods newPool, CombinedPoolLikelihoods originalPool, double[] newGL, double[] log10AlleleFrequencyPriors, int originalPloidy, int newGLPloidy, LinkedList<ExactACset> ACqueue, HashMap<ExactACcounts, ExactACset> indexesToACset) {
        int numAlleles = set.getACcounts().getCounts().length;
        int newPloidy = set.getACsum();
        double log10LofK = this.computeLofK(set, originalPool, newGL, log10AlleleFrequencyPriors, numAlleles, originalPloidy, newGLPloidy);
        if (!Double.isInfinite(log10LofK)) {
            newPool.add(set);
        }
        if (this.getStateTracker().abort(log10LofK, set.getACcounts(), false)) {
            return log10LofK;
        }
        int ACwiggle = set.getACcounts().getCounts()[0];
        if (ACwiggle == 0) {
            return log10LofK;
        }
        for (int allele = 1; allele < numAlleles; ++allele) {
            int[] ACcountsClone = (int[])set.getACcounts().getCounts().clone();
            int n = allele;
            ACcountsClone[n] = ACcountsClone[n] + 1;
            int altSum = (int)MathUtils.sum(ACcountsClone) - ACcountsClone[0];
            ACcountsClone[0] = newPloidy - altSum;
            if (ACcountsClone[0] < 0) continue;
            GeneralPloidyGenotypeLikelihoods.updateACset(ACcountsClone, ACqueue, indexesToACset);
        }
        return log10LofK;
    }

    private double computeLofK(ExactACset set, CombinedPoolLikelihoods firstGLs, double[] secondGL, double[] log10AlleleFrequencyPriors, int numAlleles, int ploidy1, int ploidy2) {
        int newPloidy = ploidy1 + ploidy2;
        int totalAltK = set.getACsum();
        if (newPloidy != totalAltK) {
            throw new ReviewedStingException("BUG: inconsistent sizes of set.getACsum and passed ploidy values");
        }
        if ((totalAltK -= set.getACcounts().getCounts()[0]) == 0) {
            double log10Lof0;
            set.getLog10Likelihoods()[0] = log10Lof0 = firstGLs.getGLOfACZero() + secondGL[0];
            this.getStateTracker().setLog10LikelihoodOfAFzero(log10Lof0);
            this.getStateTracker().setLog10PosteriorOfAFzero(log10Lof0 + log10AlleleFrequencyPriors[0]);
            return log10Lof0;
        }
        int[] currentCount = set.getACcounts().getCounts();
        double denom = -MathUtils.log10MultinomialCoefficient(newPloidy, currentCount);
        GeneralPloidyGenotypeLikelihoods.SumIterator innerIterator = new GeneralPloidyGenotypeLikelihoods.SumIterator(numAlleles, ploidy2);
        set.getLog10Likelihoods()[0] = Double.NEGATIVE_INFINITY;
        while (innerIterator.hasNext()) {
            double gl2;
            int[] acCount2 = innerIterator.getCurrentVector();
            int[] acCount1 = MathUtils.vectorDiff(currentCount, acCount2);
            int idx2 = innerIterator.getLinearIndex();
            if (GeneralPloidyExactAFCalc.isValidConformation(acCount1, ploidy1) && firstGLs.hasConformation(acCount1) && !Double.isInfinite(gl2 = secondGL[idx2])) {
                double firstGL = firstGLs.getLikelihoodOfConformation(acCount1);
                double num1 = MathUtils.log10MultinomialCoefficient(ploidy1, acCount1);
                double num2 = MathUtils.log10MultinomialCoefficient(ploidy2, acCount2);
                double sum = firstGL + gl2 + num1 + num2;
                set.getLog10Likelihoods()[0] = MathUtils.approximateLog10SumLog10(set.getLog10Likelihoods()[0], sum);
            }
            innerIterator.next();
        }
        double[] dArray = set.getLog10Likelihoods();
        dArray[0] = dArray[0] + denom;
        double log10LofK = set.getLog10Likelihoods()[0];
        int[] altCounts = Arrays.copyOfRange(set.getACcounts().getCounts(), 1, set.getACcounts().getCounts().length);
        this.getStateTracker().updateMLEifNeeded(Math.max(log10LofK, -1.7976931348623157E308), altCounts);
        for (int ACcount : altCounts) {
            if (ACcount <= 0) continue;
            log10LofK += log10AlleleFrequencyPriors[ACcount];
        }
        this.getStateTracker().updateMAPifNeeded(Math.max(log10LofK, -1.7976931348623157E308), altCounts);
        return log10LofK;
    }

    private static boolean isValidConformation(int[] set, int ploidy) {
        int sum = 0;
        for (int ac : set) {
            if (ac < 0) {
                return false;
            }
            sum += ac;
        }
        return sum == ploidy;
    }

    @Override
    public GenotypesContext subsetAlleles(VariantContext vc, List<Allele> allelesToUse, boolean assignGenotypes, int ploidy) {
        GenotypesContext oldGTs = vc.getGenotypes();
        ArrayList<Allele> NO_CALL_ALLELES = new ArrayList<Allele>(ploidy);
        for (int k = 0; k < ploidy; ++k) {
            NO_CALL_ALLELES.add(Allele.NO_CALL);
        }
        List<String> sampleIndices = oldGTs.getSampleNamesOrderedByName();
        GenotypesContext newGTs = GenotypesContext.create();
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        int numNewAltAlleles = allelesToUse.size() - 1;
        for (int k = 0; k < oldGTs.size(); ++k) {
            double[] newLikelihoods;
            Genotype g = oldGTs.get(sampleIndices.get(k));
            if (!g.hasLikelihoods()) {
                newGTs.add(GenotypeBuilder.create(g.getSampleName(), NO_CALL_ALLELES));
                continue;
            }
            double[] originalLikelihoods = g.getLikelihoods().getAsVector();
            if (numOriginalAltAlleles == numNewAltAlleles || numNewAltAlleles == 0) {
                newLikelihoods = originalLikelihoods;
            } else {
                newLikelihoods = GeneralPloidyGenotypeLikelihoods.subsetToAlleles(originalLikelihoods, ploidy, vc.getAlleles(), allelesToUse);
                newLikelihoods = MathUtils.normalizeFromLog10(newLikelihoods, false, true);
            }
            if (MathUtils.sum(newLikelihoods) > -0.1) {
                newGTs.add(GenotypeBuilder.create(g.getSampleName(), NO_CALL_ALLELES));
                continue;
            }
            GenotypeBuilder gb = new GenotypeBuilder(g);
            if (numNewAltAlleles == 0) {
                gb.noPL();
            } else {
                gb.PL(newLikelihoods);
            }
            if (!assignGenotypes || MathUtils.sum(newLikelihoods) > -0.1) {
                gb.alleles(NO_CALL_ALLELES);
            } else {
                this.assignGenotype(gb, newLikelihoods, allelesToUse, ploidy);
            }
            newGTs.add(gb.make());
        }
        return newGTs;
    }

    private void assignGenotype(GenotypeBuilder gb, double[] newLikelihoods, List<Allele> allelesToUse, int numChromosomes) {
        int numNewAltAlleles = allelesToUse.size() - 1;
        int PLindex = numNewAltAlleles == 0 ? 0 : MathUtils.maxElementIndex(newLikelihoods);
        int[] mlAlleleCount = GeneralPloidyGenotypeLikelihoods.getAlleleCountFromPLIndex(allelesToUse.size(), numChromosomes, PLindex);
        ArrayList<Double> alleleFreqs = new ArrayList<Double>();
        ArrayList<Integer> alleleCounts = new ArrayList<Integer>();
        for (int k = 1; k < mlAlleleCount.length; ++k) {
            alleleCounts.add(mlAlleleCount[k]);
            double freq = (double)mlAlleleCount[k] / (double)numChromosomes;
            alleleFreqs.add(freq);
        }
        gb.attribute("MLPSAC", alleleCounts.size() == 1 ? (Serializable)alleleCounts.get(0) : alleleCounts);
        gb.attribute("MLPSAF", alleleFreqs.size() == 1 ? (Serializable)alleleFreqs.get(0) : alleleFreqs);
        if (newLikelihoods.length > 10) {
            gb.noPL();
        }
        ArrayList<Allele> myAlleles = new ArrayList<Allele>();
        int idx = 0;
        for (int mlind = 0; mlind < mlAlleleCount.length; ++mlind) {
            for (int k = 0; k < mlAlleleCount[mlind]; ++k) {
                myAlleles.add(idx++, allelesToUse.get(mlind));
            }
        }
        gb.alleles(myAlleles);
        if (numNewAltAlleles > 0) {
            gb.log10PError(GenotypeLikelihoods.getGQLog10FromLikelihoods(PLindex, newLikelihoods));
        }
    }

    static class CombinedPoolLikelihoods {
        private LinkedList<ExactACset> alleleCountSetList = new LinkedList();
        private HashMap<ExactACcounts, ExactACset> conformationMap = new HashMap();
        private double maxLikelihood = Double.NEGATIVE_INFINITY;

        public void add(ExactACset set) {
            this.alleleCountSetList.add(set);
            this.conformationMap.put(set.getACcounts(), set);
            double likelihood = set.getLog10Likelihoods()[0];
            if (likelihood > this.maxLikelihood) {
                this.maxLikelihood = likelihood;
            }
        }

        public boolean hasConformation(int[] ac) {
            return this.conformationMap.containsKey(new ExactACcounts(ac));
        }

        public double getLikelihoodOfConformation(int[] ac) {
            return this.conformationMap.get(new ExactACcounts(ac)).getLog10Likelihoods()[0];
        }

        public double getGLOfACZero() {
            return this.alleleCountSetList.get(0).getLog10Likelihoods()[0];
        }

        public int getLength() {
            return this.alleleCountSetList.size();
        }
    }
}

