/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.genotyper.afcalc;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.ExactACcounts;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.variant.variantcontext.Allele;

final class StateTracker {
    protected static final double VALUE_NOT_CALCULATED = Double.NEGATIVE_INFINITY;
    protected static final double MAX_LOG10_ERROR_TO_STOP_EARLY = 6.0;
    protected double log10MLE;
    protected double log10MAP;
    private final int[] alleleCountsOfMLE;
    private final int[] alleleCountsOfMAP;
    private final double[] log10LikelihoodsForAFGt0 = new double[5000];
    private static final int LIKELIHOODS_CACHE_SIZE = 5000;
    private int log10LikelihoodsForAFGt0CacheIndex = 0;
    protected Double log10LikelihoodsForAFGt0Sum = null;
    private double log10LikelihoodOfAFzero = 0.0;
    private int nEvaluations = 0;
    private List<Allele> allelesUsedInGenotyping = null;

    public StateTracker(int maxAltAlleles) {
        if (maxAltAlleles < 1) {
            throw new IllegalArgumentException("maxAltAlleles must be >= 0, saw " + maxAltAlleles);
        }
        this.alleleCountsOfMLE = new int[maxAltAlleles];
        this.alleleCountsOfMAP = new int[maxAltAlleles];
        this.reset();
    }

    private boolean tooLowLikelihood(double log10LofK) {
        return log10LofK < this.log10MLE - 6.0;
    }

    private boolean isLowerAC(ExactACcounts otherACs) {
        int[] otherACcounts = otherACs.getCounts();
        for (int i = 0; i < otherACcounts.length; ++i) {
            if (this.alleleCountsOfMLE[i] <= otherACcounts[i]) continue;
            return false;
        }
        return true;
    }

    protected boolean abort(double log10LofK, ExactACcounts ACs, boolean enforceLowerACs) {
        return this.tooLowLikelihood(log10LofK) && (!enforceLowerACs || this.isLowerAC(ACs));
    }

    @Ensures(value={"result != null"})
    protected int[] getAlleleCountsOfMAP() {
        return this.alleleCountsOfMAP;
    }

    @Ensures(value={"result >= 0"})
    protected int getnEvaluations() {
        return this.nEvaluations;
    }

    private double getLog10LikelihoodOfAFNotZero() {
        if (this.log10LikelihoodsForAFGt0Sum == null) {
            this.log10LikelihoodsForAFGt0Sum = this.log10LikelihoodsForAFGt0CacheIndex == 0 ? Double.valueOf(-1000000.0) : Double.valueOf(MathUtils.log10sumLog10(this.log10LikelihoodsForAFGt0, 0, this.log10LikelihoodsForAFGt0CacheIndex));
        }
        return this.log10LikelihoodsForAFGt0Sum;
    }

    private double getLog10LikelihoodOfAFzero() {
        return this.log10LikelihoodOfAFzero;
    }

    @Requires(value={"allelesUsedInGenotyping != null"})
    protected AFCalcResult toAFCalcResult(double[] log10PriorsByAC) {
        int[] subACOfMLE = Arrays.copyOf(this.alleleCountsOfMLE, this.allelesUsedInGenotyping.size() - 1);
        double[] log10Likelihoods = MathUtils.normalizeFromLog10(new double[]{this.getLog10LikelihoodOfAFzero(), this.getLog10LikelihoodOfAFNotZero()}, true);
        double[] log10Priors = MathUtils.normalizeFromLog10(new double[]{log10PriorsByAC[0], MathUtils.log10sumLog10(log10PriorsByAC, 1)}, true);
        HashMap<Allele, Double> log10pRefByAllele = new HashMap<Allele, Double>(this.allelesUsedInGenotyping.size());
        for (int i = 0; i < subACOfMLE.length; ++i) {
            Allele allele = this.allelesUsedInGenotyping.get(i + 1);
            double log10PRef = this.alleleCountsOfMAP[i] > 0 ? -10000.0 : 0.0;
            log10pRefByAllele.put(allele, log10PRef);
        }
        return new AFCalcResult(subACOfMLE, this.nEvaluations, this.allelesUsedInGenotyping, log10Likelihoods, log10Priors, log10pRefByAllele);
    }

    protected void reset() {
        this.log10LikelihoodOfAFzero = Double.NEGATIVE_INFINITY;
        this.log10MAP = Double.NEGATIVE_INFINITY;
        this.log10MLE = Double.NEGATIVE_INFINITY;
        this.log10LikelihoodsForAFGt0CacheIndex = 0;
        this.log10LikelihoodsForAFGt0Sum = null;
        this.allelesUsedInGenotyping = null;
        this.nEvaluations = 0;
        Arrays.fill(this.alleleCountsOfMLE, 0);
        Arrays.fill(this.alleleCountsOfMAP, 0);
        Arrays.fill(this.log10LikelihoodsForAFGt0, Double.POSITIVE_INFINITY);
    }

    protected void incNEvaluations() {
        ++this.nEvaluations;
    }

    @Requires(value={"alleleCountsForK != null", "MathUtils.sum(alleleCountsForK) >= 0"})
    @Ensures(value={"log10MLE == Math.max(log10LofK, log10MLE)"})
    protected void updateMLEifNeeded(double log10LofK, int[] alleleCountsForK) {
        this.addToLikelihoodsCache(log10LofK);
        if (log10LofK > this.log10MLE) {
            this.log10MLE = log10LofK;
            System.arraycopy(alleleCountsForK, 0, this.alleleCountsOfMLE, 0, alleleCountsForK.length);
        }
    }

    @Requires(value={"alleleCountsForK != null", "MathUtils.sum(alleleCountsForK) >= 0"})
    @Ensures(value={"log10MAP == Math.max(log10PofK, log10MAP)"})
    protected void updateMAPifNeeded(double log10PofK, int[] alleleCountsForK) {
        if (log10PofK > this.log10MAP) {
            this.log10MAP = log10PofK;
            System.arraycopy(alleleCountsForK, 0, this.alleleCountsOfMAP, 0, alleleCountsForK.length);
        }
    }

    private void addToLikelihoodsCache(double log10LofK) {
        this.log10LikelihoodsForAFGt0[this.log10LikelihoodsForAFGt0CacheIndex++] = log10LofK;
        if (this.log10LikelihoodsForAFGt0CacheIndex == 5000) {
            double temporarySum = MathUtils.log10sumLog10(this.log10LikelihoodsForAFGt0, 0, this.log10LikelihoodsForAFGt0CacheIndex);
            Arrays.fill(this.log10LikelihoodsForAFGt0, Double.POSITIVE_INFINITY);
            this.log10LikelihoodsForAFGt0[0] = temporarySum;
            this.log10LikelihoodsForAFGt0CacheIndex = 1;
        }
    }

    protected void setLog10LikelihoodOfAFzero(double log10LikelihoodOfAFzero) {
        this.log10LikelihoodOfAFzero = log10LikelihoodOfAFzero;
        if (log10LikelihoodOfAFzero > this.log10MLE) {
            this.log10MLE = log10LikelihoodOfAFzero;
            Arrays.fill(this.alleleCountsOfMLE, 0);
        }
    }

    @Requires(value={"MathUtils.goodLog10Probability(log10PosteriorOfAFzero)"})
    protected void setLog10PosteriorOfAFzero(double log10PosteriorOfAFzero) {
        if (log10PosteriorOfAFzero > this.log10MAP) {
            this.log10MAP = log10PosteriorOfAFzero;
            Arrays.fill(this.alleleCountsOfMAP, 0);
        }
    }

    @Requires(value={"allelesUsedInGenotyping != null", "allelesUsedInGenotyping.size() > 1"})
    protected void setAllelesUsedInGenotyping(List<Allele> allelesUsedInGenotyping) {
        if (allelesUsedInGenotyping == null || allelesUsedInGenotyping.isEmpty()) {
            throw new IllegalArgumentException("allelesUsedInGenotyping cannot be null or empty");
        }
        if (allelesUsedInGenotyping.get(0).isNonReference()) {
            throw new IllegalArgumentException("The first element of allelesUsedInGenotyping must be the reference allele");
        }
        this.allelesUsedInGenotyping = allelesUsedInGenotyping;
    }
}

