/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnAssemblyGraph;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnEdge;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnVertex;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.GenotypingEngine;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.KBestPaths;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.LocalAssemblyEngine;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.SWPairwiseAlignment;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class DeBruijnAssembler
extends LocalAssemblyEngine {
    private static final int KMER_OVERLAP = 5;
    private static final int NUM_BEST_PATHS_PER_KMER_GRAPH = 11;
    private static final byte MIN_QUALITY = 16;
    private static final int GRAPH_KMER_STEP = 6;
    private static final double SW_MATCH = 5.0;
    private static final double SW_MISMATCH = -10.0;
    private static final double SW_GAP = -22.0;
    private static final double SW_GAP_EXTEND = -1.2;
    private final boolean DEBUG;
    private final PrintStream GRAPH_WRITER;
    private final List<DeBruijnAssemblyGraph> graphs = new ArrayList<DeBruijnAssemblyGraph>();
    private final int MIN_KMER;
    private int PRUNE_FACTOR = 2;

    public DeBruijnAssembler(boolean debug, PrintStream graphWriter, int minKmer) {
        this.DEBUG = debug;
        this.GRAPH_WRITER = graphWriter;
        this.MIN_KMER = minKmer;
    }

    @Override
    @Ensures(value={"result.contains(refHaplotype)"})
    public List<Haplotype> runLocalAssembly(ActiveRegion activeRegion, Haplotype refHaplotype, byte[] fullReferenceWithPadding, GenomeLoc refLoc, int PRUNE_FACTOR, List<VariantContext> activeAllelesToGenotype) {
        if (activeRegion == null) {
            throw new IllegalArgumentException("Assembly engine cannot be used with a null ActiveRegion.");
        }
        if (refHaplotype == null) {
            throw new IllegalArgumentException("Reference haplotype cannot be null.");
        }
        if (fullReferenceWithPadding.length != refLoc.size()) {
            throw new IllegalArgumentException("Reference bases and reference loc must be the same size.");
        }
        if (PRUNE_FACTOR < 0) {
            throw new IllegalArgumentException("Pruning factor cannot be negative");
        }
        this.PRUNE_FACTOR = PRUNE_FACTOR;
        this.createDeBruijnGraphs(activeRegion.getReads(), refHaplotype);
        if (this.GRAPH_WRITER != null) {
            this.printGraphs();
        }
        return this.findBestPaths(refHaplotype, fullReferenceWithPadding, refLoc, activeAllelesToGenotype, activeRegion.getExtendedLoc());
    }

    @Requires(value={"reads != null", "refHaplotype != null"})
    protected void createDeBruijnGraphs(List<GATKSAMRecord> reads, Haplotype refHaplotype) {
        this.graphs.clear();
        int maxKmer = ReadUtils.getMaxReadLength(reads) - 5 - 1;
        if (maxKmer < this.MIN_KMER) {
            return;
        }
        for (int kmer = maxKmer; kmer >= this.MIN_KMER; kmer -= 6) {
            DeBruijnAssemblyGraph graph = DeBruijnAssembler.createGraphFromSequences(reads, kmer, refHaplotype, this.DEBUG);
            if (graph == null) continue;
            DeBruijnAssembler.pruneGraph(graph, this.PRUNE_FACTOR);
            DeBruijnAssembler.cleanNonRefPaths(graph);
            DeBruijnAssembler.mergeNodes(graph);
            if (graph.getReferenceSourceVertex() == null) continue;
            DeBruijnAssembler.sanityCheckReferenceGraph(graph, refHaplotype);
            this.graphs.add(graph);
        }
    }

    @Requires(value={"graph != null"})
    protected static void mergeNodes(DeBruijnAssemblyGraph graph) {
        boolean foundNodesToMerge = true;
        block0: while (foundNodesToMerge) {
            foundNodesToMerge = false;
            for (DeBruijnEdge e : graph.edgeSet()) {
                DeBruijnVertex incomingVertex;
                DeBruijnVertex outgoingVertex = (DeBruijnVertex)graph.getEdgeTarget(e);
                if (outgoingVertex.equals(incomingVertex = (DeBruijnVertex)graph.getEdgeSource(e)) || graph.outDegreeOf(incomingVertex) != 1 || graph.inDegreeOf(outgoingVertex) != 1 || graph.inDegreeOf(incomingVertex) > 1 || graph.outDegreeOf(outgoingVertex) > 1 || graph.isReferenceNode(incomingVertex) != graph.isReferenceNode(outgoingVertex)) continue;
                Set outEdges = graph.outgoingEdgesOf(outgoingVertex);
                Set inEdges = graph.incomingEdgesOf(incomingVertex);
                if (inEdges.size() == 1 && outEdges.size() == 1) {
                    ((DeBruijnEdge)inEdges.iterator().next()).setMultiplicity(((DeBruijnEdge)inEdges.iterator().next()).getMultiplicity() + e.getMultiplicity() / 2);
                    ((DeBruijnEdge)outEdges.iterator().next()).setMultiplicity(((DeBruijnEdge)outEdges.iterator().next()).getMultiplicity() + e.getMultiplicity() / 2);
                } else if (inEdges.size() == 1) {
                    ((DeBruijnEdge)inEdges.iterator().next()).setMultiplicity(((DeBruijnEdge)inEdges.iterator().next()).getMultiplicity() + (e.getMultiplicity() - 1));
                } else if (outEdges.size() == 1) {
                    ((DeBruijnEdge)outEdges.iterator().next()).setMultiplicity(((DeBruijnEdge)outEdges.iterator().next()).getMultiplicity() + (e.getMultiplicity() - 1));
                }
                DeBruijnVertex addedVertex = new DeBruijnVertex(ArrayUtils.addAll(incomingVertex.getSequence(), outgoingVertex.getSuffix()), outgoingVertex.kmer);
                graph.addVertex(addedVertex);
                for (DeBruijnEdge edge : outEdges) {
                    graph.addEdge(addedVertex, graph.getEdgeTarget(edge), new DeBruijnEdge(edge.isRef(), edge.getMultiplicity()));
                }
                for (DeBruijnEdge edge : inEdges) {
                    graph.addEdge(graph.getEdgeSource(edge), addedVertex, new DeBruijnEdge(edge.isRef(), edge.getMultiplicity()));
                }
                graph.removeVertex(incomingVertex);
                graph.removeVertex(outgoingVertex);
                foundNodesToMerge = true;
                continue block0;
            }
        }
    }

    protected static void cleanNonRefPaths(DeBruijnAssemblyGraph graph) {
        DeBruijnEdge e;
        if (graph.getReferenceSourceVertex() == null || graph.getReferenceSinkVertex() == null) {
            return;
        }
        HashSet edgesToCheck = new HashSet();
        edgesToCheck.addAll(graph.incomingEdgesOf(graph.getReferenceSourceVertex()));
        while (!edgesToCheck.isEmpty()) {
            e = (DeBruijnEdge)edgesToCheck.iterator().next();
            if (!e.isRef()) {
                edgesToCheck.addAll(graph.incomingEdgesOf(graph.getEdgeSource(e)));
                graph.removeEdge(e);
            }
            edgesToCheck.remove(e);
        }
        edgesToCheck.addAll(graph.outgoingEdgesOf(graph.getReferenceSinkVertex()));
        while (!edgesToCheck.isEmpty()) {
            e = (DeBruijnEdge)edgesToCheck.iterator().next();
            if (!e.isRef()) {
                edgesToCheck.addAll(graph.outgoingEdgesOf(graph.getEdgeTarget(e)));
                graph.removeEdge(e);
            }
            edgesToCheck.remove(e);
        }
        ArrayList<DeBruijnVertex> verticesToRemove = new ArrayList<DeBruijnVertex>();
        for (DeBruijnVertex v : graph.vertexSet()) {
            if (graph.inDegreeOf(v) != 0 || graph.outDegreeOf(v) != 0) continue;
            verticesToRemove.add(v);
        }
        graph.removeAllVertices(verticesToRemove);
    }

    protected static void pruneGraph(DeBruijnAssemblyGraph graph, int pruneFactor) {
        ArrayList<DeBruijnEdge> edgesToRemove = new ArrayList<DeBruijnEdge>();
        for (DeBruijnEdge e : graph.edgeSet()) {
            if (e.getMultiplicity() > pruneFactor || e.isRef()) continue;
            edgesToRemove.add(e);
        }
        graph.removeAllEdges(edgesToRemove);
        ArrayList<DeBruijnVertex> verticesToRemove = new ArrayList<DeBruijnVertex>();
        for (DeBruijnVertex v : graph.vertexSet()) {
            if (graph.inDegreeOf(v) != 0 || graph.outDegreeOf(v) != 0) continue;
            verticesToRemove.add(v);
        }
        graph.removeAllVertices(verticesToRemove);
    }

    protected static void sanityCheckReferenceGraph(DeBruijnAssemblyGraph graph, Haplotype refHaplotype) {
        if (graph.getReferenceSourceVertex() == null) {
            throw new IllegalStateException("All reference graphs must have a reference source vertex.");
        }
        if (graph.getReferenceSinkVertex() == null) {
            throw new IllegalStateException("All reference graphs must have a reference sink vertex.");
        }
        if (!Arrays.equals(graph.getReferenceBytes(graph.getReferenceSourceVertex(), graph.getReferenceSinkVertex(), true, true), refHaplotype.getBases())) {
            throw new IllegalStateException("Mismatch between the reference haplotype and the reference assembly graph path. graph = " + new String(graph.getReferenceBytes(graph.getReferenceSourceVertex(), graph.getReferenceSinkVertex(), true, true)) + " haplotype = " + new String(refHaplotype.getBases()));
        }
    }

    @Requires(value={"reads != null", "KMER_LENGTH > 0", "refHaplotype != null"})
    protected static DeBruijnAssemblyGraph createGraphFromSequences(List<GATKSAMRecord> reads, int KMER_LENGTH, Haplotype refHaplotype, boolean DEBUG) {
        DeBruijnAssemblyGraph graph = new DeBruijnAssemblyGraph();
        byte[] refSequence = refHaplotype.getBases();
        if (refSequence.length >= KMER_LENGTH + 5) {
            int kmersInSequence = refSequence.length - KMER_LENGTH + 1;
            for (int iii = 0; iii < kmersInSequence - 1; ++iii) {
                if (graph.addKmersToGraph(Arrays.copyOfRange(refSequence, iii, iii + KMER_LENGTH), Arrays.copyOfRange(refSequence, iii + 1, iii + 1 + KMER_LENGTH), true)) continue;
                if (DEBUG) {
                    System.out.println("Cycle detected in reference graph for kmer = " + KMER_LENGTH + " ...skipping");
                }
                return null;
            }
        }
        for (GATKSAMRecord read : reads) {
            byte[] sequence = read.getReadBases();
            byte[] qualities = read.getBaseQualities();
            byte[] reducedReadCounts = read.getReducedReadCounts();
            if (sequence.length <= KMER_LENGTH + 5) continue;
            int kmersInSequence = sequence.length - KMER_LENGTH + 1;
            for (int iii = 0; iii < kmersInSequence - 1; ++iii) {
                boolean badKmer = false;
                for (int jjj = iii; jjj < iii + KMER_LENGTH + 1; ++jjj) {
                    if (qualities[jjj] >= 16) continue;
                    badKmer = true;
                    break;
                }
                if (badKmer) continue;
                int countNumber = 1;
                if (read.isReducedRead()) {
                    countNumber = MathUtils.arrayMax(Arrays.copyOfRange(reducedReadCounts, iii, iii + KMER_LENGTH));
                }
                byte[] kmer1 = Arrays.copyOfRange(sequence, iii, iii + KMER_LENGTH);
                byte[] kmer2 = Arrays.copyOfRange(sequence, iii + 1, iii + 1 + KMER_LENGTH);
                for (int kkk = 0; kkk < countNumber; ++kkk) {
                    graph.addKmersToGraph(kmer1, kmer2, false);
                }
            }
        }
        return graph;
    }

    protected void printGraphs() {
        this.GRAPH_WRITER.println("digraph assemblyGraphs {");
        for (DeBruijnAssemblyGraph graph : this.graphs) {
            for (DeBruijnEdge edge : graph.edgeSet()) {
                if (edge.getMultiplicity() > this.PRUNE_FACTOR) {
                    this.GRAPH_WRITER.println("\t" + ((DeBruijnVertex)graph.getEdgeSource(edge)).toString() + " -> " + ((DeBruijnVertex)graph.getEdgeTarget(edge)).toString() + " [" + (edge.getMultiplicity() <= this.PRUNE_FACTOR ? "style=dotted,color=grey" : "label=\"" + edge.getMultiplicity() + "\"") + "];");
                }
                if (edge.isRef()) {
                    this.GRAPH_WRITER.println("\t" + ((DeBruijnVertex)graph.getEdgeSource(edge)).toString() + " -> " + ((DeBruijnVertex)graph.getEdgeTarget(edge)).toString() + " [color=red];");
                }
                if (edge.isRef() || edge.getMultiplicity() > this.PRUNE_FACTOR) continue;
                System.out.println("Graph pruning warning!");
            }
            for (DeBruijnVertex v : graph.vertexSet()) {
                this.GRAPH_WRITER.println("\t" + v.toString() + " [label=\"" + new String(graph.getAdditionalSequence(v)) + "\"]");
            }
        }
        this.GRAPH_WRITER.println("}");
    }

    @Requires(value={"refWithPadding.length > refHaplotype.getBases().length", "refLoc.containsP(activeRegionWindow)"})
    @Ensures(value={"result.contains(refHaplotype)"})
    private List<Haplotype> findBestPaths(Haplotype refHaplotype, byte[] refWithPadding, GenomeLoc refLoc, List<VariantContext> activeAllelesToGenotype, GenomeLoc activeRegionWindow) {
        ArrayList<Haplotype> returnHaplotypes = new ArrayList<Haplotype>();
        refHaplotype.setAlignmentStartHapwrtRef(activeRegionWindow.getStart() - refLoc.getStart());
        Cigar c = new Cigar();
        c.add(new CigarElement(refHaplotype.getBases().length, CigarOperator.M));
        refHaplotype.setCigar(c);
        returnHaplotypes.add(refHaplotype);
        int activeRegionStart = refHaplotype.getAlignmentStartHapwrtRef();
        int activeRegionStop = refHaplotype.getAlignmentStartHapwrtRef() + refHaplotype.getCigar().getReferenceLength();
        for (VariantContext compVC : activeAllelesToGenotype) {
            for (Allele compAltAllele : compVC.getAlternateAlleles()) {
                Haplotype insertedRefHaplotype = refHaplotype.insertAllele(compVC.getReference(), compAltAllele, activeRegionStart + compVC.getStart() - activeRegionWindow.getStart(), compVC.getStart());
                this.addHaplotypeForGGA(insertedRefHaplotype, refWithPadding, returnHaplotypes, activeRegionStart, activeRegionStop, true);
            }
        }
        for (DeBruijnAssemblyGraph graph : this.graphs) {
            for (KBestPaths.Path path : KBestPaths.getKBestPaths(graph, 11)) {
                Haplotype h = new Haplotype(path.getBases());
                if (returnHaplotypes.contains(h)) continue;
                Cigar cigar = path.calculateCigar();
                if (cigar.isEmpty()) {
                    throw new IllegalStateException("Smith-Waterman alignment failure. Cigar = " + cigar + " with reference length " + cigar.getReferenceLength() + " but expecting reference length of " + refHaplotype.getCigar().getReferenceLength());
                }
                if (this.pathIsTooDivergentFromReference(cigar) || cigar.getReferenceLength() < 60) continue;
                if (cigar.getReferenceLength() != refHaplotype.getCigar().getReferenceLength()) {
                    throw new IllegalStateException("Smith-Waterman alignment failure. Cigar = " + cigar + " with reference length " + cigar.getReferenceLength() + " but expecting reference length of " + refHaplotype.getCigar().getReferenceLength());
                }
                h.setCigar(cigar);
                Cigar leftAlignedCigar = DeBruijnAssembler.leftAlignCigarSequentially(AlignmentUtils.consolidateCigar((h = this.extendPartialHaplotype(h, activeRegionStart, refWithPadding)).getCigar()), refWithPadding, h.getBases(), activeRegionStart, 0);
                if (leftAlignedCigar.getReferenceLength() != refHaplotype.getCigar().getReferenceLength() || returnHaplotypes.contains(h)) continue;
                h.setAlignmentStartHapwrtRef(activeRegionStart);
                h.setCigar(leftAlignedCigar);
                returnHaplotypes.add(h);
                if (activeAllelesToGenotype.isEmpty()) continue;
                Map<Integer, VariantContext> eventMap = GenotypingEngine.generateVCsFromAlignment(h, h.getAlignmentStartHapwrtRef(), h.getCigar(), refWithPadding, h.getBases(), refLoc, "HCassembly");
                for (VariantContext compVC : activeAllelesToGenotype) {
                    VariantContext vcOnHaplotype = eventMap.get(compVC.getStart());
                    if (vcOnHaplotype != null) continue;
                    for (Allele compAltAllele : compVC.getAlternateAlleles()) {
                        this.addHaplotypeForGGA(h.insertAllele(compVC.getReference(), compAltAllele, activeRegionStart + compVC.getStart() - activeRegionWindow.getStart(), compVC.getStart()), refWithPadding, returnHaplotypes, activeRegionStart, activeRegionStop, false);
                    }
                }
            }
        }
        if (this.DEBUG) {
            if (returnHaplotypes.size() > 1) {
                System.out.println("Found " + returnHaplotypes.size() + " candidate haplotypes to evaluate every read against.");
            } else {
                System.out.println("Found only the reference haplotype in the assembly graph.");
            }
            for (Haplotype h : returnHaplotypes) {
                System.out.println(h.toString());
                System.out.println("> Cigar = " + h.getCigar() + " : " + h.getCigar().getReferenceLength());
            }
        }
        return returnHaplotypes;
    }

    @Requires(value={"haplotype != null", "activeRegionStart > 0", "refWithPadding != null", "refWithPadding.length > 0"})
    @Ensures(value={"result != null", "result.getCigar() != null"})
    private Haplotype extendPartialHaplotype(Haplotype haplotype, int activeRegionStart, byte[] refWithPadding) {
        Cigar cigar = haplotype.getCigar();
        Cigar newCigar = new Cigar();
        byte[] newHaplotypeBases = haplotype.getBases();
        int refPos = activeRegionStart;
        int hapPos = 0;
        block6: for (CigarElement ce : cigar.getCigarElements()) {
            switch (ce.getOperator()) {
                case M: {
                    refPos += ce.getLength();
                    hapPos += ce.getLength();
                    newCigar.add(ce);
                    continue block6;
                }
                case I: {
                    hapPos += ce.getLength();
                    newCigar.add(ce);
                    continue block6;
                }
                case D: {
                    refPos += ce.getLength();
                    newCigar.add(ce);
                    continue block6;
                }
                case X: {
                    newHaplotypeBases = ArrayUtils.addAll(Arrays.copyOfRange(newHaplotypeBases, 0, hapPos), ArrayUtils.addAll(Arrays.copyOfRange(refWithPadding, refPos, refPos + ce.getLength()), Arrays.copyOfRange(newHaplotypeBases, hapPos, newHaplotypeBases.length)));
                    refPos += ce.getLength();
                    hapPos += ce.getLength();
                    newCigar.add(new CigarElement(ce.getLength(), CigarOperator.M));
                    continue block6;
                }
            }
            throw new IllegalStateException("Unsupported cigar operator detected: " + (Object)((Object)ce.getOperator()));
        }
        Haplotype returnHaplotype = new Haplotype(newHaplotypeBases, haplotype.isReference());
        returnHaplotype.setCigar(newCigar);
        return returnHaplotype;
    }

    @Requires(value={"c != null"})
    private boolean pathIsTooDivergentFromReference(Cigar c) {
        for (CigarElement ce : c.getCigarElements()) {
            if (!ce.getOperator().equals((Object)CigarOperator.N)) continue;
            return true;
        }
        return false;
    }

    @Ensures(value={"cigar != null", "refSeq != null", "readSeq != null", "refIndex >= 0", "readIndex >= 0"})
    protected static Cigar leftAlignCigarSequentially(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        Cigar cigarToReturn = new Cigar();
        Cigar cigarToAlign = new Cigar();
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            if (ce.getOperator() == CigarOperator.D || ce.getOperator() == CigarOperator.I) {
                cigarToAlign.add(ce);
                for (CigarElement toAdd : AlignmentUtils.leftAlignIndel(cigarToAlign, refSeq, readSeq, refIndex, readIndex, false).getCigarElements()) {
                    cigarToReturn.add(toAdd);
                }
                refIndex += cigarToAlign.getReferenceLength();
                readIndex += cigarToAlign.getReadLength();
                cigarToAlign = new Cigar();
                continue;
            }
            cigarToAlign.add(ce);
        }
        if (!cigarToAlign.isEmpty()) {
            for (CigarElement toAdd : cigarToAlign.getCigarElements()) {
                cigarToReturn.add(toAdd);
            }
        }
        return cigarToReturn;
    }

    @Requires(value={"ref != null", "ref.length >= activeRegionStop - activeRegionStart"})
    private boolean addHaplotypeForGGA(Haplotype haplotype, byte[] ref, List<Haplotype> haplotypeList, int activeRegionStart, int activeRegionStop, boolean FORCE_INCLUSION_FOR_GGA_MODE) {
        if (haplotype == null) {
            return false;
        }
        SWPairwiseAlignment swConsensus = new SWPairwiseAlignment(ref, haplotype.getBases(), 5.0, -10.0, -22.0, -1.2);
        haplotype.setAlignmentStartHapwrtRef(swConsensus.getAlignmentStart2wrt1());
        if (swConsensus.getCigar().toString().contains("S") || swConsensus.getCigar().getReferenceLength() < 60 || swConsensus.getAlignmentStart2wrt1() < 0) {
            return false;
        }
        haplotype.setCigar(AlignmentUtils.leftAlignIndel(swConsensus.getCigar(), ref, haplotype.getBases(), swConsensus.getAlignmentStart2wrt1(), 0, true));
        int hapStart = ReadUtils.getReadCoordinateForReferenceCoordinate(haplotype.getAlignmentStartHapwrtRef(), haplotype.getCigar(), activeRegionStart, ReadUtils.ClippingTail.LEFT_TAIL, true);
        int hapStop = ReadUtils.getReadCoordinateForReferenceCoordinate(haplotype.getAlignmentStartHapwrtRef(), haplotype.getCigar(), activeRegionStop, ReadUtils.ClippingTail.RIGHT_TAIL, true);
        if (hapStop == -1 && activeRegionStop == haplotype.getAlignmentStartHapwrtRef() + haplotype.getCigar().getReferenceLength()) {
            hapStop = activeRegionStop;
        }
        byte[] newHaplotypeBases = hapStart == -1 && hapStop == -1 ? ArrayUtils.addAll(ArrayUtils.addAll(ArrayUtils.subarray(ref, activeRegionStart, swConsensus.getAlignmentStart2wrt1()), haplotype.getBases()), ArrayUtils.subarray(ref, swConsensus.getAlignmentStart2wrt1() + swConsensus.getCigar().getReferenceLength(), activeRegionStop)) : (hapStart == -1 ? ArrayUtils.addAll(ArrayUtils.subarray(ref, activeRegionStart, swConsensus.getAlignmentStart2wrt1()), ArrayUtils.subarray(haplotype.getBases(), 0, hapStop)) : (hapStop == -1 ? ArrayUtils.addAll(ArrayUtils.subarray(haplotype.getBases(), hapStart, haplotype.getBases().length), ArrayUtils.subarray(ref, swConsensus.getAlignmentStart2wrt1() + swConsensus.getCigar().getReferenceLength(), activeRegionStop)) : ArrayUtils.subarray(haplotype.getBases(), hapStart, hapStop)));
        Haplotype h = new Haplotype(newHaplotypeBases);
        SWPairwiseAlignment swConsensus2 = new SWPairwiseAlignment(ref, h.getBases(), 5.0, -10.0, -22.0, -1.2);
        h.setAlignmentStartHapwrtRef(swConsensus2.getAlignmentStart2wrt1());
        if (haplotype.isArtificialHaplotype()) {
            h.setArtificialEvent(haplotype.getArtificialEvent());
        }
        if (swConsensus2.getCigar().toString().contains("S") || swConsensus2.getCigar().getReferenceLength() != activeRegionStop - activeRegionStart || swConsensus2.getAlignmentStart2wrt1() < 0) {
            return false;
        }
        h.setCigar(AlignmentUtils.leftAlignIndel(swConsensus2.getCigar(), ref, h.getBases(), swConsensus2.getAlignmentStart2wrt1(), 0, true));
        if (FORCE_INCLUSION_FOR_GGA_MODE || !haplotypeList.contains(h)) {
            haplotypeList.add(h);
            return true;
        }
        return false;
    }
}

