/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import com.google.java.contract.Invariant;
import java.util.Arrays;

@Invariant(value={"kmer > 0"})
public class DeBruijnVertex {
    protected final byte[] sequence;
    public final int kmer;

    public DeBruijnVertex(byte[] sequence, int kmer) {
        this.sequence = (byte[])sequence.clone();
        this.kmer = kmer;
    }

    public boolean equals(Object v) {
        return v instanceof DeBruijnVertex && Arrays.equals(this.sequence, ((DeBruijnVertex)v).sequence);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sequence);
    }

    public String toString() {
        return new String(this.sequence);
    }

    public String getSuffixString() {
        return new String(this.getSuffix());
    }

    @Ensures(value={"result != null"})
    public byte[] getSequence() {
        return (byte[])this.sequence.clone();
    }

    @Ensures(value={"result != null"})
    public byte[] getSuffix() {
        return Arrays.copyOfRange(this.sequence, this.kmer - 1, this.sequence.length);
    }
}

