/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMReadGroupRecord;
import net.sf.samtools.SAMTag;
import org.broadinstitute.sting.commandline.Advanced;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.StandardCallerArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.AlignmentContextUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.downsampling.DownsampleType;
import org.broadinstitute.sting.gatk.filters.BadMateFilter;
import org.broadinstitute.sting.gatk.io.StingSAMFileWriter;
import org.broadinstitute.sting.gatk.iterators.ReadTransformer;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionTraversalParameters;
import org.broadinstitute.sting.gatk.walkers.ActiveRegionWalker;
import org.broadinstitute.sting.gatk.walkers.BAQMode;
import org.broadinstitute.sting.gatk.walkers.Downsample;
import org.broadinstitute.sting.gatk.walkers.PartitionBy;
import org.broadinstitute.sting.gatk.walkers.PartitionType;
import org.broadinstitute.sting.gatk.walkers.annotator.VariantAnnotatorEngine;
import org.broadinstitute.sting.gatk.walkers.annotator.interfaces.AnnotatorCompatible;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.gatk.walkers.genotyper.VariantCallContext;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnAssembler;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.GenotypingEngine;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.LikelihoodCalculationEngine;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.LocalAssemblyEngine;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.SWPairwiseAlignment;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActiveRegionReadState;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileState;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.fragments.FragmentCollection;
import org.broadinstitute.sting.utils.fragments.FragmentUtils;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.pairhmm.PairHMM;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFFilterHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

@DocumentedGATKFeature(groupName="Variant Discovery Tools", extraDocs={CommandLineGATK.class})
@PartitionBy(value=PartitionType.LOCUS)
@BAQMode(ApplicationTime=ReadTransformer.ApplicationTime.FORBIDDEN)
@ActiveRegionTraversalParameters(extension=85, maxRegion=300)
@Downsample(by=DownsampleType.BY_SAMPLE, toCoverage=250)
public class HaplotypeCaller
extends ActiveRegionWalker<Integer, Integer>
implements AnnotatorCompatible {
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter vcfWriter = null;
    @Output(fullName="graphOutput", shortName="graph", doc="File to which debug assembly graph information should be written", required=false)
    protected PrintStream graphWriter = null;
    @Hidden
    @Output(fullName="bamOutput", shortName="bam", doc="File to which assembled haplotypes should be written", required=false)
    protected StingSAMFileWriter bamWriter = null;
    private SAMFileHeader bamHeader = null;
    private long uniqueNameCounter = 1L;
    private static final String readGroupId = "ArtificialHaplotype";
    @Argument(fullName="pair_hmm_implementation", shortName="pairHMM", doc="The PairHMM implementation to use for genotype likelihood calculations", required=false)
    public PairHMM.HMM_IMPLEMENTATION pairHMM = PairHMM.HMM_IMPLEMENTATION.LOGLESS_CACHING;
    @Hidden
    @Argument(fullName="keepRG", shortName="keepRG", doc="Only use read from this read group when making calls (but use all reads to build the assembly)", required=false)
    protected String keepRG = null;
    @Argument(fullName="minPruning", shortName="minPruning", doc="The minimum allowed pruning factor in assembly graph. Paths with <= X supporting kmers are pruned from the graph", required=false)
    protected int MIN_PRUNE_FACTOR = 2;
    @Advanced
    @Argument(fullName="gcpHMM", shortName="gcpHMM", doc="Flat gap continuation penalty for use in the Pair HMM", required=false)
    protected int gcpHMM = 10;
    @Advanced
    @Argument(fullName="maxNumHaplotypesInPopulation", shortName="maxNumHaplotypesInPopulation", doc="Maximum number of haplotypes to consider for your population. This number will probably need to be increased when calling organisms with high heterozygosity.", required=false)
    protected int maxNumHaplotypesInPopulation = 13;
    @Advanced
    @Argument(fullName="minKmer", shortName="minKmer", doc="Minimum kmer length to use in the assembly graph", required=false)
    protected int minKmer = 11;
    @Argument(fullName="includeUmappedReads", shortName="unmapped", doc="If provided, unmapped reads with chromosomal coordinates (i.e., those placed to their maps) will be included in the assembly and calling", required=false)
    protected boolean includeUnmappedReads = false;
    @Argument(fullName="useAllelesTrigger", shortName="allelesTrigger", doc="If specified, use additional trigger on variants found in an external alleles file", required=false)
    protected boolean USE_ALLELES_TRIGGER = false;
    @Advanced
    @Argument(fullName="useFilteredReadsForAnnotations", shortName="useFilteredReadsForAnnotations", doc="If specified, use the contamination-filtered read maps for the purposes of annotating variants", required=false)
    protected boolean USE_FILTERED_READ_MAP_FOR_ANNOTATIONS = false;
    @Hidden
    @Argument(fullName="justDetermineActiveRegions", shortName="justDetermineActiveRegions", doc="If specified, the HC won't actually do any assembly or calling, it'll just run the upfront active region determination code.  Useful for benchmarking and scalability testing", required=false)
    protected boolean justDetermineActiveRegions = false;
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Input(fullName="comp", shortName="comp", doc="comparison VCF file", required=false)
    public List<RodBinding<VariantContext>> comps = Collections.emptyList();
    @Argument(fullName="annotation", shortName="A", doc="One or more specific annotations to apply to variant calls", required=false)
    protected List<String> annotationsToUse = new ArrayList<String>(Arrays.asList("ClippingRankSumTest"));
    @Argument(fullName="excludeAnnotation", shortName="XA", doc="One or more specific annotations to exclude", required=false)
    protected List<String> annotationsToExclude = new ArrayList<String>(Arrays.asList("SpanningDeletions", "TandemRepeatAnnotator"));
    @Argument(fullName="group", shortName="G", doc="One or more classes/groups of annotations to apply to variant calls", required=false)
    protected String[] annotationClassesToUse = new String[]{"Standard"};
    @ArgumentCollection
    private StandardCallerArgumentCollection SCAC = new StandardCallerArgumentCollection();
    @Argument(fullName="debug", shortName="debug", doc="If specified, print out very verbose debug information about each triggering active region", required=false)
    protected boolean DEBUG;
    private UnifiedGenotyperEngine UG_engine = null;
    private UnifiedGenotyperEngine UG_engine_simple_genotyper = null;
    private LocalAssemblyEngine assemblyEngine = null;
    private LikelihoodCalculationEngine likelihoodCalculationEngine = null;
    private GenotypingEngine genotypingEngine = null;
    private VariantAnnotatorEngine annotationEngine = null;
    private CachingIndexedFastaSequenceFile referenceReader;
    private static final int REFERENCE_PADDING = 500;
    private static final byte MIN_TAIL_QUALITY = 20;
    private List<String> samplesList = new ArrayList<String>();
    private static final double LOG_ONE_HALF = -Math.log10(2.0);
    private static final double LOG_ONE_THIRD = -Math.log10(3.0);
    private final List<VariantContext> allelesToGenotype = new ArrayList<VariantContext>();
    private static final Allele FAKE_REF_ALLELE = Allele.create("N", true);
    private static final Allele FAKE_ALT_ALLELE = Allele.create("<FAKE_ALT>", false);

    @Override
    public RodBinding<VariantContext> getDbsnpRodBinding() {
        return this.dbsnp.dbsnp;
    }

    @Override
    public List<RodBinding<VariantContext>> getCompRodBindings() {
        return this.comps;
    }

    @Override
    public RodBinding<VariantContext> getSnpEffRodBinding() {
        return null;
    }

    @Override
    public List<RodBinding<VariantContext>> getResourceRodBindings() {
        return Collections.emptyList();
    }

    @Override
    public boolean alwaysAppendDbsnpId() {
        return false;
    }

    @Override
    public void initialize() {
        super.initialize();
        Set<String> samples = SampleUtils.getSAMFileSamples(this.getToolkit().getSAMFileHeader());
        this.samplesList.addAll(samples);
        UnifiedArgumentCollection UAC = new UnifiedArgumentCollection(this.SCAC);
        this.UG_engine = new UnifiedGenotyperEngine(this.getToolkit(), UAC, logger, null, null, samples, 2);
        UnifiedArgumentCollection simpleUAC = new UnifiedArgumentCollection(UAC);
        simpleUAC.OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_VARIANTS_ONLY;
        simpleUAC.GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.DISCOVERY;
        simpleUAC.STANDARD_CONFIDENCE_FOR_CALLING = Math.min(4.0, UAC.STANDARD_CONFIDENCE_FOR_CALLING);
        simpleUAC.STANDARD_CONFIDENCE_FOR_EMITTING = Math.min(4.0, UAC.STANDARD_CONFIDENCE_FOR_EMITTING);
        simpleUAC.CONTAMINATION_FRACTION = 0.0;
        simpleUAC.CONTAMINATION_FRACTION_FILE = null;
        simpleUAC.exactCallsLog = null;
        this.UG_engine_simple_genotyper = new UnifiedGenotyperEngine(this.getToolkit(), simpleUAC, logger, null, null, samples, 2);
        if (UAC.CONTAMINATION_FRACTION_FILE != null) {
            throw new UserException("Per-Sample contamination level not supported in Haplotype Caller at this point");
        }
        this.annotationEngine = new VariantAnnotatorEngine(Arrays.asList(this.annotationClassesToUse), this.annotationsToUse, this.annotationsToExclude, this, this.getToolkit());
        HashSet<VCFHeaderLine> headerInfo = new HashSet<VCFHeaderLine>();
        headerInfo.addAll(this.annotationEngine.getVCFAnnotationDescriptions());
        VCFStandardHeaderLines.addStandardInfoLines(headerInfo, true, "DS", "MLEAC", "MLEAF");
        VCFStandardHeaderLines.addStandardFormatLines(headerInfo, true, "GT", "GQ", "DP", "PL");
        headerInfo.add(new VCFFilterHeaderLine("LowQual", "Low quality"));
        this.vcfWriter.writeHeader(new VCFHeader(headerInfo, samples));
        try {
            this.referenceReader = new CachingIndexedFastaSequenceFile(this.getToolkit().getArguments().referenceFile);
        }
        catch (FileNotFoundException e) {
            throw new UserException.CouldNotReadInputFile(this.getToolkit().getArguments().referenceFile, (Exception)e);
        }
        this.assemblyEngine = new DeBruijnAssembler(this.DEBUG, this.graphWriter, this.minKmer);
        this.likelihoodCalculationEngine = new LikelihoodCalculationEngine((byte)this.gcpHMM, this.DEBUG, this.pairHMM);
        this.genotypingEngine = new GenotypingEngine(this.DEBUG, this.annotationEngine, this.USE_FILTERED_READ_MAP_FOR_ANNOTATIONS);
        if (this.bamWriter != null) {
            this.setupBamWriter();
        }
    }

    @Override
    public boolean includeReadsWithDeletionAtLoci() {
        return true;
    }

    @Override
    public EnumSet<ActiveRegionReadState> desiredReadStates() {
        if (this.includeUnmappedReads) {
            throw new UserException.BadArgumentValue("includeUmappedReads", "is not yet functional");
        }
        return EnumSet.of(ActiveRegionReadState.PRIMARY, ActiveRegionReadState.NONPRIMARY, ActiveRegionReadState.EXTENDED);
    }

    @Override
    @Ensures(value={"result.isActiveProb >= 0.0", "result.isActiveProb <= 1.0"})
    public ActivityProfileState isActive(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (this.UG_engine.getUAC().GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            for (VariantContext vc : tracker.getValues(this.UG_engine.getUAC().alleles, ref.getLocus())) {
                if (this.allelesToGenotype.contains(vc)) continue;
                this.allelesToGenotype.add(vc);
            }
            if (tracker.getValues(this.UG_engine.getUAC().alleles, ref.getLocus()).size() > 0) {
                return new ActivityProfileState(ref.getLocus(), 1.0);
            }
        }
        if (this.USE_ALLELES_TRIGGER) {
            return new ActivityProfileState(ref.getLocus(), tracker.getValues(this.UG_engine.getUAC().alleles, ref.getLocus()).size() > 0 ? 1.0 : 0.0);
        }
        if (context == null || context.getBasePileup().isEmpty()) {
            return new ActivityProfileState(ref.getLocus(), 0.0);
        }
        ArrayList<Allele> noCall = new ArrayList<Allele>();
        noCall.add(Allele.NO_CALL);
        Map<String, AlignmentContext> splitContexts = AlignmentContextUtils.splitContextBySampleName(context);
        GenotypesContext genotypes = GenotypesContext.create(splitContexts.keySet().size());
        MathUtils.RunningAverage averageHQSoftClips = new MathUtils.RunningAverage();
        for (Map.Entry<String, AlignmentContext> sample : splitContexts.entrySet()) {
            double[] genotypeLikelihoods = new double[3];
            Arrays.fill(genotypeLikelihoods, 0.0);
            for (PileupElement p : sample.getValue().getBasePileup()) {
                byte qual = p.getQual();
                if (!p.isDeletion() && qual <= 18) continue;
                int AA = 0;
                boolean AB = true;
                int BB = 2;
                if (p.getBase() != ref.getBase() || p.isDeletion() || p.isBeforeDeletionStart() || p.isAfterDeletionEnd() || p.isBeforeInsertion() || p.isAfterInsertion() || p.isNextToSoftClip()) {
                    AA = 2;
                    BB = 0;
                    if (p.isNextToSoftClip()) {
                        averageHQSoftClips.add(AlignmentUtils.calcNumHighQualitySoftClips(p.getRead(), (byte)28));
                    }
                }
                int n = AA;
                genotypeLikelihoods[n] = genotypeLikelihoods[n] + (double)p.getRepresentativeCount() * QualityUtils.qualToProbLog10(qual);
                genotypeLikelihoods[1] = genotypeLikelihoods[1] + (double)p.getRepresentativeCount() * MathUtils.approximateLog10SumLog10(QualityUtils.qualToProbLog10(qual) + LOG_ONE_HALF, QualityUtils.qualToErrorProbLog10(qual) + LOG_ONE_THIRD + LOG_ONE_HALF);
                int n2 = BB;
                genotypeLikelihoods[n2] = genotypeLikelihoods[n2] + ((double)p.getRepresentativeCount() * QualityUtils.qualToErrorProbLog10(qual) + LOG_ONE_THIRD);
            }
            genotypes.add(new GenotypeBuilder(sample.getKey()).alleles(noCall).PL(genotypeLikelihoods).make());
        }
        ArrayList<Allele> alleles = new ArrayList<Allele>();
        alleles.add(FAKE_REF_ALLELE);
        alleles.add(FAKE_ALT_ALLELE);
        VariantCallContext vcOut = this.UG_engine_simple_genotyper.calculateGenotypes(new VariantContextBuilder("HCisActive!", context.getContig(), context.getLocation().getStart(), context.getLocation().getStop(), alleles).genotypes(genotypes).make(), GenotypeLikelihoodsCalculationModel.Model.INDEL);
        double isActiveProb = vcOut == null ? 0.0 : QualityUtils.qualToProb(vcOut.getPhredScaledQual());
        return new ActivityProfileState(ref.getLocus(), isActiveProb, averageHQSoftClips.mean() > 6.0 ? ActivityProfileState.Type.HIGH_QUALITY_SOFT_CLIPS : ActivityProfileState.Type.NONE, averageHQSoftClips.mean());
    }

    @Override
    public Integer map(ActiveRegion activeRegion, RefMetaDataTracker metaDataTracker) {
        if (this.justDetermineActiveRegions) {
            return 1;
        }
        ArrayList<VariantContext> activeAllelesToGenotype = new ArrayList<VariantContext>();
        if (this.UG_engine.getUAC().GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            for (VariantContext vc : this.allelesToGenotype) {
                if (!activeRegion.getLocation().overlapsP(this.getToolkit().getGenomeLocParser().createGenomeLoc(vc))) continue;
                activeAllelesToGenotype.add(vc);
            }
            this.allelesToGenotype.removeAll(activeAllelesToGenotype);
        }
        if (!activeRegion.isActive()) {
            return 0;
        }
        if (activeRegion.size() == 0 && this.UG_engine.getUAC().GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES) {
            return 0;
        }
        if (this.UG_engine.getUAC().GenotypingMode == GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES && activeAllelesToGenotype.isEmpty()) {
            return 0;
        }
        this.finalizeActiveRegion(activeRegion);
        Haplotype referenceHaplotype = new Haplotype(activeRegion.getActiveRegionReference(this.referenceReader), true);
        byte[] fullReferenceWithPadding = activeRegion.getActiveRegionReference(this.referenceReader, 500);
        GenomeLoc paddedReferenceLoc = this.getPaddedLoc(activeRegion);
        List<Haplotype> haplotypes = this.assemblyEngine.runLocalAssembly(activeRegion, referenceHaplotype, fullReferenceWithPadding, paddedReferenceLoc, this.MIN_PRUNE_FACTOR, activeAllelesToGenotype);
        if (haplotypes.size() == 1) {
            return 1;
        }
        List<GATKSAMRecord> filteredReads = this.filterNonPassingReads(activeRegion);
        if (activeRegion.size() == 0) {
            return 1;
        }
        Collections.sort(haplotypes, new Haplotype.HaplotypeBaseComparator());
        Map<String, PerReadAlleleLikelihoodMap> stratifiedReadMap = this.likelihoodCalculationEngine.computeReadLikelihoods(haplotypes, this.splitReadsBySample(activeRegion.getReads()));
        Map<String, List<GATKSAMRecord>> perSampleFilteredReadList = this.splitReadsBySample(filteredReads);
        List<Haplotype> bestHaplotypes = this.UG_engine.getUAC().GenotypingMode != GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES ? this.likelihoodCalculationEngine.selectBestHaplotypes(haplotypes, stratifiedReadMap, this.maxNumHaplotypesInPopulation) : haplotypes;
        for (VariantContext call : this.genotypingEngine.assignGenotypeLikelihoods(this.UG_engine, bestHaplotypes, this.samplesList, stratifiedReadMap, perSampleFilteredReadList, fullReferenceWithPadding, paddedReferenceLoc, activeRegion.getLocation(), this.getToolkit().getGenomeLocParser(), activeAllelesToGenotype)) {
            this.vcfWriter.add(call);
        }
        if (this.bamWriter != null) {
            for (Haplotype haplotype : haplotypes) {
                this.writeHaplotype(haplotype, paddedReferenceLoc, bestHaplotypes.contains(haplotype));
            }
            HashMap<Allele, Haplotype> alleleToHaplotypeMap = new HashMap<Allele, Haplotype>(haplotypes.size());
            for (Haplotype haplotype : haplotypes) {
                alleleToHaplotypeMap.put(Allele.create(haplotype.getBases()), haplotype);
            }
            for (PerReadAlleleLikelihoodMap readAlleleLikelihoodMap : stratifiedReadMap.values()) {
                for (Map.Entry<GATKSAMRecord, Map<Allele, Double>> entry : readAlleleLikelihoodMap.getLikelihoodReadMap().entrySet()) {
                    Allele bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele(entry.getValue());
                    if (bestAllele == Allele.NO_CALL) continue;
                    this.writeReadAgainstHaplotype(entry.getKey(), (Haplotype)alleleToHaplotypeMap.get(bestAllele), paddedReferenceLoc.getStart());
                }
            }
        }
        if (this.DEBUG) {
            System.out.println("----------------------------------------------------------------------------------");
        }
        return 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer cur, Integer sum) {
        return cur + sum;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info("Ran local assembly on " + result + " active regions");
    }

    private void finalizeActiveRegion(ActiveRegion activeRegion) {
        if (this.DEBUG) {
            System.out.println("\nAssembling " + activeRegion.getLocation() + " with " + activeRegion.size() + " reads:    (with overlap region = " + activeRegion.getExtendedLoc() + ")");
        }
        ArrayList<GATKSAMRecord> finalizedReadList = new ArrayList<GATKSAMRecord>();
        FragmentCollection<GATKSAMRecord> fragmentCollection = FragmentUtils.create(activeRegion.getReads());
        activeRegion.clearReads();
        finalizedReadList.addAll(fragmentCollection.getSingletonReads());
        for (List<GATKSAMRecord> overlappingPair : fragmentCollection.getOverlappingPairs()) {
            finalizedReadList.addAll(FragmentUtils.mergeOverlappingPairedFragments(overlappingPair));
        }
        ArrayList<GATKSAMRecord> readsToUse = new ArrayList<GATKSAMRecord>(finalizedReadList.size());
        for (GATKSAMRecord myRead : finalizedReadList) {
            GATKSAMRecord postAdapterRead = myRead.getReadUnmappedFlag() ? myRead : ReadClipper.hardClipAdaptorSequence(myRead);
            if (postAdapterRead == null || postAdapterRead.isEmpty() || postAdapterRead.getCigar().getReadLength() <= 0) continue;
            GATKSAMRecord clippedRead = ReadClipper.hardClipLowQualEnds(postAdapterRead, (byte)20);
            if (!activeRegion.readOverlapsRegion(clippedRead = ReadClipper.hardClipToRegion(clippedRead, activeRegion.getExtendedLoc().getStart(), activeRegion.getExtendedLoc().getStop())) || clippedRead.getReadLength() <= 0) continue;
            readsToUse.add(clippedRead);
        }
        activeRegion.addAll(ReadUtils.sortReadsByCoordinate(readsToUse));
    }

    private List<GATKSAMRecord> filterNonPassingReads(ActiveRegion activeRegion) {
        ArrayList<GATKSAMRecord> readsToRemove = new ArrayList<GATKSAMRecord>();
        for (GATKSAMRecord rec : activeRegion.getReads()) {
            if (rec.getReadLength() >= 24 && rec.getMappingQuality() >= 20 && !BadMateFilter.hasBadMate(rec) && (this.keepRG == null || rec.getReadGroup().getId().equals(this.keepRG))) continue;
            readsToRemove.add(rec);
        }
        activeRegion.removeAll(readsToRemove);
        return readsToRemove;
    }

    private GenomeLoc getPaddedLoc(ActiveRegion activeRegion) {
        int padLeft = Math.max(activeRegion.getExtendedLoc().getStart() - 500, 1);
        int padRight = Math.min(activeRegion.getExtendedLoc().getStop() + 500, this.referenceReader.getSequenceDictionary().getSequence(activeRegion.getExtendedLoc().getContig()).getSequenceLength());
        return this.getToolkit().getGenomeLocParser().createGenomeLoc(activeRegion.getExtendedLoc().getContig(), padLeft, padRight);
    }

    private Map<String, List<GATKSAMRecord>> splitReadsBySample(List<GATKSAMRecord> reads) {
        HashMap<String, List<GATKSAMRecord>> returnMap = new HashMap<String, List<GATKSAMRecord>>();
        for (String sample : this.samplesList) {
            ArrayList readList = (ArrayList)returnMap.get(sample);
            if (readList != null) continue;
            readList = new ArrayList();
            returnMap.put(sample, readList);
        }
        for (GATKSAMRecord read : reads) {
            ((List)returnMap.get(read.getReadGroup().getSample())).add(read);
        }
        return returnMap;
    }

    private void setupBamWriter() {
        this.bamHeader = new SAMFileHeader();
        this.bamHeader.setSequenceDictionary(this.getToolkit().getSAMFileHeader().getSequenceDictionary());
        this.bamHeader.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        ArrayList<SAMReadGroupRecord> readGroups = new ArrayList<SAMReadGroupRecord>(this.getToolkit().getSAMFileHeader().getReadGroups());
        SAMReadGroupRecord rg = new SAMReadGroupRecord(readGroupId);
        rg.setSample("HC");
        rg.setSequencingCenter("BI");
        readGroups.add(rg);
        this.bamHeader.setReadGroups(readGroups);
        this.bamWriter.setPresorted(false);
        this.bamWriter.writeHeader(this.bamHeader);
    }

    private void writeHaplotype(Haplotype haplotype, GenomeLoc paddedRefLoc, boolean isAmongBestHaplotypes) {
        GATKSAMRecord record = new GATKSAMRecord(this.bamHeader);
        record.setReadBases(haplotype.getBases());
        record.setAlignmentStart(paddedRefLoc.getStart() + haplotype.getAlignmentStartHapwrtRef());
        record.setBaseQualities(Utils.dupBytes((byte)33, haplotype.getBases().length));
        record.setCigar(haplotype.getCigar());
        record.setMappingQuality(isAmongBestHaplotypes ? 60 : 0);
        record.setReadName("HC" + this.uniqueNameCounter++);
        record.setReadUnmappedFlag(false);
        record.setReferenceIndex(paddedRefLoc.getContigIndex());
        record.setAttribute(SAMTag.RG.toString(), (Object)readGroupId);
        record.setFlags(16);
        this.bamWriter.addAlignment(record);
    }

    private void writeReadAgainstHaplotype(GATKSAMRecord read, Haplotype haplotype, int referenceStart) {
        SWPairwiseAlignment swPairwiseAlignment = new SWPairwiseAlignment(haplotype.getBases(), read.getReadBases(), 5.0, -10.0, -22.0, -1.2);
        int readStartOnHaplotype = swPairwiseAlignment.getAlignmentStart2wrt1();
        int readStartOnReference = referenceStart + haplotype.getAlignmentStartHapwrtRef() + readStartOnHaplotype;
        read.setAlignmentStart(readStartOnReference);
        Cigar cigar = this.generateReadCigarFromHaplotype(read, readStartOnHaplotype, haplotype.getCigar());
        read.setCigar(cigar);
        this.bamWriter.addAlignment(read);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Cigar generateReadCigarFromHaplotype(GATKSAMRecord read, int readStartOnHaplotype, Cigar haplotypeCigar) {
        int currentReadPos = 0;
        int currentHapPos = 0;
        ArrayList<CigarElement> readCigarElements = new ArrayList<CigarElement>();
        Iterator<CigarElement> i$ = haplotypeCigar.getCigarElements().iterator();
        while (i$.hasNext()) {
            CigarElement cigarElement = i$.next();
            if (cigarElement.getOperator() == CigarOperator.D) {
                if (currentReadPos <= 0) continue;
                readCigarElements.add(cigarElement);
                continue;
            }
            if (cigarElement.getOperator() != CigarOperator.M && cigarElement.getOperator() != CigarOperator.I) continue;
            int elementLength = cigarElement.getLength();
            int nextReadPos = currentReadPos + elementLength;
            int nextHapPos = currentHapPos + elementLength;
            if (currentReadPos > 0) {
                if (nextReadPos >= read.getReadLength()) {
                    readCigarElements.add(new CigarElement(read.getReadLength() - currentReadPos, cigarElement.getOperator()));
                    return new Cigar(readCigarElements);
                }
                readCigarElements.add(cigarElement);
                currentReadPos = nextReadPos;
            } else if (currentReadPos == 0 && nextHapPos > readStartOnHaplotype) {
                currentReadPos = Math.min(nextHapPos - readStartOnHaplotype, read.getReadLength());
                readCigarElements.add(new CigarElement(currentReadPos, cigarElement.getOperator()));
            }
            currentHapPos = nextHapPos;
        }
        return new Cigar(readCigarElements);
    }
}

