/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.GenotypingEngine;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.SWPairwiseAlignment;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=-1100, stop=1100))
public class HaplotypeResolver
extends RodWalker<Integer, Integer> {
    protected static final String INTERSECTION_SET = "intersection";
    protected static final String SAME_STATUS = "same";
    protected static final String SOME_ALLELES_MATCH_STATUS = "someAllelesMatch";
    protected static final String SAME_START_DIFFERENT_ALLELES_STATUS = "sameStartDifferentAlleles";
    protected static final String SAME_BY_HAPLOTYPE_STATUS = "sameByHaplotype";
    protected static final String ONE_ALLELE_SUBSET_OF_OTHER_STATUS = "OneAlleleSubsetOfOther";
    protected static final String OVERLAPPING_EVENTS_STATUS = "overlappingEvents";
    protected static final int MAX_DISTANCE_BETWEEN_MERGED_RECORDS = 50;
    protected static final int MAX_HAPLOTYPE_TO_CONSIDER = 1000;
    protected static final int MAX_VARIANT_SIZE_TO_CONSIDER = 100;
    protected static final int ACTIVE_WINDOW = 1100;
    @Input(fullName="variant", shortName="V", doc="Input VCF file", required=true)
    public List<RodBinding<VariantContext>> variants;
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter baseWriter = null;
    private VariantContextWriter writer;
    @Argument(fullName="setKey", shortName="setKey", doc="Key used in the INFO key=value tag emitted describing which set the combined VCF record came from", required=false)
    protected String SET_KEY = "set";
    @Argument(fullName="statusKey", shortName="statusKey", doc="Key used in the INFO key=value tag emitted describing the extent to which records match", required=false)
    protected String STATUS_KEY = "status";
    private final LinkedList<VCcontext> queue = new LinkedList();
    private String source1;
    private String source2;
    private final List<VariantContext> sourceVCs1 = new ArrayList<VariantContext>();
    private final List<VariantContext> sourceVCs2 = new ArrayList<VariantContext>();
    private static final double SW_MATCH = 4.0;
    private static final double SW_MISMATCH = -10.0;
    private static final double SW_GAP = -25.0;
    private static final double SW_GAP_EXTEND = -1.3;

    @Override
    public void initialize() {
        if (this.variants.size() != 2) {
            throw new UserException.BadArgumentValue("variant", "this tool requires exactly 2 input variant files");
        }
        this.source1 = this.variants.get(0).getName();
        this.source2 = this.variants.get(1).getName();
        if (this.SET_KEY.toLowerCase().equals("null")) {
            this.SET_KEY = null;
        }
        if (this.STATUS_KEY.toLowerCase().equals("null")) {
            this.STATUS_KEY = null;
        }
        HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>();
        if (this.SET_KEY != null) {
            headerLines.add(new VCFInfoHeaderLine(this.SET_KEY, 1, VCFHeaderLineType.String, "Source VCF for the merged record"));
        }
        if (this.STATUS_KEY != null) {
            headerLines.add(new VCFInfoHeaderLine(this.STATUS_KEY, 1, VCFHeaderLineType.String, "Extent to which records match"));
        }
        VCFHeader vcfHeader = new VCFHeader(headerLines, Collections.<String>emptySet());
        this.baseWriter.writeHeader(vcfHeader);
        this.writer = VariantContextWriterFactory.sortOnTheFly(this.baseWriter, 1100);
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variants, context.getLocation());
        if (VCs.size() == 0) {
            return 0;
        }
        VCcontext vc = new VCcontext(VariantContextUtils.sitesOnlyVariantContexts(VCs), ref);
        if (!this.queue.isEmpty()) {
            VCcontext previous = this.queue.getLast();
            if (!previous.loc.onSameContig(vc.loc) || previous.loc.distance(vc.loc) > 50 || this.queue.getFirst().loc.distance(vc.loc) > 1000) {
                this.purgeQueue();
            }
        }
        this.queue.addLast(vc);
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        if (!this.queue.isEmpty()) {
            this.purgeQueue();
        }
        this.writer.close();
    }

    private void purgeQueue() {
        ReferenceContext refContext = this.queue.getFirst().ref;
        while (!this.queue.isEmpty()) {
            VCcontext context = this.queue.removeFirst();
            for (VariantContext vc : context.vcs) {
                if (vc.getSource().equals(this.source1)) {
                    this.sourceVCs1.add(vc);
                    continue;
                }
                this.sourceVCs2.add(vc);
            }
        }
        this.writeAndPurgeAllEqualVariants(this.sourceVCs1, this.sourceVCs2, SAME_STATUS);
        if (this.sourceVCs1.isEmpty()) {
            this.writeAll(this.sourceVCs2, this.source2, null);
        } else if (this.sourceVCs2.isEmpty()) {
            this.writeAll(this.sourceVCs1, this.source1, null);
        } else {
            this.resolveByHaplotype(refContext);
        }
        this.sourceVCs1.clear();
        this.sourceVCs2.clear();
    }

    private void writeAll(List<VariantContext> sourceVCs, String set, String status) {
        for (VariantContext vc : sourceVCs) {
            this.writeOne(vc, set, status);
        }
    }

    private void writeOne(VariantContext vc, String set, String status) {
        HashMap<String, Object> attrs = new HashMap<String, Object>(vc.getAttributes());
        if (this.SET_KEY != null && set != null) {
            attrs.put(this.SET_KEY, set);
        }
        if (this.STATUS_KEY != null && status != null) {
            attrs.put(this.STATUS_KEY, status);
        }
        this.writer.add(new VariantContextBuilder(vc).attributes(attrs).make());
    }

    private void writeAndPurgeAllEqualVariants(List<VariantContext> sourceVCs1, List<VariantContext> sourceVCs2, String status) {
        VariantContext current2;
        int currentIndex1 = 0;
        int currentIndex2 = 0;
        int size1 = sourceVCs1.size();
        int size2 = sourceVCs2.size();
        VariantContext current1 = currentIndex1 < size1 ? sourceVCs1.get(currentIndex1) : null;
        VariantContext variantContext = current2 = currentIndex2 < size2 ? sourceVCs2.get(currentIndex2) : null;
        while (current1 != null && current2 != null) {
            GenomeLoc loc2;
            GenomeLoc loc1 = this.getToolkit().getGenomeLocParser().createGenomeLoc(current1);
            if (loc1.equals(loc2 = this.getToolkit().getGenomeLocParser().createGenomeLoc(current2)) || loc1.getStart() == loc2.getStart() && (current1.getAlternateAlleles().size() > 1 || current2.getAlternateAlleles().size() > 1)) {
                if (this.determineAndWriteOverlap(current1, current2, status)) {
                    sourceVCs1.remove(currentIndex1);
                    sourceVCs2.remove(currentIndex2);
                    --size1;
                    --size2;
                } else {
                    ++currentIndex1;
                    ++currentIndex2;
                }
                current1 = currentIndex1 < size1 ? sourceVCs1.get(currentIndex1) : null;
                current2 = currentIndex2 < size2 ? sourceVCs2.get(currentIndex2) : null;
                continue;
            }
            if (loc1.isBefore(loc2)) {
                current1 = ++currentIndex1 < size1 ? sourceVCs1.get(currentIndex1) : null;
                continue;
            }
            current2 = ++currentIndex2 < size2 ? sourceVCs2.get(currentIndex2) : null;
        }
    }

    private boolean determineAndWriteOverlap(VariantContext vc1, VariantContext vc2, String status) {
        int allelesFrom1In2 = HaplotypeResolver.findOverlap(vc1, vc2);
        int allelesFrom2In1 = HaplotypeResolver.findOverlap(vc2, vc1);
        int totalAllelesIn1 = vc1.getAlternateAlleles().size();
        int totalAllelesIn2 = vc2.getAlternateAlleles().size();
        boolean allAllelesFrom1Overlap = allelesFrom1In2 == totalAllelesIn1;
        boolean allAllelesFrom2Overlap = allelesFrom2In1 == totalAllelesIn2;
        boolean thereIsOverlap = true;
        if (allAllelesFrom1Overlap && allAllelesFrom2Overlap) {
            this.writeOne(vc1, INTERSECTION_SET, status);
        } else if (allAllelesFrom1Overlap) {
            this.writeOne(vc2, INTERSECTION_SET, this.source1 + "IsSubsetOf" + this.source2);
        } else if (allAllelesFrom2Overlap) {
            this.writeOne(vc1, INTERSECTION_SET, this.source2 + "IsSubsetOf" + this.source1);
        } else if (allelesFrom1In2 > 0) {
            this.writeOne(vc1, INTERSECTION_SET, SOME_ALLELES_MATCH_STATUS);
        } else if (totalAllelesIn1 > 1 || totalAllelesIn2 > 1) {
            this.writeOne(vc1, INTERSECTION_SET, SAME_START_DIFFERENT_ALLELES_STATUS);
        } else {
            thereIsOverlap = false;
        }
        return thereIsOverlap;
    }

    private static int findOverlap(VariantContext target, VariantContext comparison) {
        int overlap = 0;
        for (Allele allele : target.getAlternateAlleles()) {
            if (!comparison.hasAlternateAllele(allele)) continue;
            ++overlap;
        }
        return overlap;
    }

    private void resolveByHaplotype(ReferenceContext refContext) {
        byte[] source1Haplotype = this.generateHaplotype(this.sourceVCs1, refContext);
        byte[] source2Haplotype = this.generateHaplotype(this.sourceVCs2, refContext);
        SWPairwiseAlignment swConsensus1 = new SWPairwiseAlignment(refContext.getBases(), source1Haplotype, 4.0, -10.0, -25.0, -1.3);
        SWPairwiseAlignment swConsensus2 = new SWPairwiseAlignment(refContext.getBases(), source2Haplotype, 4.0, -10.0, -25.0, -1.3);
        if (swConsensus1.getCigar().toString().contains("S") || swConsensus1.getCigar().getReferenceLength() < 20 || swConsensus2.getCigar().toString().contains("S") || swConsensus2.getCigar().getReferenceLength() < 20) {
            logger.debug("Bad SW alignment; aborting at " + refContext.getLocus());
            return;
        }
        TreeMap<Integer, VariantContext> source1Map = new TreeMap<Integer, VariantContext>(GenotypingEngine.generateVCsFromAlignment(new Haplotype(source1Haplotype), 0, swConsensus1.getCigar(), refContext.getBases(), source1Haplotype, refContext.getWindow(), this.source1));
        TreeMap<Integer, VariantContext> source2Map = new TreeMap<Integer, VariantContext>(GenotypingEngine.generateVCsFromAlignment(new Haplotype(source2Haplotype), 0, swConsensus2.getCigar(), refContext.getBases(), source2Haplotype, refContext.getWindow(), this.source2));
        if (source1Map.size() == 0 || source2Map.size() == 0) {
            logger.debug("No source alleles; aborting at " + refContext.getLocus());
            return;
        }
        ArrayList<VariantContext> source1Alleles = new ArrayList<VariantContext>(source1Map.values());
        ArrayList<VariantContext> source2Alleles = new ArrayList<VariantContext>(source2Map.values());
        this.writeAndPurgeAllEqualVariants(source1Alleles, source2Alleles, SAME_BY_HAPLOTYPE_STATUS);
        if (source1Alleles.isEmpty()) {
            this.writeAll(source2Alleles, this.source2, null);
        } else if (source2Alleles.isEmpty()) {
            this.writeAll(source1Alleles, this.source1, null);
        } else {
            this.writeDifferences(source1Alleles, source2Alleles);
        }
    }

    private byte[] generateHaplotype(List<VariantContext> sourceVCs, ReferenceContext refContext) {
        int startPos;
        StringBuilder sb = new StringBuilder();
        int currentPos = startPos = refContext.getWindow().getStart();
        byte[] reference = refContext.getBases();
        for (VariantContext vc : sourceVCs) {
            int vcStart = vc.getStart();
            int refAlleleLength = vc.getReference().length();
            if (refAlleleLength == vc.getEnd() - vc.getStart()) {
                ++vcStart;
            }
            while (currentPos < vcStart) {
                sb.append((char)reference[currentPos++ - startPos]);
            }
            sb.append(vc.getAlternateAllele(0).getBaseString());
            currentPos += refAlleleLength;
        }
        int stopPos = refContext.getWindow().getStop();
        while (currentPos < stopPos) {
            sb.append((char)reference[currentPos++ - startPos]);
        }
        return sb.toString().getBytes();
    }

    private void writeDifferences(List<VariantContext> source1Alleles, List<VariantContext> source2Alleles) {
        int currentIndex1 = 0;
        int currentIndex2 = 0;
        int size1 = source1Alleles.size();
        int size2 = source2Alleles.size();
        VariantContext current1 = source1Alleles.get(0);
        VariantContext current2 = source2Alleles.get(0);
        while (currentIndex1 < size1 || currentIndex2 < size2) {
            if (current1 == null) {
                this.writeOne(current2, this.source2, null);
                current2 = ++currentIndex2 < size2 ? source2Alleles.get(currentIndex2) : null;
                continue;
            }
            if (current2 == null) {
                this.writeOne(current1, this.source1, null);
                current1 = ++currentIndex1 < size1 ? source1Alleles.get(currentIndex1) : null;
                continue;
            }
            GenomeLoc loc1 = this.getToolkit().getGenomeLocParser().createGenomeLoc(current1);
            GenomeLoc loc2 = this.getToolkit().getGenomeLocParser().createGenomeLoc(current2);
            if (loc1.getStart() == loc2.getStart() || loc1.overlapsP(loc2)) {
                String allele2;
                String allele1;
                String status = loc1.getStart() == loc2.getStart() ? ((allele1 = current1.getAlternateAllele(0).getBaseString()).indexOf(allele2 = current2.getAlternateAllele(0).getBaseString()) != -1 || allele2.indexOf(allele1) != -1 ? ONE_ALLELE_SUBSET_OF_OTHER_STATUS : SAME_START_DIFFERENT_ALLELES_STATUS) : OVERLAPPING_EVENTS_STATUS;
                this.writeOne(current1, INTERSECTION_SET, status);
                current1 = ++currentIndex1 < size1 ? source1Alleles.get(currentIndex1) : null;
                current2 = currentIndex2 < size2 ? source2Alleles.get(++currentIndex2) : null;
                continue;
            }
            if (loc1.isBefore(loc2)) {
                this.writeOne(current1, this.source1, null);
                current1 = ++currentIndex1 < size1 ? source1Alleles.get(currentIndex1) : null;
                continue;
            }
            this.writeOne(current2, this.source2, null);
            current2 = ++currentIndex2 < size2 ? source2Alleles.get(currentIndex2) : null;
        }
    }

    private class VCcontext {
        public final Collection<VariantContext> vcs;
        public final GenomeLoc loc;
        public final ReferenceContext ref;

        public VCcontext(Collection<VariantContext> vcs, ReferenceContext ref) {
            this.vcs = vcs;
            this.loc = HaplotypeResolver.this.getToolkit().getGenomeLocParser().createGenomeLoc(vcs.iterator().next());
            this.ref = ref;
        }
    }
}

