/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.haplotypecaller;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnAssemblyGraph;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnEdge;
import org.broadinstitute.sting.gatk.walkers.haplotypecaller.DeBruijnVertex;
import org.broadinstitute.sting.utils.SWPairwiseAlignment;
import org.broadinstitute.sting.utils.sam.AlignmentUtils;

public class KBestPaths {
    private static int MAX_PATHS_TO_HOLD = 100;

    protected KBestPaths() {
    }

    @Ensures(value={"result != null", "result.size() <= k"})
    public static List<Path> getKBestPaths(DeBruijnAssemblyGraph graph, int k) {
        if (graph == null) {
            throw new IllegalArgumentException("Attempting to traverse a null graph.");
        }
        if (k > MAX_PATHS_TO_HOLD / 2) {
            throw new IllegalArgumentException("Asked for more paths than internal parameters allow for.");
        }
        ArrayList<Path> bestPaths = new ArrayList<Path>();
        for (DeBruijnVertex v : graph.vertexSet()) {
            if (graph.inDegreeOf(v) != 0) continue;
            KBestPaths.findBestPaths(new Path(v, graph), bestPaths);
        }
        Collections.sort(bestPaths, new PathComparatorTotalScore());
        Collections.reverse(bestPaths);
        return bestPaths.subList(0, Math.min(k, bestPaths.size()));
    }

    private static void findBestPaths(Path path, List<Path> bestPaths) {
        KBestPaths.findBestPaths(path, bestPaths, new MyInt());
    }

    private static void findBestPaths(Path path, List<Path> bestPaths, MyInt n) {
        if (KBestPaths.allOutgoingEdgesHaveBeenVisited(path)) {
            if (path.containsRefEdge()) {
                if (bestPaths.size() >= MAX_PATHS_TO_HOLD) {
                    Collections.sort(bestPaths, new PathComparatorTotalScore());
                    for (int iii = 0; iii < 20; ++iii) {
                        bestPaths.remove(0);
                    }
                }
                bestPaths.add(path);
            }
        } else if (n.val <= 10000) {
            ArrayList edgeArrayList = new ArrayList();
            edgeArrayList.addAll(path.graph.outgoingEdgesOf(path.lastVertex));
            Collections.sort(edgeArrayList, new DeBruijnEdge.EdgeWeightComparator());
            Collections.reverse(edgeArrayList);
            for (DeBruijnEdge edge : edgeArrayList) {
                if (path.containsEdge(edge)) continue;
                Path newPath = new Path(path, edge);
                ++n.val;
                KBestPaths.findBestPaths(newPath, bestPaths, n);
            }
        }
    }

    private static boolean allOutgoingEdgesHaveBeenVisited(Path path) {
        for (DeBruijnEdge edge : path.graph.outgoingEdgesOf(path.lastVertex)) {
            if (path.containsEdge(edge)) continue;
            return false;
        }
        return true;
    }

    protected static class PathComparatorTotalScore
    implements Comparator<Path>,
    Serializable {
        protected PathComparatorTotalScore() {
        }

        @Override
        public int compare(Path path1, Path path2) {
            return path1.totalScore - path2.totalScore;
        }
    }

    protected static class Path {
        private final DeBruijnVertex lastVertex;
        private final List<DeBruijnEdge> edges;
        private final int totalScore;
        private final DeBruijnAssemblyGraph graph;
        private static final double SW_MATCH = 20.0;
        private static final double SW_MISMATCH = -15.0;
        private static final double SW_GAP = -26.0;
        private static final double SW_GAP_EXTEND = -1.1;
        private static final byte[] STARTING_SW_ANCHOR_BYTES = "XXXXXXXXX".getBytes();

        public Path(DeBruijnVertex initialVertex, DeBruijnAssemblyGraph graph) {
            this.lastVertex = initialVertex;
            this.edges = new ArrayList<DeBruijnEdge>(0);
            this.totalScore = 0;
            this.graph = graph;
        }

        public Path(Path p, DeBruijnEdge edge) {
            if (!((DeBruijnVertex)p.graph.getEdgeSource(edge)).equals(p.lastVertex)) {
                throw new IllegalStateException("Edges added to path must be contiguous.");
            }
            this.graph = p.graph;
            this.lastVertex = (DeBruijnVertex)p.graph.getEdgeTarget(edge);
            this.edges = new ArrayList<DeBruijnEdge>(p.edges);
            this.edges.add(edge);
            this.totalScore = p.totalScore + edge.getMultiplicity();
        }

        public boolean containsEdge(DeBruijnEdge edge) {
            if (edge == null) {
                throw new IllegalArgumentException("Attempting to test null edge.");
            }
            for (DeBruijnEdge e : this.edges) {
                if (!e.equals(this.graph, edge)) continue;
                return true;
            }
            return false;
        }

        public int numInPath(DeBruijnEdge edge) {
            if (edge == null) {
                throw new IllegalArgumentException("Attempting to test null edge.");
            }
            int numInPath = 0;
            for (DeBruijnEdge e : this.edges) {
                if (!e.equals(this.graph, edge)) continue;
                ++numInPath;
            }
            return numInPath;
        }

        public boolean containsRefEdge() {
            for (DeBruijnEdge e : this.edges) {
                if (!e.isRef()) continue;
                return true;
            }
            return false;
        }

        public List<DeBruijnEdge> getEdges() {
            return this.edges;
        }

        public int getScore() {
            return this.totalScore;
        }

        public DeBruijnVertex getLastVertexInPath() {
            return this.lastVertex;
        }

        @Ensures(value={"result != null"})
        public byte[] getBases() {
            if (this.edges.size() == 0) {
                return this.graph.getAdditionalSequence(this.lastVertex);
            }
            byte[] bases = this.graph.getAdditionalSequence((DeBruijnVertex)this.graph.getEdgeSource(this.edges.get(0)));
            for (DeBruijnEdge e : this.edges) {
                bases = ArrayUtils.addAll(bases, this.graph.getAdditionalSequence((DeBruijnVertex)this.graph.getEdgeTarget(e)));
            }
            return bases;
        }

        @Ensures(value={"result != null"})
        public Cigar calculateCigar() {
            BubbleStateMachine bsm;
            block7: {
                block6: {
                    Cigar cigar = new Cigar();
                    if (this.edges.get(0).isRef() && !this.graph.isRefSource(this.edges.get(0))) {
                        for (CigarElement ce : this.calculateCigarForCompleteBubble(null, null, (DeBruijnVertex)this.graph.getEdgeSource(this.edges.get(0))).getCigarElements()) {
                            cigar.add(ce);
                        }
                    }
                    bsm = new BubbleStateMachine(cigar);
                    for (DeBruijnEdge e : this.edges) {
                        if (e.equals(this.graph, this.edges.get(0))) {
                            this.advanceBubbleStateMachine(bsm, (DeBruijnVertex)this.graph.getEdgeSource(e), null);
                        }
                        this.advanceBubbleStateMachine(bsm, (DeBruijnVertex)this.graph.getEdgeTarget(e), e);
                    }
                    if (!bsm.inBubble) break block6;
                    for (CigarElement ce : this.calculateCigarForCompleteBubble(bsm.bubbleBytes, bsm.lastSeenReferenceNode, null).getCigarElements()) {
                        bsm.cigar.add(ce);
                    }
                    break block7;
                }
                if (!this.edges.get(this.edges.size() - 1).isRef() || this.graph.isRefSink(this.edges.get(this.edges.size() - 1))) break block7;
                for (CigarElement ce : this.calculateCigarForCompleteBubble(bsm.bubbleBytes, (DeBruijnVertex)this.graph.getEdgeTarget(this.edges.get(this.edges.size() - 1)), null).getCigarElements()) {
                    bsm.cigar.add(ce);
                }
            }
            return AlignmentUtils.consolidateCigar(bsm.cigar);
        }

        @Requires(value={"bsm != null", "graph != null", "node != null"})
        private void advanceBubbleStateMachine(BubbleStateMachine bsm, DeBruijnVertex node, DeBruijnEdge e) {
            if (this.graph.isReferenceNode(node)) {
                if (!bsm.inBubble) {
                    if (e != null && !e.isRef()) {
                        if (this.graph.referencePathExists((DeBruijnVertex)this.graph.getEdgeSource(e), node)) {
                            for (CigarElement ce : this.calculateCigarForCompleteBubble(null, (DeBruijnVertex)this.graph.getEdgeSource(e), node).getCigarElements()) {
                                bsm.cigar.add(ce);
                            }
                            bsm.cigar.add(new CigarElement(this.graph.getAdditionalSequence(node).length, CigarOperator.M));
                        } else if (((DeBruijnVertex)this.graph.getEdgeSource(e)).equals(this.graph.getEdgeTarget(e))) {
                            bsm.cigar.add(new CigarElement(this.graph.getAdditionalSequence(node).length, CigarOperator.I));
                        } else {
                            bsm.inBubble = true;
                            bsm.bubbleBytes = null;
                            bsm.lastSeenReferenceNode = (DeBruijnVertex)this.graph.getEdgeSource(e);
                            bsm.bubbleBytes = ArrayUtils.addAll(bsm.bubbleBytes, this.graph.getAdditionalSequence(node));
                        }
                    } else {
                        bsm.cigar.add(new CigarElement(this.graph.getAdditionalSequence(node).length, CigarOperator.M));
                    }
                } else if (bsm.lastSeenReferenceNode != null && !this.graph.referencePathExists(bsm.lastSeenReferenceNode, node)) {
                    bsm.bubbleBytes = ArrayUtils.addAll(bsm.bubbleBytes, this.graph.getAdditionalSequence(node));
                } else {
                    for (CigarElement ce : this.calculateCigarForCompleteBubble(bsm.bubbleBytes, bsm.lastSeenReferenceNode, node).getCigarElements()) {
                        bsm.cigar.add(ce);
                    }
                    bsm.inBubble = false;
                    bsm.bubbleBytes = null;
                    bsm.lastSeenReferenceNode = null;
                    bsm.cigar.add(new CigarElement(this.graph.getAdditionalSequence(node).length, CigarOperator.M));
                }
            } else if (bsm.inBubble) {
                bsm.bubbleBytes = ArrayUtils.addAll(bsm.bubbleBytes, this.graph.getAdditionalSequence(node));
            } else {
                bsm.inBubble = true;
                bsm.bubbleBytes = null;
                bsm.lastSeenReferenceNode = e != null ? (DeBruijnVertex)this.graph.getEdgeSource(e) : null;
                bsm.bubbleBytes = ArrayUtils.addAll(bsm.bubbleBytes, this.graph.getAdditionalSequence(node));
            }
        }

        @Requires(value={"graph != null"})
        @Ensures(value={"result != null"})
        private Cigar calculateCigarForCompleteBubble(byte[] bubbleBytes, DeBruijnVertex fromVertex, DeBruijnVertex toVertex) {
            byte[] refBytes = this.graph.getReferenceBytes(fromVertex == null ? this.graph.getReferenceSourceVertex() : fromVertex, toVertex == null ? this.graph.getReferenceSinkVertex() : toVertex, fromVertex == null, toVertex == null);
            Cigar returnCigar = new Cigar();
            byte[] padding = STARTING_SW_ANCHOR_BYTES;
            boolean goodAlignment = false;
            SWPairwiseAlignment swConsensus = null;
            while (!goodAlignment && padding.length < 1000) {
                byte[] alternate;
                byte[] reference = ArrayUtils.addAll(ArrayUtils.addAll(padding = ArrayUtils.addAll(padding, padding), refBytes), padding);
                swConsensus = new SWPairwiseAlignment(reference, alternate = ArrayUtils.addAll(ArrayUtils.addAll(padding, bubbleBytes), padding), 20.0, -15.0, -26.0, -1.1);
                if (swConsensus.getAlignmentStart2wrt1() != 0 || swConsensus.getCigar().toString().contains("S") || swConsensus.getCigar().getReferenceLength() != reference.length) continue;
                goodAlignment = true;
            }
            if (!goodAlignment) {
                returnCigar.add(new CigarElement(1, CigarOperator.N));
                return returnCigar;
            }
            Cigar swCigar = swConsensus.getCigar();
            if (swCigar.numCigarElements() > 6) {
                returnCigar.add(new CigarElement(1, CigarOperator.N));
            } else {
                CigarElement ce;
                int iii;
                int skipElement = -1;
                if (fromVertex == null) {
                    for (iii = 0; iii < swCigar.numCigarElements(); ++iii) {
                        ce = swCigar.getCigarElement(iii);
                        if (!ce.getOperator().equals((Object)CigarOperator.D)) continue;
                        skipElement = iii;
                        break;
                    }
                } else if (toVertex == null) {
                    for (iii = swCigar.numCigarElements() - 1; iii >= 0; --iii) {
                        ce = swCigar.getCigarElement(iii);
                        if (!ce.getOperator().equals((Object)CigarOperator.D)) continue;
                        skipElement = iii;
                        break;
                    }
                }
                for (iii = 0; iii < swCigar.numCigarElements(); ++iii) {
                    int length = swCigar.getCigarElement(iii).getLength();
                    if (iii == 0) {
                        length -= padding.length;
                    }
                    if (iii == swCigar.numCigarElements() - 1) {
                        length -= padding.length;
                    }
                    if (length <= 0) continue;
                    returnCigar.add(new CigarElement(length, skipElement == iii ? CigarOperator.X : swCigar.getCigarElement(iii).getOperator()));
                }
                if (refBytes == null && returnCigar.getReferenceLength() != 0 || refBytes != null && returnCigar.getReferenceLength() != refBytes.length) {
                    throw new IllegalStateException("SmithWaterman cigar failure: " + (refBytes == null ? "-" : new String(refBytes)) + " against " + new String(bubbleBytes) + " = " + swConsensus.getCigar());
                }
            }
            return returnCigar;
        }

        protected static class BubbleStateMachine {
            public boolean inBubble = false;
            public byte[] bubbleBytes = null;
            public DeBruijnVertex lastSeenReferenceNode = null;
            public Cigar cigar = null;

            public BubbleStateMachine(Cigar initialCigar) {
                this.cigar = initialCigar;
            }
        }
    }

    protected static class MyInt {
        public int val = 0;

        protected MyInt() {
        }
    }
}

