/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import com.google.java.contract.Ensures;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.Haplotype;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.genotyper.PerReadAlleleLikelihoodMap;
import org.broadinstitute.sting.utils.pairhmm.Log10PairHMM;
import org.broadinstitute.sting.utils.pairhmm.PairHMM;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;

public class PairHMMIndelErrorModel {
    public static final int BASE_QUAL_THRESHOLD = 20;
    private boolean DEBUG = false;
    private static final int MAX_CACHED_QUAL = 127;
    private static final double[] baseMatchArray;
    private static final double[] baseMismatchArray;
    private static final double LOG_ONE_HALF;
    private static final int START_HRUN_GAP_IDX = 4;
    private static final int MAX_HRUN_GAP_IDX = 20;
    private static final byte MIN_GAP_OPEN_PENALTY = 30;
    private static final byte MIN_GAP_CONT_PENALTY = 10;
    private static final byte GAP_PENALTY_HRUN_STEP = 1;
    private final byte[] GAP_OPEN_PROB_TABLE;
    private final byte[] GAP_CONT_PROB_TABLE;
    private final PairHMM pairHMM;

    public PairHMMIndelErrorModel(byte indelGOP, byte indelGCP, boolean deb, PairHMM.HMM_IMPLEMENTATION hmmType) {
        this.DEBUG = deb;
        switch (hmmType) {
            case EXACT: {
                this.pairHMM = new Log10PairHMM(true);
                break;
            }
            case ORIGINAL: {
                this.pairHMM = new Log10PairHMM(false);
                break;
            }
            case LOGLESS_CACHING: {
                throw new UserException.BadArgumentValue("pairHMM", " this option (LOGLESS_CACHING in UG) is still under development");
            }
            default: {
                throw new UserException.BadArgumentValue("pairHMM", "Specified pairHMM implementation is unrecognized or incompatible with the UnifiedGenotyper. Acceptable options are ORIGINAL, EXACT or LOGLESS_CACHING (the third option is still under development).");
            }
        }
        this.GAP_CONT_PROB_TABLE = new byte[20];
        this.GAP_OPEN_PROB_TABLE = new byte[20];
        for (int i = 0; i < 4; ++i) {
            this.GAP_OPEN_PROB_TABLE[i] = indelGOP;
            this.GAP_CONT_PROB_TABLE[i] = indelGCP;
        }
        double step = 0.1;
        int gop = indelGOP;
        int gcp = indelGCP;
        for (int i = 4; i < 20; ++i) {
            if ((gop = (byte)(gop - 1)) < 30) {
                gop = 30;
            }
            if ((gcp = (byte)((double)gcp - step)) < 10) {
                gcp = 10;
            }
            this.GAP_OPEN_PROB_TABLE[i] = gop;
            this.GAP_CONT_PROB_TABLE[i] = gcp;
        }
    }

    private static void getContextHomopolymerLength(byte[] refBytes, int[] hrunArray) {
        int i;
        hrunArray[0] = 0;
        int[] hforward = new int[hrunArray.length];
        int[] hreverse = new int[hrunArray.length];
        for (i = 1; i < refBytes.length; ++i) {
            hforward[i] = refBytes[i] == refBytes[i - 1] ? hforward[i - 1] + 1 : 0;
        }
        for (i = refBytes.length - 1; i > 0; --i) {
            if (refBytes[i - 1] != refBytes[i]) continue;
            int n = i - 1;
            hreverse[n] = hreverse[n] + (hreverse[i] + 1);
        }
        for (i = 1; i < refBytes.length; ++i) {
            hrunArray[i] = hforward[i] + hreverse[i];
        }
    }

    private void fillGapProbabilities(int[] hrunProfile, byte[] contextLogGapOpenProbabilities, byte[] contextLogGapContinuationProbabilities) {
        for (int i = 0; i < hrunProfile.length; ++i) {
            if (hrunProfile[i] >= 20) {
                contextLogGapOpenProbabilities[i] = this.GAP_OPEN_PROB_TABLE[19];
                contextLogGapContinuationProbabilities[i] = this.GAP_CONT_PROB_TABLE[19];
                continue;
            }
            contextLogGapOpenProbabilities[i] = this.GAP_OPEN_PROB_TABLE[hrunProfile[i]];
            contextLogGapContinuationProbabilities[i] = this.GAP_CONT_PROB_TABLE[hrunProfile[i]];
        }
    }

    public synchronized double[] computeDiploidReadHaplotypeLikelihoods(ReadBackedPileup pileup, LinkedHashMap<Allele, Haplotype> haplotypeMap, ReferenceContext ref, int eventLength, PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap, double downsamplingFraction, PrintStream downsamplingLog) {
        int numHaplotypes = haplotypeMap.size();
        int[] readCounts = new int[pileup.getNumberOfElements()];
        double[][] readLikelihoods = this.computeGeneralReadHaplotypeLikelihoods(pileup, haplotypeMap, ref, eventLength, perReadAlleleLikelihoodMap, readCounts);
        perReadAlleleLikelihoodMap.performPerAlleleDownsampling(downsamplingFraction, downsamplingLog);
        return PairHMMIndelErrorModel.getDiploidHaplotypeLikelihoods(numHaplotypes, readCounts, readLikelihoods);
    }

    @Ensures(value={"result != null && result.length == pileup.getNumberOfElements()"})
    public synchronized double[][] computeGeneralReadHaplotypeLikelihoods(ReadBackedPileup pileup, LinkedHashMap<Allele, Haplotype> haplotypeMap, ReferenceContext ref, int eventLength, PerReadAlleleLikelihoodMap perReadAlleleLikelihoodMap, int[] readCounts) {
        double[][] readLikelihoods = new double[pileup.getNumberOfElements()][haplotypeMap.size()];
        int readIdx = 0;
        for (PileupElement p : pileup) {
            readCounts[readIdx] = p.getRepresentativeCount();
            if (perReadAlleleLikelihoodMap.containsPileupElement(p)) {
                Map<Allele, Double> el = perReadAlleleLikelihoodMap.getLikelihoodsAssociatedWithPileupElement(p);
                int j = 0;
                for (Allele a : haplotypeMap.keySet()) {
                    readLikelihoods[readIdx][j++] = el.get(a);
                }
            } else {
                GATKSAMRecord read;
                int refWindowStart = ref.getWindow().getStart();
                int refWindowStop = ref.getWindow().getStop();
                if (this.DEBUG) {
                    System.out.format("Read Name:%s, aln start:%d aln stop:%d orig cigar:%s\n", p.getRead().getReadName(), p.getRead().getAlignmentStart(), p.getRead().getAlignmentEnd(), p.getRead().getCigarString());
                }
                if (!(read = ReadClipper.hardClipAdaptorSequence(p.getRead())).isEmpty() && read.getSoftEnd() > refWindowStop && read.getSoftStart() < refWindowStop) {
                    read = ReadClipper.hardClipByReferenceCoordinatesRightTail(read, ref.getWindow().getStop());
                }
                if (!read.isEmpty() && read.getSoftStart() < refWindowStart && read.getSoftEnd() > refWindowStart) {
                    read = ReadClipper.hardClipByReferenceCoordinatesLeftTail(read, ref.getWindow().getStart());
                }
                if (read.isEmpty() || (read = ReadClipper.hardClipLowQualEnds(read, (byte)20)).isEmpty()) continue;
                int trailingBases = 3;
                long readStart = read.getSoftStart();
                long readEnd = read.getSoftEnd();
                long eventStartPos = ref.getLocus().getStart();
                boolean softClips = this.useSoftClippedBases(read, eventStartPos, eventLength);
                int numStartSoftClippedBases = softClips ? read.getAlignmentStart() - read.getSoftStart() : 0;
                int numEndSoftClippedBases = softClips ? read.getSoftEnd() - read.getAlignmentEnd() : 0;
                byte[] unclippedReadBases = read.getReadBases();
                byte[] unclippedReadQuals = read.getBaseQualities();
                int extraOffset = Math.abs(eventLength);
                long startLocationInRefForHaplotypes = Math.max(readStart + (long)numStartSoftClippedBases - 3L - (long)ReadUtils.getFirstInsertionOffset(read) - (long)extraOffset, 0L);
                long stopLocationInRefForHaplotypes = readEnd - (long)numEndSoftClippedBases + 3L + (long)ReadUtils.getLastInsertionOffset(read) + (long)extraOffset;
                if (this.DEBUG) {
                    System.out.format("orig Start:%d orig stop: %d\n", startLocationInRefForHaplotypes, stopLocationInRefForHaplotypes);
                }
                int readLength = read.getReadLength() - numStartSoftClippedBases - numEndSoftClippedBases;
                if (startLocationInRefForHaplotypes < (long)ref.getWindow().getStart()) {
                    startLocationInRefForHaplotypes = ref.getWindow().getStart();
                } else if (startLocationInRefForHaplotypes > (long)ref.getWindow().getStop()) {
                    startLocationInRefForHaplotypes = ref.getWindow().getStop();
                }
                if (stopLocationInRefForHaplotypes > (long)ref.getWindow().getStop()) {
                    stopLocationInRefForHaplotypes = ref.getWindow().getStop();
                }
                if (stopLocationInRefForHaplotypes <= startLocationInRefForHaplotypes + (long)readLength) {
                    stopLocationInRefForHaplotypes = startLocationInRefForHaplotypes + (long)readLength - 1L;
                }
                if (this.DEBUG) {
                    System.out.format("numStartSoftClippedBases: %d numEndSoftClippedBases: %d WinStart:%d WinStop:%d start: %d stop: %d readLength: %d\n", numStartSoftClippedBases, numEndSoftClippedBases, ref.getWindow().getStart(), ref.getWindow().getStop(), startLocationInRefForHaplotypes, stopLocationInRefForHaplotypes, read.getReadLength());
                }
                if (numStartSoftClippedBases + numEndSoftClippedBases >= unclippedReadBases.length) {
                    int j = 0;
                    for (Allele a : haplotypeMap.keySet()) {
                        perReadAlleleLikelihoodMap.add(p, a, (Double)0.0);
                        readLikelihoods[readIdx][j++] = 0.0;
                    }
                } else {
                    byte[] baseDeletionQualities;
                    byte[] baseInsertionQualities;
                    int endOfCopy = unclippedReadBases.length - numEndSoftClippedBases;
                    byte[] readBases = Arrays.copyOfRange(unclippedReadBases, numStartSoftClippedBases, endOfCopy);
                    byte[] readQuals = Arrays.copyOfRange(unclippedReadQuals, numStartSoftClippedBases, endOfCopy);
                    int j = 0;
                    byte[] previousHaplotypeSeen = null;
                    byte[] contextLogGapOpenProbabilities = new byte[readBases.length];
                    byte[] contextLogGapContinuationProbabilities = new byte[readBases.length];
                    int[] hrunProfile = new int[readBases.length];
                    PairHMMIndelErrorModel.getContextHomopolymerLength(readBases, hrunProfile);
                    this.fillGapProbabilities(hrunProfile, contextLogGapOpenProbabilities, contextLogGapContinuationProbabilities);
                    if (read.hasBaseIndelQualities()) {
                        baseInsertionQualities = Arrays.copyOfRange(read.getBaseInsertionQualities(), numStartSoftClippedBases, endOfCopy);
                        baseDeletionQualities = Arrays.copyOfRange(read.getBaseDeletionQualities(), numStartSoftClippedBases, endOfCopy);
                    } else {
                        baseInsertionQualities = contextLogGapOpenProbabilities;
                        baseDeletionQualities = contextLogGapOpenProbabilities;
                    }
                    boolean firstHap = true;
                    for (Allele a : haplotypeMap.keySet()) {
                        Haplotype haplotype = haplotypeMap.get(a);
                        if (stopLocationInRefForHaplotypes > haplotype.getStopPosition()) {
                            stopLocationInRefForHaplotypes = haplotype.getStopPosition();
                        }
                        if (startLocationInRefForHaplotypes < haplotype.getStartPosition()) {
                            startLocationInRefForHaplotypes = haplotype.getStartPosition();
                        } else if (startLocationInRefForHaplotypes > haplotype.getStopPosition()) {
                            startLocationInRefForHaplotypes = haplotype.getStopPosition();
                        }
                        long indStart = startLocationInRefForHaplotypes - haplotype.getStartPosition();
                        long indStop = stopLocationInRefForHaplotypes - haplotype.getStartPosition();
                        if (this.DEBUG) {
                            System.out.format("indStart: %d indStop: %d WinStart:%d WinStop:%d start: %d stop: %d readLength: %d C:%s\n", indStart, indStop, ref.getWindow().getStart(), ref.getWindow().getStop(), startLocationInRefForHaplotypes, stopLocationInRefForHaplotypes, read.getReadLength(), read.getCigar().toString());
                        }
                        byte[] haplotypeBases = Arrays.copyOfRange(haplotype.getBases(), (int)indStart, (int)indStop);
                        int X_METRIC_LENGTH = readBases.length + 2;
                        int Y_METRIC_LENGTH = haplotypeBases.length + 2;
                        if (previousHaplotypeSeen == null) {
                            this.pairHMM.initialize(X_METRIC_LENGTH, Y_METRIC_LENGTH);
                        }
                        int startIndexInHaplotype = 0;
                        if (previousHaplotypeSeen != null) {
                            startIndexInHaplotype = this.computeFirstDifferingPosition(haplotypeBases, previousHaplotypeSeen);
                        }
                        previousHaplotypeSeen = (byte[])haplotypeBases.clone();
                        double readLikelihood = this.pairHMM.computeReadLikelihoodGivenHaplotypeLog10(haplotypeBases, readBases, readQuals, baseInsertionQualities, baseDeletionQualities, contextLogGapContinuationProbabilities, startIndexInHaplotype, firstHap);
                        if (this.DEBUG) {
                            System.out.println("H:" + new String(haplotypeBases));
                            System.out.println("R:" + new String(readBases));
                            System.out.format("L:%4.2f\n", readLikelihood);
                            System.out.format("StPos:%d\n", startIndexInHaplotype);
                        }
                        perReadAlleleLikelihoodMap.add(p, a, (Double)readLikelihood);
                        readLikelihoods[readIdx][j++] = readLikelihood;
                        firstHap = false;
                    }
                }
            }
            ++readIdx;
        }
        if (this.DEBUG) {
            System.out.println("\nLikelihood summary");
            for (readIdx = 0; readIdx < pileup.getNumberOfElements(); ++readIdx) {
                System.out.format("Read Index: %d ", readIdx);
                for (int i = 0; i < readLikelihoods[readIdx].length; ++i) {
                    System.out.format("L%d: %f ", i, readLikelihoods[readIdx][i]);
                }
                System.out.println();
            }
        }
        return readLikelihoods;
    }

    private boolean useSoftClippedBases(GATKSAMRecord read, long eventStartPos, int eventLength) {
        return !((long)read.getAlignmentStart() >= eventStartPos - (long)eventLength && (long)read.getAlignmentStart() <= eventStartPos + 1L || (long)read.getAlignmentEnd() >= eventStartPos && (long)read.getAlignmentEnd() <= eventStartPos + (long)eventLength);
    }

    private int computeFirstDifferingPosition(byte[] b1, byte[] b2) {
        if (b1.length != b2.length) {
            return 0;
        }
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return i;
        }
        return b1.length;
    }

    private static double[] getDiploidHaplotypeLikelihoods(int numHaplotypes, int[] readCounts, double[][] readLikelihoods) {
        double[][] haplotypeLikehoodMatrix = new double[numHaplotypes][numHaplotypes];
        for (int i = 0; i < numHaplotypes; ++i) {
            for (int j = i; j < numHaplotypes; ++j) {
                for (int readIdx = 0; readIdx < readLikelihoods.length; ++readIdx) {
                    if (Double.isInfinite(readLikelihoods[readIdx][i]) && Double.isInfinite(readLikelihoods[readIdx][j])) continue;
                    double li = readLikelihoods[readIdx][i];
                    double lj = readLikelihoods[readIdx][j];
                    int readCount = readCounts[readIdx];
                    double[] dArray = haplotypeLikehoodMatrix[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)readCount * (MathUtils.approximateLog10SumLog10(li, lj) + LOG_ONE_HALF);
                }
            }
        }
        double[] genotypeLikelihoods = new double[numHaplotypes * (numHaplotypes + 1) / 2];
        int k = 0;
        for (int j = 0; j < numHaplotypes; ++j) {
            for (int i = 0; i <= j; ++i) {
                genotypeLikelihoods[k++] = haplotypeLikehoodMatrix[i][j];
            }
        }
        return MathUtils.normalizeFromLog10(genotypeLikelihoods, false, true);
    }

    static {
        LOG_ONE_HALF = -Math.log10(2.0);
        baseMatchArray = new double[128];
        baseMismatchArray = new double[128];
        for (int k = 1; k <= 127; ++k) {
            double baseProb = Math.pow(10.0, (double)(-k) / 10.0);
            PairHMMIndelErrorModel.baseMatchArray[k] = Math.log10(1.0 - baseProb);
            PairHMMIndelErrorModel.baseMismatchArray[k] = Math.log10(baseProb);
        }
    }
}

