/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.indels;

import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.List;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.HasGenomeLocation;
import org.broadinstitute.sting.utils.fasta.CachingIndexedFastaSequenceFile;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

class ReadBin
implements HasGenomeLocation {
    private final ArrayList<GATKSAMRecord> reads = new ArrayList();
    private byte[] reference = null;
    private GenomeLoc loc = null;
    private final GenomeLocParser parser;
    private final int referencePadding;

    public ReadBin(GenomeLocParser parser, int referencePadding) {
        this.parser = parser;
        this.referencePadding = referencePadding;
    }

    public void add(GATKSAMRecord read) {
        int readStart = read.getSoftStart();
        int readStop = read.getSoftEnd();
        if (this.loc == null) {
            this.loc = this.parser.createGenomeLoc(read.getReferenceName(), readStart, readStop);
        } else if (readStop > this.loc.getStop()) {
            this.loc = this.parser.createGenomeLoc(this.loc.getContig(), this.loc.getStart(), readStop);
        }
        this.reads.add(read);
    }

    public List<GATKSAMRecord> getReads() {
        return this.reads;
    }

    @Requires(value={"referenceReader.isUppercasingBases()"})
    public byte[] getReference(CachingIndexedFastaSequenceFile referenceReader) {
        if (this.reference == null) {
            int padLeft = Math.max(this.loc.getStart() - this.referencePadding, 1);
            int padRight = Math.min(this.loc.getStop() + this.referencePadding, referenceReader.getSequenceDictionary().getSequence(this.loc.getContig()).getSequenceLength());
            this.loc = this.parser.createGenomeLoc(this.loc.getContig(), this.loc.getContigIndex(), padLeft, padRight);
            this.reference = referenceReader.getSubsequenceAt(this.loc.getContig(), this.loc.getStart(), this.loc.getStop()).getBases();
        }
        return this.reference;
    }

    @Override
    public GenomeLoc getLocation() {
        return this.loc;
    }

    public int size() {
        return this.reads.size();
    }

    public void clear() {
        this.reads.clear();
        this.reference = null;
        this.loc = null;
    }
}

