/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.phasing;

import org.broadinstitute.sting.gatk.walkers.phasing.VariantContextMergeRule;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;

class DistanceMergeRule
extends VariantContextMergeRule {
    private int maxGenomicDistanceForMNP;
    private GenomeLocParser genomeLocParser;

    public DistanceMergeRule(int maxGenomicDistanceForMNP, GenomeLocParser genomeLocParser) {
        this.maxGenomicDistanceForMNP = maxGenomicDistanceForMNP;
        this.genomeLocParser = genomeLocParser;
    }

    @Override
    public boolean shouldAttemptToMerge(VariantContext vc1, VariantContext vc2) {
        return this.minDistance(vc1, vc2) <= this.maxGenomicDistanceForMNP;
    }

    public String toString() {
        return "Merge distance <= " + this.maxGenomicDistanceForMNP;
    }

    public int minDistance(VariantContext vc1, VariantContext vc2) {
        return GATKVariantContextUtils.getLocation(this.genomeLocParser, vc1).minDistance(GATKVariantContextUtils.getLocation(this.genomeLocParser, vc2));
    }
}

