/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.IOException;
import net.sf.samtools.SAMException;
import net.sf.samtools.util.RuntimeIOException;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.RefWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;

@Hidden
@DocumentedGATKFeature(groupName="Testing Tools", extraDocs={CommandLineGATK.class})
public class ErrorThrowing
extends RefWalker<Integer, Integer>
implements TreeReducible<Integer>,
NanoSchedulable {
    @Input(fullName="exception", shortName="E", doc="Java class of exception to throw", required=true)
    public String exceptionToThrow;
    @Argument(fullName="failMethod", shortName="fail", doc="Determines which method to fail in", required=false)
    public FailMethod failMethod = FailMethod.MAP;

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (ref == null) {
            return null;
        }
        if (this.failMethod == FailMethod.MAP) {
            this.fail();
        }
        return 0;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        if (value != null && this.failMethod == FailMethod.REDUCE) {
            this.fail();
        }
        return sum;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        if (this.failMethod == FailMethod.TREE_REDUCE) {
            this.fail();
        }
        return rhs;
    }

    private void fail() {
        if (this.exceptionToThrow.equals("UserException")) {
            throw new UserException("UserException");
        }
        if (this.exceptionToThrow.equals("NullPointerException")) {
            throw new NullPointerException();
        }
        if (this.exceptionToThrow.equals("ReviewedStingException")) {
            throw new ReviewedStingException("ReviewedStingException");
        }
        if (this.exceptionToThrow.equals("SamError1")) {
            throw new RuntimeException("Cannot use index file with textual SAM file");
        }
        if (this.exceptionToThrow.equals("SamError2")) {
            throw new RuntimeException("Cannot retrieve file pointers within SAM text files");
        }
        if (this.exceptionToThrow.equals("NoSpace1")) {
            throw new RuntimeIOException(new IOException("No space left on device java.io.FileOutputStream.writeBytes(Native Method)"));
        }
        if (this.exceptionToThrow.equals("NoSpace2")) {
            throw new SAMException("Exception writing BAM index file", new IOException("No space left on device java.io.FileOutputStream.writeBytes(Native Method)"));
        }
        throw new UserException.BadArgumentValue("exception", "exception isn't a recognized value " + this.exceptionToThrow);
    }

    public static enum FailMethod {
        MAP,
        REDUCE,
        TREE_REDUCE;

    }
}

