/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.qc;

import java.io.PrintStream;
import java.text.DecimalFormat;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.DataSource;
import org.broadinstitute.sting.gatk.walkers.NanoSchedulable;
import org.broadinstitute.sting.gatk.walkers.ReadWalker;
import org.broadinstitute.sting.gatk.walkers.Requires;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

@DocumentedGATKFeature(groupName="Diagnostics and Quality Control Tools", extraDocs={CommandLineGATK.class})
@Requires(value={DataSource.READS})
public class FlagStat
extends ReadWalker<FlagStatus, FlagStatus>
implements NanoSchedulable {
    @Output
    PrintStream out;

    @Override
    public FlagStatus map(ReferenceContext ref, GATKSAMRecord read, RefMetaDataTracker metaDataTracker) {
        return new FlagStatus().add(read);
    }

    @Override
    public FlagStatus reduceInit() {
        return new FlagStatus();
    }

    @Override
    public FlagStatus reduce(FlagStatus value, FlagStatus sum) {
        return sum.add(value);
    }

    @Override
    public void onTraversalDone(FlagStatus result) {
        this.out.println(result.toString());
    }

    public static final class FlagStatus {
        long readCount = 0L;
        long QC_failure = 0L;
        long duplicates = 0L;
        long mapped = 0L;
        long paired_in_sequencing = 0L;
        long read1 = 0L;
        long read2 = 0L;
        long properly_paired = 0L;
        long with_itself_and_mate_mapped = 0L;
        long singletons = 0L;
        long with_mate_mapped_to_a_different_chr = 0L;
        long with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 = 0L;

        public String toString() {
            String ret = "";
            StringBuilder builder = new StringBuilder(ret);
            DecimalFormat percentFormatter = new DecimalFormat("#0.00");
            builder.append(this.readCount);
            builder.append(" in total\n");
            builder.append(this.QC_failure);
            builder.append(" QC failure\n");
            builder.append(this.duplicates);
            builder.append(" duplicates\n");
            builder.append(this.mapped);
            builder.append(" mapped (");
            builder.append(percentFormatter.format((double)((float)this.mapped / (float)this.readCount) * 100.0));
            builder.append("%)\n");
            builder.append(this.paired_in_sequencing);
            builder.append(" paired in sequencing\n");
            builder.append(this.read1);
            builder.append(" read1\n");
            builder.append(this.read2);
            builder.append(" read2\n");
            builder.append(this.properly_paired);
            builder.append(" properly paired (");
            builder.append(percentFormatter.format((double)((float)this.properly_paired / (float)this.readCount) * 100.0));
            builder.append("%)\n");
            builder.append(this.with_itself_and_mate_mapped);
            builder.append(" with itself and mate mapped\n");
            builder.append(this.singletons);
            builder.append(" singletons (");
            builder.append(percentFormatter.format((double)((float)this.singletons / (float)this.readCount) * 100.0));
            builder.append("%)\n");
            builder.append(this.with_mate_mapped_to_a_different_chr);
            builder.append(" with mate mapped to a different chr\n");
            builder.append(this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5);
            builder.append(" with mate mapped to a different chr (mapQ>=5)");
            return builder.toString();
        }

        public FlagStatus add(FlagStatus other) {
            this.readCount += other.readCount;
            this.QC_failure += other.QC_failure;
            this.duplicates += other.duplicates;
            this.mapped += other.mapped;
            this.paired_in_sequencing += other.paired_in_sequencing;
            this.read1 += other.read1;
            this.read2 += other.read2;
            this.properly_paired += other.properly_paired;
            this.with_itself_and_mate_mapped += other.with_itself_and_mate_mapped;
            this.singletons += other.singletons;
            this.with_mate_mapped_to_a_different_chr += other.with_mate_mapped_to_a_different_chr;
            this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5 += other.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5;
            return this;
        }

        public FlagStatus add(GATKSAMRecord read) {
            ++this.readCount;
            if (read.getReadFailsVendorQualityCheckFlag()) {
                ++this.QC_failure;
            }
            if (read.getDuplicateReadFlag()) {
                ++this.duplicates;
            }
            if (!read.getReadUnmappedFlag()) {
                ++this.mapped;
            }
            if (read.getReadPairedFlag()) {
                ++this.paired_in_sequencing;
                if (read.getSecondOfPairFlag()) {
                    ++this.read2;
                } else if (read.getReadPairedFlag()) {
                    ++this.read1;
                }
                if (read.getProperPairFlag()) {
                    ++this.properly_paired;
                }
                if (!read.getReadUnmappedFlag() && !read.getMateUnmappedFlag()) {
                    ++this.with_itself_and_mate_mapped;
                    if (!read.getReferenceIndex().equals(read.getMateReferenceIndex())) {
                        ++this.with_mate_mapped_to_a_different_chr;
                        if (read.getMappingQuality() >= 5) {
                            ++this.with_mate_mapped_to_a_different_chr_maq_greaterequal_than_5;
                        }
                    }
                }
                if (!read.getReadUnmappedFlag() && read.getMateUnmappedFlag()) {
                    ++this.singletons;
                }
            }
            return this;
        }
    }
}

