/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector;

import java.util.TreeSet;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalc;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcFactory;
import org.broadinstitute.sting.gatk.walkers.genotyper.afcalc.AFCalcResult;
import org.broadinstitute.sting.gatk.walkers.validation.validationsiteselector.SampleSelector;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class GLBasedSampleSelector
extends SampleSelector {
    double[] flatPriors = null;
    final double referenceLikelihood;
    AFCalc AFCalculator;

    public GLBasedSampleSelector(TreeSet<String> sm, double refLik) {
        super(sm);
        this.referenceLikelihood = refLik;
    }

    @Override
    public boolean selectSiteInSamples(VariantContext vc) {
        AFCalcResult result;
        if (this.samples == null || this.samples.isEmpty()) {
            return true;
        }
        VariantContext subContext = vc.subContextFromSamples(this.samples);
        if (!subContext.isPolymorphicInSamples()) {
            return false;
        }
        if (this.flatPriors == null) {
            this.flatPriors = new double[1 + 2 * this.samples.size()];
            this.AFCalculator = AFCalcFactory.createAFCalc(this.samples.size(), 4, 2);
        }
        return (result = this.AFCalculator.getLog10PNonRef(subContext, this.flatPriors)).getLog10LikelihoodOfAFEq0() < this.referenceLikelihood;
    }
}

