/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.evaluators;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.StandardEval;
import org.broadinstitute.sting.gatk.walkers.varianteval.evaluators.VariantEvaluator;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.Analysis;
import org.broadinstitute.sting.gatk.walkers.varianteval.util.DataPoint;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;

@Analysis(description="Evaluation summary for indels")
public class IndelSummary
extends VariantEvaluator
implements StandardEval {
    protected static final Logger logger = Logger.getLogger(IndelSummary.class);
    @DataPoint(description="Number of SNPs", format="%d")
    public int n_SNPs = 0;
    @DataPoint(description="Number of singleton SNPs", format="%d")
    public int n_singleton_SNPs = 0;
    @DataPoint(description="Number of indels", format="%d")
    public int n_indels = 0;
    @DataPoint(description="Number of singleton indels", format="%d")
    public int n_singleton_indels = 0;
    @DataPoint(description="Number of Indels overlapping gold standard sites", format="%d")
    public int n_indels_matching_gold_standard = 0;
    @DataPoint(description="Percent of indels overlapping gold standard sites")
    public String gold_standard_matching_rate;
    public int nIndelSites = 0;
    @DataPoint(description="Number of sites with where the number of alleles is greater than 2")
    public int n_multiallelic_indel_sites = 0;
    @DataPoint(description="Percent of indel sites that are multi-allelic")
    public String percent_of_sites_with_more_than_2_alleles;
    @DataPoint(description="SNP to indel ratio")
    public String SNP_to_indel_ratio;
    @DataPoint(description="Singleton SNP to indel ratio")
    public String SNP_to_indel_ratio_for_singletons;
    @DataPoint(description="Number of novel indels", format="%d")
    public int n_novel_indels = 0;
    @DataPoint(description="Indel novelty rate")
    public String indel_novelty_rate;
    @DataPoint(description="Number of insertion indels")
    public int n_insertions = 0;
    @DataPoint(description="Number of deletion indels")
    public int n_deletions = 0;
    @DataPoint(description="Insertion to deletion ratio")
    public String insertion_to_deletion_ratio;
    @DataPoint(description="Number of large (>10 bp) deletions")
    public int n_large_deletions = 0;
    @DataPoint(description="Number of large (>10 bp) insertions")
    public int n_large_insertions = 0;
    @DataPoint(description="Ratio of large (>10 bp) insertions to deletions")
    public String insertion_to_deletion_ratio_for_large_indels;
    @DataPoint(description="Number of indels in protein-coding regions labeled as frameshift")
    public int n_coding_indels_frameshifting = 0;
    @DataPoint(description="Number of indels in protein-coding regions not labeled as frameshift")
    public int n_coding_indels_in_frame = 0;
    @DataPoint(description="Frameshift percent")
    public String frameshift_rate_for_coding_indels;
    @DataPoint(description="Het to hom ratio for SNPs")
    public String SNP_het_to_hom_ratio;
    @DataPoint(description="Het to hom ratio for indels")
    public String indel_het_to_hom_ratio;
    int nSNPHets = 0;
    int nSNPHoms = 0;
    int nIndelHets = 0;
    int nIndelHoms = 0;
    int[] insertionCountByLength = new int[]{0, 0, 0, 0};
    int[] deletionCountByLength = new int[]{0, 0, 0, 0};
    @DataPoint(description="ratio of 1 and 2 bp insertions to 3 bp insertions")
    public String ratio_of_1_and_2_to_3_bp_insertions;
    @DataPoint(description="ratio of 1 and 2 bp deletions to 3 bp deletions")
    public String ratio_of_1_and_2_to_3_bp_deletions;
    public static final int LARGE_INDEL_SIZE_THRESHOLD = 10;

    @Override
    public int getComparisonOrder() {
        return 2;
    }

    @Override
    public void update2(VariantContext eval, VariantContext comp, RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (eval == null || this.getWalker().ignoreAC0Sites() && eval.isMonomorphicInSamples()) {
            return;
        }
        switch (eval.getType()) {
            case SNP: {
                this.n_SNPs += eval.getNAlleles() - 1;
                if (IndelSummary.variantWasSingleton(eval)) {
                    ++this.n_singleton_SNPs;
                }
                for (Genotype g : eval.getGenotypes()) {
                    if (g.isHet()) {
                        ++this.nSNPHets;
                    }
                    if (!g.isHomVar()) continue;
                    ++this.nSNPHoms;
                }
                break;
            }
            case INDEL: {
                VariantContext gold = this.getWalker().goldStandard == null ? null : tracker.getFirstValue(this.getWalker().goldStandard);
                ++this.nIndelSites;
                if (!eval.isBiallelic()) {
                    ++this.n_multiallelic_indel_sites;
                }
                for (Genotype g : eval.getGenotypes()) {
                    if (g.isHet()) {
                        ++this.nIndelHets;
                    }
                    if (!g.isHomVar()) continue;
                    ++this.nIndelHoms;
                }
                for (Allele alt : eval.getAlternateAlleles()) {
                    int[] countByLength;
                    int alleleSize;
                    ++this.n_indels;
                    if (IndelSummary.variantWasSingleton(eval)) {
                        ++this.n_singleton_indels;
                    }
                    if (comp == null) {
                        ++this.n_novel_indels;
                    }
                    if (gold != null) {
                        ++this.n_indels_matching_gold_standard;
                    }
                    if ((alleleSize = alt.length() - eval.getReference().length()) == 0) {
                        throw new ReviewedStingException("Allele size not expected to be zero for indel: alt = " + alt + " ref = " + eval.getReference());
                    }
                    if (alleleSize > 0) {
                        ++this.n_insertions;
                    }
                    if (alleleSize < 0) {
                        ++this.n_deletions;
                    }
                    if (eval.getAttributeAsString("SNPEFF_GENE_BIOTYPE", "missing").equals("protein_coding")) {
                        String effect = eval.getAttributeAsString("SNPEFF_EFFECT", "missing");
                        if (effect.equals("missing")) {
                            throw new ReviewedStingException("Saw SNPEFF_GENE_BIOTYPE but unexpected no SNPEFF_EFFECT at " + eval);
                        }
                        if (effect.equals("FRAME_SHIFT")) {
                            ++this.n_coding_indels_frameshifting;
                        } else if (effect.startsWith("CODON")) {
                            ++this.n_coding_indels_in_frame;
                        }
                    }
                    if (alleleSize > 10) {
                        ++this.n_large_insertions;
                    } else if (alleleSize < -10) {
                        ++this.n_large_deletions;
                    }
                    int[] nArray = countByLength = alleleSize < 0 ? this.deletionCountByLength : this.insertionCountByLength;
                    int absSize = Math.abs(alleleSize);
                    if (absSize >= countByLength.length) continue;
                    int n = absSize;
                    countByLength[n] = countByLength[n] + 1;
                }
                break;
            }
        }
    }

    @Override
    public void finalizeEvaluation() {
        this.percent_of_sites_with_more_than_2_alleles = Utils.formattedPercent(this.n_multiallelic_indel_sites, this.nIndelSites);
        this.SNP_to_indel_ratio = Utils.formattedRatio(this.n_SNPs, this.n_indels);
        this.SNP_to_indel_ratio_for_singletons = Utils.formattedRatio(this.n_singleton_SNPs, this.n_singleton_indels);
        this.gold_standard_matching_rate = Utils.formattedPercent(this.n_indels_matching_gold_standard, this.n_indels);
        this.indel_novelty_rate = Utils.formattedNoveltyRate(this.n_indels - this.n_novel_indels, this.n_indels);
        this.frameshift_rate_for_coding_indels = Utils.formattedPercent(this.n_coding_indels_frameshifting, this.n_coding_indels_in_frame + this.n_coding_indels_frameshifting);
        this.ratio_of_1_and_2_to_3_bp_deletions = Utils.formattedRatio(this.deletionCountByLength[1] + this.deletionCountByLength[2], this.deletionCountByLength[3]);
        this.ratio_of_1_and_2_to_3_bp_insertions = Utils.formattedRatio(this.insertionCountByLength[1] + this.insertionCountByLength[2], this.insertionCountByLength[3]);
        this.SNP_het_to_hom_ratio = Utils.formattedRatio(this.nSNPHets, this.nSNPHoms);
        this.indel_het_to_hom_ratio = Utils.formattedRatio(this.nIndelHets, this.nIndelHoms);
        this.insertion_to_deletion_ratio = Utils.formattedRatio(this.n_insertions, this.n_deletions);
        this.insertion_to_deletion_ratio_for_large_indels = Utils.formattedRatio(this.n_large_insertions, this.n_large_deletions);
    }
}

