/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.varianteval.stratifications;

import java.util.Arrays;
import java.util.List;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.varianteval.stratifications.VariantStratifier;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class TandemRepeat
extends VariantStratifier {
    private static final List<Object> JUST_ALL = Arrays.asList("all");
    private static final List<Object> ALL = Arrays.asList("all", "is.repeat", "not.repeat");
    private static final List<Object> REPEAT = Arrays.asList("all", "is.repeat");
    private static final List<Object> NOT_REPEAT = Arrays.asList("all", "not.repeat");

    @Override
    public void initialize() {
        this.states.addAll(ALL);
    }

    @Override
    public List<Object> getRelevantStates(ReferenceContext ref, RefMetaDataTracker tracker, VariantContext comp, String compName, VariantContext eval, String evalName, String sampleName) {
        if (eval == null || !eval.isIndel()) {
            return ALL;
        }
        if (GATKVariantContextUtils.isTandemRepeat(eval, ref.getForwardBases())) {
            this.print("REPEAT", eval, ref);
            return REPEAT;
        }
        this.print("NOT A REPEAT", eval, ref);
        return NOT_REPEAT;
    }

    private final void print(String prefix, VariantContext eval, ReferenceContext ref) {
    }
}

