/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantrecalibration;

import org.apache.log4j.Logger;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.commandline.Tags;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class TrainingSet {
    public RodBinding<VariantContext> rodBinding;
    public boolean isKnown = false;
    public boolean isTraining = false;
    public boolean isAntiTraining = false;
    public boolean isTruth = false;
    public boolean isConsensus = false;
    public double prior = 0.0;
    protected static final Logger logger = Logger.getLogger(TrainingSet.class);

    public TrainingSet(RodBinding<VariantContext> rodBinding) {
        this.rodBinding = rodBinding;
        Tags tags = rodBinding.getTags();
        String name = rodBinding.getName();
        if (tags != null) {
            this.isKnown = tags.containsKey("known") && tags.getValue("known").equals("true");
            this.isTraining = tags.containsKey("training") && tags.getValue("training").equals("true");
            this.isAntiTraining = tags.containsKey("bad") && tags.getValue("bad").equals("true");
            this.isTruth = tags.containsKey("truth") && tags.getValue("truth").equals("true");
            this.isConsensus = tags.containsKey("consensus") && tags.getValue("consensus").equals("true");
            double d = this.prior = tags.containsKey("prior") ? Double.parseDouble(tags.getValue("prior")) : this.prior;
        }
        if (!this.isConsensus && !this.isAntiTraining) {
            logger.info(String.format("Found %s track: \tKnown = %s \tTraining = %s \tTruth = %s \tPrior = Q%.1f", name, this.isKnown, this.isTraining, this.isTruth, this.prior));
        } else if (this.isConsensus) {
            logger.info(String.format("Found consensus track: %s", name));
        } else {
            logger.info(String.format("Found bad sites training track: %s", name));
        }
    }
}

