/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.io.stubs.VariantContextWriterStub;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.gatk.walkers.annotator.ChromosomeCountConstants;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.variantcontext.writer.Options;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeaderLineType;
import org.broadinstitute.variant.vcf.VCFInfoHeaderLine;
import org.broadinstitute.variant.vcf.VCFUtils;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=-50, stop=50))
public class CombineVariants
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @Input(fullName="variant", shortName="V", doc="Input VCF file", required=true)
    public List<RodBinding<VariantContext>> variants;
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter vcfWriter = null;
    @Argument(shortName="genotypeMergeOptions", doc="Determines how we should merge genotype records for samples shared across the ROD files", required=false)
    public GATKVariantContextUtils.GenotypeMergeType genotypeMergeOption = null;
    @Argument(shortName="filteredRecordsMergeType", doc="Determines how we should handle records seen at the same site in the VCF, but with different FILTER fields", required=false)
    public GATKVariantContextUtils.FilteredRecordMergeType filteredRecordsMergeType = GATKVariantContextUtils.FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED;
    @Hidden
    @Argument(shortName="multipleAllelesMergeType", doc="Determines how we should handle records seen at the same site in the VCF, but with different allele types (for example, SNP vs. indel)", required=false)
    public GATKVariantContextUtils.MultipleAllelesMergeType multipleAllelesMergeType = GATKVariantContextUtils.MultipleAllelesMergeType.BY_TYPE;
    @Argument(fullName="rod_priority_list", shortName="priority", doc="A comma-separated string describing the priority ordering for the genotypes as far as which record gets emitted", required=false)
    public String PRIORITY_STRING = null;
    @Argument(fullName="printComplexMerges", shortName="printComplexMerges", doc="Print out interesting sites requiring complex compatibility merging", required=false)
    public boolean printComplexMerges = false;
    @Argument(fullName="filteredAreUncalled", shortName="filteredAreUncalled", doc="If true, then filtered VCFs are treated as uncalled, so that filtered set annotations don't appear in the combined VCF", required=false)
    public boolean filteredAreUncalled = false;
    @Argument(fullName="minimalVCF", shortName="minimalVCF", doc="If true, then the output VCF will contain no INFO or genotype FORMAT fields", required=false)
    public boolean minimalVCF = false;
    @Argument(fullName="setKey", shortName="setKey", doc="Key used in the INFO key=value tag emitted describing which set the combined VCF record came from", required=false)
    public String SET_KEY = "set";
    @Argument(fullName="assumeIdenticalSamples", shortName="assumeIdenticalSamples", doc="If true, assume input VCFs have identical sample sets and disjoint calls", required=false)
    public boolean ASSUME_IDENTICAL_SAMPLES = false;
    @Argument(fullName="minimumN", shortName="minN", doc="Combine variants and output site only if the variant is present in at least N input files.", required=false)
    public int minimumN = 1;
    @Argument(fullName="suppressCommandLineHeader", shortName="suppressCommandLineHeader", doc="If true, do not output the header containing the command line used", required=false)
    public boolean SUPPRESS_COMMAND_LINE_HEADER = false;
    @Argument(fullName="mergeInfoWithMaxAC", shortName="mergeInfoWithMaxAC", doc="If true, when VCF records overlap the info field is taken from the one with the max AC instead of only taking the fields which are identical across the overlapping records.", required=false)
    public boolean MERGE_INFO_WITH_MAX_AC = false;
    private List<String> priority = null;
    private boolean sitesOnlyVCF = false;
    private Set<String> samples;

    @Override
    public void initialize() {
        Map<String, VCFHeader> vcfRods = GATKVCFUtils.getVCFHeadersFromRods(this.getToolkit());
        if (this.vcfWriter instanceof VariantContextWriterStub) {
            this.sitesOnlyVCF = ((VariantContextWriterStub)this.vcfWriter).getWriterOptions().contains((Object)Options.DO_NOT_WRITE_GENOTYPES);
            if (this.sitesOnlyVCF) {
                logger.info("Pre-stripping genotypes for performance");
            }
        } else {
            logger.warn("VCF output file not an instance of VCFWriterStub; cannot enable sites only output option");
        }
        this.validateAnnotateUnionArguments();
        if (this.PRIORITY_STRING == null && this.genotypeMergeOption == null) {
            this.genotypeMergeOption = GATKVariantContextUtils.GenotypeMergeType.UNSORTED;
            logger.info("Priority string is not provided, using arbitrary genotyping order: " + this.priority);
        }
        if (this.genotypeMergeOption == GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE && !SampleUtils.verifyUniqueSamplesNames(vcfRods)) {
            throw new IllegalStateException("REQUIRE_UNIQUE sample names is true but duplicate names were discovered.");
        }
        Set<Object> set = this.samples = this.sitesOnlyVCF ? Collections.emptySet() : SampleUtils.getSampleList(vcfRods, this.genotypeMergeOption);
        if (this.SET_KEY.toLowerCase().equals("null")) {
            this.SET_KEY = null;
        }
        Set<VCFHeaderLine> headerLines = VCFUtils.smartMergeHeaders(vcfRods.values(), true);
        if (this.SET_KEY != null) {
            headerLines.add(new VCFInfoHeaderLine(this.SET_KEY, 1, VCFHeaderLineType.String, "Source VCF for the merged record in CombineVariants"));
        }
        if (!this.ASSUME_IDENTICAL_SAMPLES) {
            headerLines.addAll(Arrays.asList(ChromosomeCountConstants.descriptions));
        }
        VCFHeader vcfHeader = new VCFHeader(headerLines, this.samples);
        vcfHeader.setWriteCommandLine(!this.SUPPRESS_COMMAND_LINE_HEADER);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    private void validateAnnotateUnionArguments() {
        Set<String> rodNames = SampleUtils.getRodNamesWithVCFHeader(this.getToolkit(), null);
        if (this.genotypeMergeOption == GATKVariantContextUtils.GenotypeMergeType.PRIORITIZE && this.PRIORITY_STRING == null) {
            throw new UserException.MissingArgument("rod_priority_list", "Priority string must be provided if you want to prioritize genotypes");
        }
        if (this.PRIORITY_STRING != null) {
            this.priority = new ArrayList<String>(Arrays.asList(this.PRIORITY_STRING.split(",")));
            if (rodNames.size() != this.priority.size()) {
                throw new UserException.BadArgumentValue("rod_priority_list", "The priority list must contain exactly one rod binding per ROD provided to the GATK: rodNames=" + rodNames + " priority=" + this.priority);
            }
            if (!rodNames.containsAll(this.priority)) {
                throw new UserException.BadArgumentValue("rod_priority_list", "Not all priority elements provided as input RODs: " + this.PRIORITY_STRING);
            }
        }
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        Set<String> rodNames = SampleUtils.getRodNamesWithVCFHeader(this.getToolkit(), null);
        Collection<VariantContext> vcs = tracker.getValues(this.variants, context.getLocation());
        if (this.sitesOnlyVCF) {
            vcs = VariantContextUtils.sitesOnlyVariantContexts(vcs);
        }
        if (this.ASSUME_IDENTICAL_SAMPLES) {
            for (VariantContext vc : vcs) {
                this.vcfWriter.add(vc);
            }
            return vcs.isEmpty() ? 0 : 1;
        }
        int numFilteredRecords = 0;
        for (VariantContext vc : vcs) {
            if (!vc.filtersWereApplied() || !vc.isFiltered()) continue;
            ++numFilteredRecords;
        }
        if (this.minimumN > 1 && vcs.size() - numFilteredRecords < this.minimumN) {
            return 0;
        }
        ArrayList<VariantContext> mergedVCs = new ArrayList<VariantContext>();
        if (this.multipleAllelesMergeType == GATKVariantContextUtils.MultipleAllelesMergeType.BY_TYPE) {
            Map<VariantContext.Type, List<VariantContext>> VCsByType = GATKVariantContextUtils.separateVariantContextsByType(vcs);
            if (VCsByType.containsKey((Object)VariantContext.Type.NO_VARIATION) && VCsByType.size() > 1) {
                List<VariantContext> refs = VCsByType.remove((Object)VariantContext.Type.NO_VARIATION);
                for (VariantContext.Type type : VariantContext.Type.values()) {
                    if (!VCsByType.containsKey((Object)type)) continue;
                    VCsByType.get((Object)type).addAll(refs);
                    break;
                }
            }
            for (VariantContext.Type type : VariantContext.Type.values()) {
                if (!VCsByType.containsKey((Object)type)) continue;
                mergedVCs.add(GATKVariantContextUtils.simpleMerge((Collection<VariantContext>)VCsByType.get((Object)type), this.priority, rodNames.size(), this.filteredRecordsMergeType, this.genotypeMergeOption, true, this.printComplexMerges, this.SET_KEY, this.filteredAreUncalled, this.MERGE_INFO_WITH_MAX_AC));
            }
        } else if (this.multipleAllelesMergeType == GATKVariantContextUtils.MultipleAllelesMergeType.MIX_TYPES) {
            mergedVCs.add(GATKVariantContextUtils.simpleMerge(vcs, this.priority, rodNames.size(), this.filteredRecordsMergeType, this.genotypeMergeOption, true, this.printComplexMerges, this.SET_KEY, this.filteredAreUncalled, this.MERGE_INFO_WITH_MAX_AC));
        } else {
            logger.warn("Ignoring all records at site " + ref.getLocus());
        }
        for (VariantContext mergedVC : mergedVCs) {
            if (mergedVC == null) continue;
            VariantContextBuilder builder = new VariantContextBuilder(mergedVC);
            VariantContextUtils.calculateChromosomeCounts(builder, false);
            if (this.minimalVCF) {
                GATKVariantContextUtils.pruneVariantContext(builder, Arrays.asList(this.SET_KEY));
            }
            this.vcfWriter.add(builder.make());
        }
        return vcs.isEmpty() ? 0 : 1;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer counter, Integer sum) {
        return counter + sum;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return this.reduce(lhs, rhs);
    }

    @Override
    public void onTraversalDone(Integer sum) {
    }
}

