/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import com.google.java.contract.Requires;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.vcf.VCFHeader;

public class ConcordanceMetrics {
    private Map<String, GenotypeConcordanceTable> perSampleGenotypeConcordance;
    private GenotypeConcordanceTable overallGenotypeConcordance;
    private SiteConcordanceTable overallSiteConcordance;

    public ConcordanceMetrics(VCFHeader evaluate, VCFHeader truth) {
        HashSet<String> overlappingSamples = new HashSet<String>(evaluate.getGenotypeSamples());
        overlappingSamples.retainAll(truth.getGenotypeSamples());
        this.perSampleGenotypeConcordance = new HashMap<String, GenotypeConcordanceTable>(overlappingSamples.size());
        for (String sample : overlappingSamples) {
            this.perSampleGenotypeConcordance.put(sample, new GenotypeConcordanceTable());
        }
        this.overallGenotypeConcordance = new GenotypeConcordanceTable();
        this.overallSiteConcordance = new SiteConcordanceTable();
    }

    public GenotypeConcordanceTable getOverallGenotypeConcordance() {
        return this.overallGenotypeConcordance;
    }

    public SiteConcordanceTable getOverallSiteConcordance() {
        return this.overallSiteConcordance;
    }

    public GenotypeConcordanceTable getGenotypeConcordance(String sample) {
        GenotypeConcordanceTable table = this.perSampleGenotypeConcordance.get(sample);
        if (table == null) {
            throw new ReviewedStingException("Attempted to request the concordance table for sample " + sample + " on which it was not calculated");
        }
        return table;
    }

    public Map<String, GenotypeConcordanceTable> getPerSampleGenotypeConcordance() {
        return Collections.unmodifiableMap(this.perSampleGenotypeConcordance);
    }

    public Map<String, Double> getPerSampleNRD() {
        HashMap<String, Double> nrd = new HashMap<String, Double>(this.perSampleGenotypeConcordance.size());
        for (Map.Entry<String, GenotypeConcordanceTable> sampleTable : this.perSampleGenotypeConcordance.entrySet()) {
            nrd.put(sampleTable.getKey(), ConcordanceMetrics.calculateNRD(sampleTable.getValue()));
        }
        return Collections.unmodifiableMap(nrd);
    }

    public Double getOverallNRD() {
        return ConcordanceMetrics.calculateNRD(this.overallGenotypeConcordance);
    }

    public Map<String, Double> getPerSampleNRS() {
        HashMap<String, Double> nrs = new HashMap<String, Double>(this.perSampleGenotypeConcordance.size());
        for (Map.Entry<String, GenotypeConcordanceTable> sampleTable : this.perSampleGenotypeConcordance.entrySet()) {
            nrs.put(sampleTable.getKey(), ConcordanceMetrics.calculateNRS(sampleTable.getValue()));
        }
        return Collections.unmodifiableMap(nrs);
    }

    public Double getOverallNRS() {
        return ConcordanceMetrics.calculateNRS(this.overallGenotypeConcordance);
    }

    @Requires(value={"eval != null", "truth != null"})
    public void update(VariantContext eval, VariantContext truth) {
        this.overallSiteConcordance.update(eval, truth);
        HashSet<String> alleleTruth = new HashSet<String>(8);
        alleleTruth.add(truth.getReference().getBaseString());
        for (Allele a : truth.getAlternateAlleles()) {
            alleleTruth.add(a.getBaseString());
        }
        for (String sample : this.perSampleGenotypeConcordance.keySet()) {
            Genotype evalGenotype = eval.getGenotype(sample);
            Genotype truthGenotype = truth.getGenotype(sample);
            this.perSampleGenotypeConcordance.get(sample).update(evalGenotype, truthGenotype, alleleTruth);
            this.overallGenotypeConcordance.update(evalGenotype, truthGenotype, alleleTruth);
        }
    }

    private static double calculateNRD(GenotypeConcordanceTable table) {
        return ConcordanceMetrics.calculateNRD(table.getTable());
    }

    private static double calculateNRD(int[][] concordanceCounts) {
        int correct = 0;
        int total = 0;
        correct += concordanceCounts[GenotypeType.HET.ordinal()][GenotypeType.HET.ordinal()];
        total += (correct += concordanceCounts[GenotypeType.HOM_VAR.ordinal()][GenotypeType.HOM_VAR.ordinal()]);
        total += concordanceCounts[GenotypeType.HOM_REF.ordinal()][GenotypeType.HET.ordinal()];
        total += concordanceCounts[GenotypeType.HOM_REF.ordinal()][GenotypeType.HOM_VAR.ordinal()];
        total += concordanceCounts[GenotypeType.HET.ordinal()][GenotypeType.HOM_REF.ordinal()];
        total += concordanceCounts[GenotypeType.HET.ordinal()][GenotypeType.HOM_VAR.ordinal()];
        total += concordanceCounts[GenotypeType.HOM_VAR.ordinal()][GenotypeType.HOM_REF.ordinal()];
        return (total += concordanceCounts[GenotypeType.HOM_VAR.ordinal()][GenotypeType.HET.ordinal()]) == 0 ? 1.0 : 1.0 - (double)correct / (double)total;
    }

    private static double calculateNRS(GenotypeConcordanceTable table) {
        return ConcordanceMetrics.calculateNRS(table.getTable());
    }

    private static double calculateNRS(int[][] concordanceCounts) {
        long confirmedVariant = 0L;
        long unconfirmedVariant = 0L;
        for (GenotypeType truthState : Arrays.asList(GenotypeType.HET, GenotypeType.HOM_VAR)) {
            for (GenotypeType evalState : GenotypeType.values()) {
                if (evalState == GenotypeType.MIXED) continue;
                if (evalState.equals((Object)GenotypeType.HET) || evalState.equals((Object)GenotypeType.HOM_VAR)) {
                    confirmedVariant += (long)concordanceCounts[evalState.ordinal()][truthState.ordinal()];
                    continue;
                }
                unconfirmedVariant += (long)concordanceCounts[evalState.ordinal()][truthState.ordinal()];
            }
        }
        long total = confirmedVariant + unconfirmedVariant;
        return total == 0L ? 0.0 : (double)confirmedVariant / (double)total;
    }

    static enum SiteConcordanceType {
        ALLELES_MATCH,
        EVAL_SUPERSET_TRUTH,
        EVAL_SUBSET_TRUTH,
        ALLELES_DO_NOT_MATCH,
        EVAL_ONLY,
        TRUTH_ONLY;


        public static SiteConcordanceType getConcordanceType(VariantContext eval, VariantContext truth) {
            if (eval.isMonomorphicInSamples()) {
                return TRUTH_ONLY;
            }
            if (truth.isMonomorphicInSamples()) {
                return EVAL_ONLY;
            }
            boolean evalSubsetTruth = GATKVariantContextUtils.allelesAreSubset(eval, truth);
            boolean truthSubsetEval = GATKVariantContextUtils.allelesAreSubset(truth, eval);
            if (evalSubsetTruth && truthSubsetEval) {
                return ALLELES_MATCH;
            }
            if (evalSubsetTruth) {
                return EVAL_SUBSET_TRUTH;
            }
            if (truthSubsetEval) {
                return EVAL_SUPERSET_TRUTH;
            }
            return ALLELES_DO_NOT_MATCH;
        }
    }

    class SiteConcordanceTable {
        private int[] siteConcordance = new int[SiteConcordanceType.values().length];

        public void update(VariantContext evalVC, VariantContext truthVC) {
            SiteConcordanceType matchType = this.getMatchType(evalVC, truthVC);
            int n = matchType.ordinal();
            this.siteConcordance[n] = this.siteConcordance[n] + 1;
        }

        @Requires(value={"evalVC != null", "truthVC != null"})
        private SiteConcordanceType getMatchType(VariantContext evalVC, VariantContext truthVC) {
            return SiteConcordanceType.getConcordanceType(evalVC, truthVC);
        }

        public int[] getSiteConcordance() {
            return this.siteConcordance;
        }

        public int get(SiteConcordanceType type) {
            return this.getSiteConcordance()[type.ordinal()];
        }
    }

    class GenotypeConcordanceTable {
        private int[][] genotypeCounts = new int[GenotypeType.values().length][GenotypeType.values().length];
        private int nMismatchingAlt = 0;

        @Requires(value={"eval!=null", "truth != null", "truthAlleles != null"})
        public void update(Genotype eval, Genotype truth, Set<String> truthAlleles) {
            boolean matchingAlt = true;
            if (eval.isCalled() && truth.isCalled()) {
                for (Allele evalAllele : eval.getAlleles()) {
                    matchingAlt &= truthAlleles.contains(evalAllele.getBaseString());
                }
            }
            if (matchingAlt) {
                int[] nArray = this.genotypeCounts[eval.getType().ordinal()];
                int n = truth.getType().ordinal();
                nArray[n] = nArray[n] + 1;
            } else {
                ++this.nMismatchingAlt;
            }
        }

        public int[][] getTable() {
            return this.genotypeCounts;
        }

        public int getnMismatchingAlt() {
            return this.nMismatchingAlt;
        }

        public int getnEvalGenotypes(GenotypeType type) {
            int nGeno = 0;
            for (GenotypeType comptype : GenotypeType.values()) {
                nGeno += this.genotypeCounts[type.ordinal()][comptype.ordinal()];
            }
            return nGeno;
        }

        public int getnCalledEvalGenotypes() {
            int nGeno = 0;
            for (GenotypeType evalType : Arrays.asList(GenotypeType.HOM_REF, GenotypeType.HOM_VAR, GenotypeType.HET)) {
                nGeno += this.getnEvalGenotypes(evalType);
            }
            return nGeno + this.nMismatchingAlt;
        }

        public int getnCompGenotypes(GenotypeType type) {
            int nGeno = 0;
            for (GenotypeType evaltype : GenotypeType.values()) {
                nGeno += this.genotypeCounts[evaltype.ordinal()][type.ordinal()];
            }
            return nGeno;
        }

        public int getnCalledCompGenotypes() {
            int nGeno = 0;
            for (GenotypeType compType : Arrays.asList(GenotypeType.HOM_REF, GenotypeType.HOM_VAR, GenotypeType.HET)) {
                nGeno += this.getnCompGenotypes(compType);
            }
            return nGeno;
        }

        public int get(GenotypeType evalType, GenotypeType compType) {
            return this.genotypeCounts[evalType.ordinal()][compType.ordinal()];
        }
    }
}

