/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.variantutils.ConcordanceMetrics;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeType;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.vcf.VCFHeader;

public class GenotypeConcordance
extends RodWalker<List<Pair<VariantContext, VariantContext>>, ConcordanceMetrics> {
    @Input(fullName="eval", shortName="eval", doc="The variants and genotypes to evaluate", required=true)
    RodBinding<VariantContext> evalBinding;
    @Input(fullName="comp", shortName="comp", doc="The variants and genotypes to compare against", required=true)
    RodBinding<VariantContext> compBinding;
    @Argument(fullName="ignoreFilters", doc="Filters will be ignored", required=false)
    boolean ignoreFilters = false;
    @Argument(shortName="gfe", fullName="genotypeFilterExpressionEval", doc="One or more criteria to use to set EVAL genotypes to no-call. These genotype-level filters are only applied to the EVAL rod.", required=false)
    public ArrayList<String> genotypeFilterExpressionsEval = new ArrayList();
    @Argument(shortName="gfc", fullName="genotypeFilterExpressionComp", doc="One or more criteria to use to set COMP genotypes to no-call. These genotype-level filters are only applied to the COMP rod.", required=false)
    public ArrayList<String> genotypeFilterExpressionsComp = new ArrayList();
    @Argument(shortName="moltenize", fullName="moltenize", doc="Molten rather than tabular output")
    public boolean moltenize = false;
    @Output
    PrintStream out;
    private List<String> evalSamples;
    private List<String> compSamples;
    private List<VariantContextUtils.JexlVCMatchExp> evalJexls = null;
    private List<VariantContextUtils.JexlVCMatchExp> compJexls = null;

    @Override
    public void initialize() {
        this.evalJexls = this.initializeJexl(this.genotypeFilterExpressionsEval);
        this.compJexls = this.initializeJexl(this.genotypeFilterExpressionsComp);
    }

    private List<VariantContextUtils.JexlVCMatchExp> initializeJexl(ArrayList<String> genotypeFilterExpressions) {
        ArrayList<String> dummyNames = new ArrayList<String>(genotypeFilterExpressions.size());
        int expCount = 1;
        for (String exp : genotypeFilterExpressions) {
            dummyNames.add(String.format("gfe%d", expCount++));
        }
        return VariantContextUtils.initializeMatchExps(dummyNames, genotypeFilterExpressions);
    }

    @Override
    public ConcordanceMetrics reduceInit() {
        Map<String, VCFHeader> headerMap = GATKVCFUtils.getVCFHeadersFromRods(this.getToolkit(), Arrays.asList(this.evalBinding, this.compBinding));
        VCFHeader evalHeader = headerMap.get(this.evalBinding.getName());
        this.evalSamples = evalHeader.getGenotypeSamples();
        VCFHeader compHeader = headerMap.get(this.compBinding.getName());
        this.compSamples = compHeader.getGenotypeSamples();
        return new ConcordanceMetrics(evalHeader, compHeader);
    }

    @Override
    public List<Pair<VariantContext, VariantContext>> map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        List<Pair<VariantContext, VariantContext>> evalCompPair = new ArrayList<Pair<VariantContext, VariantContext>>(3);
        if (tracker != null && (tracker.getValues(this.evalBinding, ref.getLocus()).size() > 0 || tracker.getValues(this.compBinding, ref.getLocus()).size() > 0)) {
            List<VariantContext> eval = tracker.getValues(this.evalBinding, ref.getLocus());
            List<VariantContext> comp = tracker.getValues(this.compBinding, ref.getLocus());
            if (eval.size() > 1 || comp.size() > 1) {
                if (this.noDuplicateTypes(eval) && this.noDuplicateTypes(comp)) {
                    logger.info("Eval or Comp Rod at position " + ref.getLocus().toString() + " has multiple records. Resolving.");
                    evalCompPair = this.resolveMultipleRecords(eval, comp);
                } else {
                    logger.warn("Eval or Comp Rod at position " + ref.getLocus().toString() + " has multiple records of the same type. This locus will be skipped.");
                }
            } else {
                VariantContext evalContext = eval.size() == 1 ? eval.get(0) : this.createEmptyContext(comp.get(0), this.evalSamples);
                VariantContext compContext = comp.size() == 1 ? comp.get(0) : this.createEmptyContext(eval.get(0), this.compSamples);
                evalContext = this.filterGenotypes(evalContext, this.ignoreFilters, this.evalJexls);
                compContext = this.filterGenotypes(compContext, this.ignoreFilters, this.compJexls);
                evalCompPair.add(new Pair<VariantContext, VariantContext>(evalContext, compContext));
            }
        }
        return evalCompPair;
    }

    private boolean noDuplicateTypes(List<VariantContext> vcList) {
        HashSet<VariantContext.Type> types = new HashSet<VariantContext.Type>(vcList.size());
        for (VariantContext vc : vcList) {
            VariantContext.Type type = vc.getType();
            if (types.contains((Object)type)) {
                return false;
            }
            types.add(type);
        }
        return true;
    }

    private List<Pair<VariantContext, VariantContext>> resolveMultipleRecords(List<VariantContext> evalList, List<VariantContext> compList) {
        ArrayList<Pair<VariantContext, VariantContext>> resolvedPairs = new ArrayList<Pair<VariantContext, VariantContext>>(evalList.size() + compList.size());
        ArrayList<VariantContext> pairedEval = new ArrayList<VariantContext>(evalList.size());
        for (VariantContext eval : evalList) {
            VariantContext.Type evalType = eval.getType();
            HashSet<Allele> evalAlleles = new HashSet<Allele>(eval.getAlternateAlleles());
            VariantContext pairedComp = null;
            block1: for (VariantContext comp : compList) {
                if (evalType.equals((Object)comp.getType())) {
                    pairedComp = comp;
                    break;
                }
                if (!eval.isMixed() && !comp.isMixed()) continue;
                for (Allele compAllele : comp.getAlternateAlleles()) {
                    if (!evalAlleles.contains(compAllele)) continue;
                    pairedComp = comp;
                    continue block1;
                }
            }
            if (pairedComp == null) continue;
            compList.remove(pairedComp);
            resolvedPairs.add(new Pair<VariantContext, VariantContext>(this.filterGenotypes(eval, this.ignoreFilters, this.evalJexls), this.filterGenotypes(pairedComp, this.ignoreFilters, this.compJexls)));
            pairedEval.add(eval);
            if (compList.size() >= 1) continue;
            break;
        }
        evalList.removeAll(pairedEval);
        for (VariantContext unpairedEval : evalList) {
            resolvedPairs.add(new Pair<VariantContext, VariantContext>(this.filterGenotypes(unpairedEval, this.ignoreFilters, this.evalJexls), this.createEmptyContext(unpairedEval, this.compSamples)));
        }
        for (VariantContext unpairedComp : compList) {
            resolvedPairs.add(new Pair<VariantContext, VariantContext>(this.createEmptyContext(unpairedComp, this.evalSamples), this.filterGenotypes(unpairedComp, this.ignoreFilters, this.compJexls)));
        }
        return resolvedPairs;
    }

    @Override
    public ConcordanceMetrics reduce(List<Pair<VariantContext, VariantContext>> evalCompList, ConcordanceMetrics metrics) {
        for (Pair<VariantContext, VariantContext> evalComp : evalCompList) {
            metrics.update(evalComp.getFirst(), evalComp.getSecond());
        }
        return metrics;
    }

    private static double repairNaN(double d) {
        if (Double.isNaN(d)) {
            return 0.0;
        }
        return d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onTraversalDone(ConcordanceMetrics metrics) {
        GATKReport report = new GATKReport();
        GATKReportTable concordanceCounts = new GATKReportTable("GenotypeConcordance_Counts", "Per-sample concordance tables: comparison counts", 2 + GenotypeType.values().length * GenotypeType.values().length);
        GATKReportTable concordanceEvalProportions = new GATKReportTable("GenotypeConcordance_EvalProportions", "Per-sample concordance tables: proportions of genotypes called in eval", 2 + GenotypeType.values().length * GenotypeType.values().length);
        GATKReportTable concordanceCompProportions = new GATKReportTable("GenotypeConcordance_CompProportions", "Per-sample concordance tables: proportions of genotypes called in comp", 2 + GenotypeType.values().length * GenotypeType.values().length);
        GATKReportTable concordanceSummary = new GATKReportTable("GenotypeConcordance_Summary", "Per-sample summary statistics: NRS and NRD", 2);
        GATKReportTable siteConcordance = new GATKReportTable("SiteConcordance_Summary", "Site-level summary statistics", ConcordanceMetrics.SiteConcordanceType.values().length);
        if (this.moltenize) {
            void var13_47;
            ConcordanceMetrics.SiteConcordanceType type;
            void var13_45;
            concordanceCompProportions.addColumn("Sample", "%s");
            concordanceCounts.addColumn("Sample", "%s");
            concordanceEvalProportions.addColumn("Sample", "%s");
            concordanceSummary.addColumn("Sample", "%s");
            concordanceCompProportions.addColumn("Eval_Genotype", "%s");
            concordanceCounts.addColumn("Eval_Genotype", "%s");
            concordanceEvalProportions.addColumn("Eval_Genotype", "%s");
            concordanceSummary.addColumn("Non-Reference_Discrepancy", "%.3f");
            concordanceCompProportions.addColumn("Comp_Genotype", "%s");
            concordanceCounts.addColumn("Comp_Genotype", "%s");
            concordanceEvalProportions.addColumn("Comp_Genotype", "%s");
            concordanceSummary.addColumn("Non-Reference_Sensitivity", "%.3f");
            concordanceCompProportions.addColumn("Proportion", "%.3f");
            concordanceCounts.addColumn("Count", "%d");
            concordanceEvalProportions.addColumn("Proportion", "%.3f");
            for (Map.Entry<String, ConcordanceMetrics.GenotypeConcordanceTable> entry : metrics.getPerSampleGenotypeConcordance().entrySet()) {
                ConcordanceMetrics.GenotypeConcordanceTable table = entry.getValue();
                for (GenotypeType evalType : GenotypeType.values()) {
                    for (GenotypeType compType : GenotypeType.values()) {
                        String rowKey = String.format("%s_%s_%s", entry.getKey(), evalType.toString(), compType.toString());
                        concordanceCounts.set(rowKey, "Sample", (Object)entry.getKey());
                        concordanceCounts.set(rowKey, "Eval_Genotype", (Object)evalType.toString());
                        concordanceCounts.set(rowKey, "Comp_Genotype", (Object)evalType.toString());
                        int count = table.get(evalType, compType);
                        concordanceCounts.set(rowKey, "Count", (Object)count);
                        if (evalType == GenotypeType.HET || evalType == GenotypeType.HOM_REF || evalType == GenotypeType.HOM_VAR) {
                            concordanceEvalProportions.set(rowKey, "Sample", (Object)entry.getKey());
                            concordanceEvalProportions.set(rowKey, "Eval_Genotype", (Object)evalType.toString());
                            concordanceEvalProportions.set(rowKey, "Comp_Genotype", (Object)evalType.toString());
                            concordanceEvalProportions.set(rowKey, "Proportion", (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnEvalGenotypes(evalType)));
                        }
                        if (compType != GenotypeType.HET && compType != GenotypeType.HOM_VAR && compType != GenotypeType.HOM_REF) continue;
                        concordanceCompProportions.set(rowKey, "Sample", (Object)entry.getKey());
                        concordanceCompProportions.set(rowKey, "Eval_Genotype", (Object)evalType.toString());
                        concordanceCompProportions.set(rowKey, "Comp_Genotype", (Object)evalType.toString());
                        concordanceCompProportions.set(rowKey, "Proportion", (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnCompGenotypes(compType)));
                    }
                }
                String string = String.format("%s_%s", entry.getKey(), "Mismatching");
                concordanceCounts.set(string, "Sample", (Object)entry.getKey());
                concordanceCounts.set(string, "Eval_Genotype", (Object)"Mismatching_Alleles");
                concordanceCounts.set(string, "Comp_Genotype", (Object)"Mismatching_Alleles");
                concordanceEvalProportions.set(string, "Sample", (Object)entry.getKey());
                concordanceEvalProportions.set(string, "Eval_Genotype", (Object)"Mismatching_Alleles");
                concordanceEvalProportions.set(string, "Comp_Genotype", (Object)"Mismatching_Alleles");
                concordanceCompProportions.set(string, "Sample", (Object)entry.getKey());
                concordanceCompProportions.set(string, "Eval_Genotype", (Object)"Mismatching_Alleles");
                concordanceCompProportions.set(string, "Comp_Genotype", (Object)"Mismatching_Alleles");
                concordanceEvalProportions.set(string, "Proportion", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledEvalGenotypes()));
                concordanceCompProportions.set(string, "Proportion", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledCompGenotypes()));
                concordanceCounts.set(string, "Count", (Object)table.getnMismatchingAlt());
            }
            String sampleKey = "ALL";
            ConcordanceMetrics.GenotypeConcordanceTable table = metrics.getOverallGenotypeConcordance();
            for (GenotypeType genotypeType : GenotypeType.values()) {
                for (GenotypeType compType : GenotypeType.values()) {
                    String rowKey = String.format("%s_%s_%s", sampleKey, genotypeType.toString(), compType.toString());
                    concordanceCounts.set(rowKey, "Sample", (Object)sampleKey);
                    concordanceCounts.set(rowKey, "Eval_Genotype", (Object)genotypeType.toString());
                    concordanceCounts.set(rowKey, "Comp_Genotype", (Object)genotypeType.toString());
                    int count = table.get(genotypeType, compType);
                    concordanceCounts.set(rowKey, "Count", (Object)count);
                    if (genotypeType == GenotypeType.HET || genotypeType == GenotypeType.HOM_REF || genotypeType == GenotypeType.HOM_VAR) {
                        concordanceEvalProportions.set(rowKey, "Sample", (Object)sampleKey);
                        concordanceEvalProportions.set(rowKey, "Eval_Genotype", (Object)genotypeType.toString());
                        concordanceEvalProportions.set(rowKey, "Comp_Genotype", (Object)genotypeType.toString());
                        concordanceEvalProportions.set(rowKey, "Proportion", (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnEvalGenotypes(genotypeType)));
                    }
                    if (compType != GenotypeType.HET && compType != GenotypeType.HOM_VAR && compType != GenotypeType.HOM_REF) continue;
                    concordanceCompProportions.set(rowKey, "Sample", (Object)sampleKey);
                    concordanceCompProportions.set(rowKey, "Eval_Genotype", (Object)genotypeType.toString());
                    concordanceCompProportions.set(rowKey, "Comp_Genotype", (Object)genotypeType.toString());
                    concordanceCompProportions.set(rowKey, "Proportion", (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnCompGenotypes(compType)));
                }
            }
            String rowKey = String.format("%s_%s", sampleKey, "Mismatching");
            concordanceCounts.set(rowKey, "Sample", (Object)sampleKey);
            concordanceCounts.set(rowKey, "Eval_Genotype", (Object)"Mismatching_Alleles");
            concordanceCounts.set(rowKey, "Comp_Genotype", (Object)"Mismatching_Alleles");
            concordanceEvalProportions.set(rowKey, "Sample", (Object)sampleKey);
            concordanceEvalProportions.set(rowKey, "Eval_Genotype", (Object)"Mismatching_Alleles");
            concordanceEvalProportions.set(rowKey, "Comp_Genotype", (Object)"Mismatching_Alleles");
            concordanceCompProportions.set(rowKey, "Sample", (Object)sampleKey);
            concordanceCompProportions.set(rowKey, "Eval_Genotype", (Object)"Mismatching_Alleles");
            concordanceCompProportions.set(rowKey, "Comp_Genotype", (Object)"Mismatching_Alleles");
            concordanceEvalProportions.set(rowKey, "Proportion", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledEvalGenotypes()));
            concordanceCompProportions.set(rowKey, "Proportion", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledCompGenotypes()));
            concordanceCounts.set(rowKey, "Count", (Object)table.getnMismatchingAlt());
            for (Map.Entry<String, Double> nrsEntry : metrics.getPerSampleNRS().entrySet()) {
                concordanceSummary.set(nrsEntry.getKey(), "Sample", (Object)nrsEntry.getKey());
                concordanceSummary.set(nrsEntry.getKey(), "Non-Reference_Sensitivity", (Object)nrsEntry.getValue());
            }
            for (Map.Entry<String, Double> nrdEntry : metrics.getPerSampleNRD().entrySet()) {
                concordanceSummary.set(nrdEntry.getKey(), "Non-Reference_Discrepancy", (Object)nrdEntry.getValue());
            }
            concordanceSummary.set("ALL_NRS_NRD", "Sample", (Object)"ALL");
            concordanceSummary.set("ALL_NRS_NRD", "Non-Reference_Sensitivity", (Object)metrics.getOverallNRS());
            concordanceSummary.set("ALL_NRS_NRD", "Non-Reference_Discrepancy", (Object)metrics.getOverallNRD());
            ConcordanceMetrics.SiteConcordanceType[] siteConcordanceTypeArray = ConcordanceMetrics.SiteConcordanceType.values();
            int len$ = siteConcordanceTypeArray.length;
            boolean bl = false;
            while (var13_45 < len$) {
                type = siteConcordanceTypeArray[var13_45];
                siteConcordance.addColumn(type.toString(), "%d");
                ++var13_45;
            }
            ConcordanceMetrics.SiteConcordanceType[] siteConcordanceTypeArray2 = ConcordanceMetrics.SiteConcordanceType.values();
            len$ = siteConcordanceTypeArray2.length;
            boolean bl2 = false;
            while (var13_47 < len$) {
                type = siteConcordanceTypeArray2[var13_47];
                siteConcordance.set("Comparison", type.toString(), (Object)metrics.getOverallSiteConcordance().get(type));
                ++var13_47;
            }
        } else {
            concordanceCompProportions.addColumn("Sample", "%s");
            concordanceCounts.addColumn("Sample", "%s");
            concordanceEvalProportions.addColumn("Sample", "%s");
            concordanceSummary.addColumn("Sample", "%s");
            for (GenotypeType genotypeType : GenotypeType.values()) {
                for (GenotypeType compType : GenotypeType.values()) {
                    String colKey = String.format("%s_%s", genotypeType.toString(), compType.toString());
                    concordanceCounts.addColumn(colKey, "%d");
                    if (genotypeType == GenotypeType.HET || genotypeType == GenotypeType.HOM_REF || genotypeType == GenotypeType.HOM_VAR) {
                        concordanceEvalProportions.addColumn(colKey, "%.3f");
                    }
                    if (compType != GenotypeType.HET && compType != GenotypeType.HOM_VAR && compType != GenotypeType.HOM_REF) continue;
                    concordanceCompProportions.addColumn(colKey, "%.3f");
                }
            }
            concordanceEvalProportions.addColumn("Mismatching_Alleles", "%.3f");
            concordanceCompProportions.addColumn("Mismatching_Alleles", "%.3f");
            concordanceCounts.addColumn("Mismatching_Alleles", "%d");
            concordanceSummary.addColumn("Non-Reference Sensitivity", "%.3f");
            concordanceSummary.addColumn("Non-Reference Discrepancy", "%.3f");
            for (Enum enum_ : ConcordanceMetrics.SiteConcordanceType.values()) {
                siteConcordance.addColumn(enum_.toString(), "%d");
            }
            for (Map.Entry<String, ConcordanceMetrics.GenotypeConcordanceTable> entry : metrics.getPerSampleGenotypeConcordance().entrySet()) {
                ConcordanceMetrics.GenotypeConcordanceTable table = entry.getValue();
                concordanceEvalProportions.set(entry.getKey(), "Sample", (Object)entry.getKey());
                concordanceCompProportions.set(entry.getKey(), "Sample", (Object)entry.getKey());
                concordanceCounts.set(entry.getKey(), "Sample", (Object)entry.getKey());
                for (GenotypeType evalType : GenotypeType.values()) {
                    for (GenotypeType compType : GenotypeType.values()) {
                        String colKey = String.format("%s_%s", evalType.toString(), compType.toString());
                        int count = table.get(evalType, compType);
                        concordanceCounts.set(entry.getKey(), colKey, (Object)count);
                        if (evalType == GenotypeType.HET || evalType == GenotypeType.HOM_REF || evalType == GenotypeType.HOM_VAR) {
                            concordanceEvalProportions.set(entry.getKey(), colKey, (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnEvalGenotypes(evalType)));
                        }
                        if (compType != GenotypeType.HET && compType != GenotypeType.HOM_VAR && compType != GenotypeType.HOM_REF) continue;
                        concordanceCompProportions.set(entry.getKey(), colKey, (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnCompGenotypes(compType)));
                    }
                }
                concordanceEvalProportions.set(entry.getKey(), "Mismatching_Alleles", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledEvalGenotypes()));
                concordanceCompProportions.set(entry.getKey(), "Mismatching_Alleles", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledCompGenotypes()));
                concordanceCounts.set(entry.getKey(), "Mismatching_Alleles", (Object)table.getnMismatchingAlt());
            }
            String rowKey = "ALL";
            concordanceCompProportions.set(rowKey, "Sample", (Object)rowKey);
            concordanceEvalProportions.set(rowKey, "Sample", (Object)rowKey);
            concordanceCounts.set(rowKey, "Sample", (Object)rowKey);
            ConcordanceMetrics.GenotypeConcordanceTable table = metrics.getOverallGenotypeConcordance();
            for (GenotypeType genotypeType : GenotypeType.values()) {
                for (GenotypeType compType : GenotypeType.values()) {
                    String colKey = String.format("%s_%s", genotypeType.toString(), compType.toString());
                    int count = table.get(genotypeType, compType);
                    concordanceCounts.set(rowKey, colKey, (Object)count);
                    if (genotypeType == GenotypeType.HET || genotypeType == GenotypeType.HOM_REF || genotypeType == GenotypeType.HOM_VAR) {
                        concordanceEvalProportions.set(rowKey, colKey, (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnEvalGenotypes(genotypeType)));
                    }
                    if (compType != GenotypeType.HET && compType != GenotypeType.HOM_VAR && compType != GenotypeType.HOM_REF) continue;
                    concordanceCompProportions.set(rowKey, colKey, (Object)GenotypeConcordance.repairNaN((double)count / (double)table.getnCompGenotypes(compType)));
                }
            }
            concordanceEvalProportions.set(rowKey, "Mismatching_Alleles", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledEvalGenotypes()));
            concordanceCompProportions.set(rowKey, "Mismatching_Alleles", (Object)GenotypeConcordance.repairNaN((double)table.getnMismatchingAlt() / (double)table.getnCalledCompGenotypes()));
            concordanceCounts.set(rowKey, "Mismatching_Alleles", (Object)table.getnMismatchingAlt());
            for (Map.Entry<String, Double> entry : metrics.getPerSampleNRS().entrySet()) {
                concordanceSummary.set(entry.getKey(), "Sample", (Object)entry.getKey());
                concordanceSummary.set(entry.getKey(), "Non-Reference Sensitivity", (Object)entry.getValue());
            }
            for (Map.Entry<String, Double> entry : metrics.getPerSampleNRD().entrySet()) {
                concordanceSummary.set(entry.getKey(), "Non-Reference Discrepancy", (Object)entry.getValue());
            }
            concordanceSummary.set("ALL", "Sample", (Object)"ALL");
            concordanceSummary.set("ALL", "Non-Reference Sensitivity", (Object)metrics.getOverallNRS());
            concordanceSummary.set("ALL", "Non-Reference Discrepancy", (Object)metrics.getOverallNRD());
            for (Enum enum_ : ConcordanceMetrics.SiteConcordanceType.values()) {
                siteConcordance.set("Comparison", enum_.toString(), (Object)metrics.getOverallSiteConcordance().get((ConcordanceMetrics.SiteConcordanceType)enum_));
            }
        }
        report.addTable(concordanceCompProportions);
        report.addTable(concordanceEvalProportions);
        report.addTable(concordanceCounts);
        report.addTable(concordanceSummary);
        report.addTable(siteConcordance);
        report.print(this.out);
    }

    public VariantContext createEmptyContext(VariantContext other, List<String> samples) {
        VariantContextBuilder builder = new VariantContextBuilder();
        builder.alleles((Collection<Allele>)other.getAlleles());
        builder.loc(other.getChr(), other.getStart(), other.getEnd());
        ArrayList<Genotype> genotypes = new ArrayList<Genotype>(samples.size());
        for (String sample : samples) {
            genotypes.add(GenotypeBuilder.create(sample, new ArrayList<Allele>(0)));
        }
        builder.genotypes(genotypes);
        return builder.make();
    }

    public VariantContext filterGenotypes(VariantContext context, boolean ignoreSiteFilter, List<VariantContextUtils.JexlVCMatchExp> exps) {
        if (!context.isFiltered() || ignoreSiteFilter) {
            ArrayList<Genotype> filteredGenotypes = new ArrayList<Genotype>(context.getNSamples());
            for (Genotype g : context.getGenotypes()) {
                Map<VariantContextUtils.JexlVCMatchExp, Boolean> matchMap = VariantContextUtils.match(context, g, exps);
                boolean filtered = false;
                for (Boolean b : matchMap.values()) {
                    if (!b.booleanValue()) continue;
                    filtered = true;
                    break;
                }
                if (filtered) {
                    filteredGenotypes.add(GenotypeBuilder.create(g.getSampleName(), Arrays.asList(Allele.NO_CALL, Allele.NO_CALL), g.getExtendedAttributes()));
                    continue;
                }
                filteredGenotypes.add(g);
            }
            VariantContextBuilder builder = new VariantContextBuilder(context);
            builder.genotypes(filteredGenotypes);
            return builder.make();
        }
        VariantContextBuilder builder = new VariantContextBuilder();
        builder.alleles((Collection<Allele>)Arrays.asList(context.getReference()));
        builder.loc(context.getChr(), context.getStart(), context.getEnd());
        ArrayList<Genotype> newGeno = new ArrayList<Genotype>(context.getNSamples());
        for (Genotype g : context.getGenotypes().iterateInSampleNameOrder()) {
            newGeno.add(GenotypeBuilder.create(g.getSampleName(), new ArrayList<Allele>()));
        }
        builder.genotypes(newGeno);
        return builder.make();
    }
}

