/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.gatk.walkers.genotyper.GenotypeLikelihoodsCalculationModel;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedArgumentCollection;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyper;
import org.broadinstitute.sting.gatk.walkers.genotyper.UnifiedGenotyperEngine;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
public class RegenotypeVariants
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter vcfWriter = null;
    private UnifiedGenotyperEngine UG_engine = null;

    @Override
    public void initialize() {
        UnifiedArgumentCollection UAC = new UnifiedArgumentCollection();
        UAC.GLmodel = GenotypeLikelihoodsCalculationModel.Model.BOTH;
        UAC.OutputMode = UnifiedGenotyperEngine.OUTPUT_MODE.EMIT_ALL_SITES;
        UAC.GenotypingMode = GenotypeLikelihoodsCalculationModel.GENOTYPING_MODE.GENOTYPE_GIVEN_ALLELES;
        String trackName = this.variantCollection.variants.getName();
        Set<String> samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(trackName));
        this.UG_engine = new UnifiedGenotyperEngine(this.getToolkit(), UAC, logger, null, null, samples, 2);
        HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
        hInfo.addAll(GATKVCFUtils.getHeaderFields(this.getToolkit(), Arrays.asList(trackName)));
        hInfo.addAll(UnifiedGenotyper.getHeaderInfo(UAC, null, null));
        this.vcfWriter.writeHeader(new VCFHeader(hInfo, samples));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> vcs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        if (vcs == null || vcs.size() == 0) {
            return 0;
        }
        for (VariantContext vc : vcs) {
            if (vc.isPolymorphicInSamples() && this.hasPLs(vc)) {
                UnifiedGenotyperEngine unifiedGenotyperEngine = this.UG_engine;
                synchronized (unifiedGenotyperEngine) {
                    VariantContextBuilder builder = new VariantContextBuilder(this.UG_engine.calculateGenotypes(vc)).filters(vc.getFiltersMaybeNull());
                    VariantContextUtils.calculateChromosomeCounts(builder, false);
                    vc = builder.make();
                }
            }
            this.vcfWriter.add(vc);
        }
        return 1;
    }

    private boolean hasPLs(VariantContext vc) {
        for (Genotype g : vc.getGenotypes()) {
            if (!g.hasLikelihoods()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info(result + " records processed.");
    }
}

