/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.io.FilenameUtils;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Hidden;
import org.broadinstitute.sting.commandline.IntervalArgumentCollection;
import org.broadinstitute.sting.commandline.IntervalBinding;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.TreeReducible;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.interval.IntervalMergingRule;
import org.broadinstitute.sting.utils.interval.IntervalSetRule;
import org.broadinstitute.sting.utils.text.ListFileUtils;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFUtils;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
public class SelectHeaders
extends RodWalker<Integer, Integer>
implements TreeReducible<Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter vcfWriter;
    @Argument(fullName="header_name", shortName="hn", doc="Include header. Can be specified multiple times", required=false)
    public Set<String> headerNames;
    @Argument(fullName="header_expression", shortName="he", doc="Regular expression to select many headers from the tracks provided. Can be specified multiple times", required=false)
    public Set<String> headerExpressions;
    @Argument(fullName="exclude_header_name", shortName="xl_hn", doc="Exclude header. Can be specified multiple times", required=false)
    public Set<String> XLheaderNames;
    @Argument(fullName="include_interval_names", shortName="iln", doc="If set the interval file name minus the file extension, or the command line intervals, will be added to the headers", required=false)
    public boolean includeIntervals;
    @Hidden
    @Argument(fullName="include_engine_headers", shortName="ieh", doc="If set the headers normally output by the engine will be added to the headers", required=false)
    public boolean includeEngineHeaders;
    private static final ListFileUtils.StringConverter<VCFHeaderLine> headerKey = new ListFileUtils.StringConverter<VCFHeaderLine>(){

        @Override
        public String convert(VCFHeaderLine value) {
            return value.getKey();
        }
    };

    @Override
    public void initialize() {
        List<String> rodNames = Arrays.asList(this.variantCollection.variants.getName());
        Map<String, VCFHeader> vcfRods = GATKVCFUtils.getVCFHeadersFromRods(this.getToolkit(), rodNames);
        Set<VCFHeaderLine> headerLines = VCFUtils.smartMergeHeaders(vcfRods.values(), true);
        headerLines.add(new VCFHeaderLine("source", "SelectHeaders"));
        headerLines = new LinkedHashSet<VCFHeaderLine>(this.getSelectedHeaders(headerLines));
        if (this.includeIntervals) {
            File file;
            String source;
            IntervalArgumentCollection intervalArguments = this.getToolkit().getArguments().intervalArguments;
            if (intervalArguments.intervals != null) {
                for (IntervalBinding<Feature> intervalBinding : intervalArguments.intervals) {
                    source = intervalBinding.getSource();
                    if (source == null) continue;
                    file = new File(source);
                    if (file.exists()) {
                        headerLines.add(new VCFHeaderLine("intervals", FilenameUtils.getBaseName(file.getName())));
                        continue;
                    }
                    headerLines.add(new VCFHeaderLine("intervals", source));
                }
            }
            if (intervalArguments.excludeIntervals != null) {
                for (IntervalBinding<Feature> intervalBinding : intervalArguments.excludeIntervals) {
                    source = intervalBinding.getSource();
                    if (source == null) continue;
                    file = new File(source);
                    if (file.exists()) {
                        headerLines.add(new VCFHeaderLine("excludeIntervals", FilenameUtils.getBaseName(file.getName())));
                        continue;
                    }
                    headerLines.add(new VCFHeaderLine("excludeIntervals", source));
                }
            }
            if (intervalArguments.intervalMerging != IntervalMergingRule.ALL) {
                headerLines.add(new VCFHeaderLine("interval_merging", String.valueOf((Object)intervalArguments.intervalMerging)));
            }
            if (intervalArguments.intervalSetRule != IntervalSetRule.UNION) {
                headerLines.add(new VCFHeaderLine("interval_set_rule", String.valueOf((Object)intervalArguments.intervalSetRule)));
            }
            if (intervalArguments.intervalPadding != 0) {
                headerLines.add(new VCFHeaderLine("interval_padding", String.valueOf(intervalArguments.intervalPadding)));
            }
        }
        TreeSet<String> vcfSamples = new TreeSet<String>(SampleUtils.getSampleList(vcfRods, GATKVariantContextUtils.GenotypeMergeType.REQUIRE_UNIQUE));
        VCFHeader vcfHeader = new VCFHeader(headerLines, vcfSamples);
        vcfHeader.setWriteEngineHeaders(this.includeEngineHeaders);
        this.vcfWriter.writeHeader(vcfHeader);
    }

    private Set<VCFHeaderLine> getSelectedHeaders(Set<VCFHeaderLine> headerLines) {
        Set<VCFHeaderLine> selectedHeaders = new TreeSet<VCFHeaderLine>();
        if (this.headerNames == null && this.headerExpressions == null) {
            selectedHeaders.addAll(headerLines);
        } else {
            if (this.headerNames != null) {
                selectedHeaders.addAll(ListFileUtils.includeMatching(headerLines, headerKey, this.headerNames, true));
            }
            if (this.headerExpressions != null) {
                selectedHeaders.addAll(ListFileUtils.includeMatching(headerLines, headerKey, this.headerExpressions, false));
            }
        }
        if (this.XLheaderNames != null) {
            selectedHeaders = ListFileUtils.excludeMatching(selectedHeaders, headerKey, this.XLheaderNames, true);
        }
        selectedHeaders = VCFUtils.withUpdatedContigsAsLines(selectedHeaders, this.getToolkit().getArguments().referenceFile, this.getToolkit().getMasterSequenceDictionary(), true);
        return selectedHeaders;
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        List<VariantContext> vcs;
        int count = 0;
        if (tracker != null && (vcs = tracker.getValues(this.variantCollection.variants, context.getLocation())) != null) {
            for (VariantContext vc : vcs) {
                this.vcfWriter.add(vc);
                ++count;
            }
        }
        return count;
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public Integer treeReduce(Integer lhs, Integer rhs) {
        return lhs + rhs;
    }

    @Override
    public void onTraversalDone(Integer result) {
        logger.info(result + " records processed.");
    }
}

