/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.broad.tribble.TribbleException;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.arguments.StandardVariantContextInputArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;

@DocumentedGATKFeature(groupName="Validation Utilities", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=0, stop=100))
public class ValidateVariants
extends RodWalker<Integer, Integer> {
    @ArgumentCollection
    protected StandardVariantContextInputArgumentCollection variantCollection = new StandardVariantContextInputArgumentCollection();
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Argument(fullName="validationType", shortName="type", doc="which validation type to run", required=false)
    protected ValidationType type = ValidationType.ALL;
    @Argument(fullName="doNotValidateFilteredRecords", shortName="doNotValidateFilteredRecords", doc="skip validation on filtered records", required=false)
    protected Boolean DO_NOT_VALIDATE_FILTERED = false;
    @Argument(fullName="warnOnErrors", shortName="warnOnErrors", doc="just emit warnings on errors instead of terminating the run at the first instance", required=false)
    protected Boolean WARN_ON_ERROR = false;
    private long numErrors = 0L;
    private File file = null;

    @Override
    public void initialize() {
        this.file = new File(this.variantCollection.variants.getSource());
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null) {
            return 0;
        }
        List<VariantContext> VCs = tracker.getValues(this.variantCollection.variants, context.getLocation());
        for (VariantContext vc : VCs) {
            this.validate(vc, tracker, ref);
        }
        return VCs.size();
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return sum + value;
    }

    @Override
    public void onTraversalDone(Integer result) {
        if (this.numErrors == 0L) {
            System.out.println("Successfully validated the input file.  Checked " + result + " records with no failures.");
        } else {
            System.out.println("Found " + this.numErrors + " records with failures.");
        }
    }

    private void validate(VariantContext vc, RefMetaDataTracker tracker, ReferenceContext ref) {
        if (this.DO_NOT_VALIDATE_FILTERED.booleanValue() && vc.isFiltered()) {
            return;
        }
        Allele reportedRefAllele = vc.getReference();
        int refLength = reportedRefAllele.length();
        if (refLength > 100) {
            logger.info(String.format("Reference allele is too long (%d) at position %s:%d; skipping that record.", refLength, vc.getChr(), vc.getStart()));
            return;
        }
        byte[] observedRefBases = new byte[refLength];
        System.arraycopy(ref.getBases(), 0, observedRefBases, 0, refLength);
        Allele observedRefAllele = Allele.create(observedRefBases);
        HashSet<String> rsIDs = null;
        if (tracker.hasValues(this.dbsnp.dbsnp)) {
            rsIDs = new HashSet<String>();
            for (VariantContext rsID : tracker.getValues(this.dbsnp.dbsnp, ref.getLocus())) {
                rsIDs.addAll(Arrays.asList(rsID.getID().split(";")));
            }
        }
        try {
            switch (this.type) {
                case ALL: {
                    vc.extraStrictValidation(reportedRefAllele, observedRefAllele, rsIDs);
                    break;
                }
                case REF: {
                    vc.validateReferenceBases(reportedRefAllele, observedRefAllele);
                    break;
                }
                case IDS: {
                    vc.validateRSIDs(rsIDs);
                    break;
                }
                case ALLELES: {
                    vc.validateAlternateAlleles();
                    break;
                }
                case CHR_COUNTS: {
                    vc.validateChromosomeCounts();
                }
            }
        }
        catch (TribbleException e) {
            if (this.WARN_ON_ERROR.booleanValue()) {
                ++this.numErrors;
                logger.warn("***** " + e.getMessage() + " *****");
            }
            throw new UserException.FailsStrictValidation(this.file, e.getMessage());
        }
    }

    public static enum ValidationType {
        ALL,
        REF,
        IDS,
        ALLELES,
        CHR_COUNTS,
        NONE;

    }
}

