/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.walkers.variantutils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.sf.samtools.util.CloseableIterator;
import org.broad.tribble.Feature;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.commandline.ArgumentCollection;
import org.broadinstitute.sting.commandline.Input;
import org.broadinstitute.sting.commandline.Output;
import org.broadinstitute.sting.commandline.RodBinding;
import org.broadinstitute.sting.gatk.CommandLineGATK;
import org.broadinstitute.sting.gatk.arguments.DbsnpArgumentCollection;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.gatk.refdata.RefMetaDataTracker;
import org.broadinstitute.sting.gatk.refdata.VariantContextAdaptors;
import org.broadinstitute.sting.gatk.refdata.tracks.RMDTrackBuilder;
import org.broadinstitute.sting.gatk.refdata.utils.GATKFeature;
import org.broadinstitute.sting.gatk.walkers.Reference;
import org.broadinstitute.sting.gatk.walkers.RodWalker;
import org.broadinstitute.sting.gatk.walkers.Window;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.SampleUtils;
import org.broadinstitute.sting.utils.codecs.hapmap.RawHapMapFeature;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.help.DocumentedGATKFeature;
import org.broadinstitute.sting.utils.variant.GATKVCFUtils;
import org.broadinstitute.sting.utils.variant.GATKVariantContextUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriter;
import org.broadinstitute.variant.variantcontext.writer.VariantContextWriterFactory;
import org.broadinstitute.variant.vcf.VCFCodec;
import org.broadinstitute.variant.vcf.VCFFormatHeaderLine;
import org.broadinstitute.variant.vcf.VCFHeader;
import org.broadinstitute.variant.vcf.VCFHeaderLine;
import org.broadinstitute.variant.vcf.VCFStandardHeaderLines;

@DocumentedGATKFeature(groupName="Variant Evaluation and Manipulation Tools", extraDocs={CommandLineGATK.class})
@Reference(window=@Window(start=-40, stop=40))
public class VariantsToVCF
extends RodWalker<Integer, Integer> {
    @Output(doc="File to which variants should be written", required=true)
    protected VariantContextWriter baseWriter = null;
    private VariantContextWriter vcfwriter;
    @Input(fullName="variant", shortName="V", doc="Input variant file", required=true)
    public RodBinding<Feature> variants;
    @ArgumentCollection
    protected DbsnpArgumentCollection dbsnp = new DbsnpArgumentCollection();
    @Argument(fullName="sample", shortName="sample", doc="The sample name represented by the variant rod", required=false)
    protected String sampleName = null;
    private Set<String> allowedGenotypeFormatStrings = new HashSet<String>();
    private boolean wroteHeader = false;
    private Set<String> samples;
    CloseableIterator<GATKFeature> dbsnpIterator = null;

    @Override
    public void initialize() {
        this.vcfwriter = VariantContextWriterFactory.sortOnTheFly(this.baseWriter, 40, false);
    }

    @Override
    public Integer map(RefMetaDataTracker tracker, ReferenceContext ref, AlignmentContext context) {
        if (tracker == null || !BaseUtils.isRegularBase(ref.getBase())) {
            return 0;
        }
        String rsID = this.dbsnp == null ? null : GATKVCFUtils.rsIDOfFirstRealVariant(tracker.getValues(this.dbsnp.dbsnp, context.getLocation()), VariantContext.Type.SNP);
        Collection<VariantContext> contexts = this.getVariantContexts(tracker, ref);
        for (VariantContext vc : contexts) {
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            if (rsID != null && vc.emptyID()) {
                builder.id(rsID).make();
            }
            if (this.sampleName != null && vc.hasGenotypes() && vc.hasGenotype(this.variants.getName())) {
                Genotype g = new GenotypeBuilder(vc.getGenotype(this.variants.getName())).name(this.sampleName).make();
                builder.genotypes(g);
            }
            this.writeRecord(builder.make(), tracker, ref.getLocus());
        }
        return 1;
    }

    private Collection<VariantContext> getVariantContexts(RefMetaDataTracker tracker, ReferenceContext ref) {
        List<Feature> features = tracker.getValues(this.variants, ref.getLocus());
        ArrayList<VariantContext> VCs = new ArrayList<VariantContext>(features.size());
        for (Feature record : features) {
            VariantContext vc;
            RawHapMapFeature hapmap;
            if (!VariantContextAdaptors.canBeConvertedToVariantContext(record)) continue;
            if (record instanceof RawHapMapFeature && ((hapmap = (RawHapMapFeature)record).getAlleles()[0].equals("-") || hapmap.getAlleles()[1].equals("-"))) {
                VariantContext dbsnpVC = this.getDbsnp(hapmap.getName());
                if (dbsnpVC == null || dbsnpVC.isMixed()) continue;
                HashMap<String, Allele> alleleMap = new HashMap<String, Allele>(2);
                alleleMap.put("D", Allele.create(ref.getBase(), dbsnpVC.isSimpleInsertion()));
                alleleMap.put("I", Allele.create((char)ref.getBase() + ((RawHapMapFeature)record).getAlleles()[1], !dbsnpVC.isSimpleInsertion()));
                hapmap.setActualAlleles(alleleMap);
                hapmap.updatePosition(dbsnpVC.getStart());
                if (hapmap.getStart() < ref.getWindow().getStart()) {
                    logger.warn("Hapmap record at " + ref.getLocus() + " represents an indel too large to be converted; skipping...");
                    continue;
                }
            }
            if ((vc = VariantContextAdaptors.toVariantContext(this.variants.getName(), record, ref)) == null) continue;
            VCs.add(vc);
        }
        return VCs;
    }

    private VariantContext getDbsnp(String rsID) {
        if (this.dbsnpIterator == null) {
            if (this.dbsnp == null) {
                throw new UserException.BadInput("No dbSNP rod was provided, but one is needed to decipher the correct indel alleles from the HapMap records");
            }
            RMDTrackBuilder builder = new RMDTrackBuilder(this.getToolkit().getReferenceDataSource().getReference().getSequenceDictionary(), this.getToolkit().getGenomeLocParser(), this.getToolkit().getArguments().unsafe);
            this.dbsnpIterator = builder.createInstanceOfTrack(VCFCodec.class, new File(this.dbsnp.dbsnp.getSource())).getIterator();
        }
        while (this.dbsnpIterator.hasNext()) {
            GATKFeature feature = (GATKFeature)this.dbsnpIterator.next();
            VariantContext vc = (VariantContext)feature.getUnderlyingObject();
            if (!vc.getID().equals(rsID)) continue;
            return vc;
        }
        return null;
    }

    private void writeRecord(VariantContext vc, RefMetaDataTracker tracker, GenomeLoc loc) {
        if (!this.wroteHeader) {
            this.wroteHeader = true;
            HashSet<VCFHeaderLine> hInfo = new HashSet<VCFHeaderLine>();
            hInfo.addAll(GATKVCFUtils.getHeaderFields(this.getToolkit(), Arrays.asList(this.variants.getName())));
            hInfo.add(VCFStandardHeaderLines.getFormatLine("GT"));
            this.allowedGenotypeFormatStrings.add("GT");
            for (VCFHeaderLine field : hInfo) {
                if (!(field instanceof VCFFormatHeaderLine)) continue;
                this.allowedGenotypeFormatStrings.add(((VCFFormatHeaderLine)field).getID());
            }
            this.samples = new LinkedHashSet<String>();
            if (this.sampleName != null) {
                this.samples.add(this.sampleName);
            } else {
                this.samples = SampleUtils.getSampleListWithVCFHeader(this.getToolkit(), Arrays.asList(this.variants.getName()));
                if (this.samples.isEmpty()) {
                    List<Feature> features = tracker.getValues(this.variants, loc);
                    if (features.size() == 0) {
                        throw new IllegalStateException("No rod data is present, but we just created a VariantContext");
                    }
                    Feature f = features.get(0);
                    if (f instanceof RawHapMapFeature) {
                        this.samples.addAll(Arrays.asList(((RawHapMapFeature)f).getSampleIDs()));
                    } else {
                        this.samples.addAll(vc.getSampleNames());
                    }
                }
            }
            this.vcfwriter.writeHeader(new VCFHeader(hInfo, this.samples));
        }
        vc = GATKVariantContextUtils.purgeUnallowedGenotypeAttributes(vc, this.allowedGenotypeFormatStrings);
        this.vcfwriter.add(vc);
    }

    @Override
    public Integer reduceInit() {
        return 0;
    }

    @Override
    public Integer reduce(Integer value, Integer sum) {
        return value + sum;
    }

    @Override
    public void onTraversalDone(Integer sum) {
        if (this.dbsnpIterator != null) {
            this.dbsnpIterator.close();
        }
        this.vcfwriter.close();
    }
}

