/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils;

import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.samtools.Cigar;
import org.apache.commons.lang.ArrayUtils;
import org.broadinstitute.sting.gatk.contexts.ReferenceContext;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.sam.ReadUtils;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.VariantContext;

public class Haplotype
extends Allele {
    private GenomeLoc genomeLocation = null;
    private Map<Integer, VariantContext> eventMap = null;
    private Cigar cigar;
    private int alignmentStartHapwrtRef;
    private Event artificialEvent = null;

    public Haplotype(byte[] bases, boolean isRef) {
        super((byte[])bases.clone(), isRef);
    }

    public Haplotype(byte[] bases) {
        this(bases, false);
    }

    public Haplotype(Allele allele) {
        super(allele, true);
    }

    protected Haplotype(byte[] bases, Event artificialEvent) {
        this(bases, false);
        this.artificialEvent = artificialEvent;
    }

    public Haplotype(byte[] bases, GenomeLoc loc) {
        this(bases, false);
        this.genomeLocation = loc;
    }

    @Override
    public boolean equals(Object h) {
        return h instanceof Haplotype && Arrays.equals(this.getBases(), ((Haplotype)h).getBases());
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getBases());
    }

    public Map<Integer, VariantContext> getEventMap() {
        return this.eventMap;
    }

    public void setEventMap(Map<Integer, VariantContext> eventMap) {
        this.eventMap = eventMap;
    }

    @Override
    public String toString() {
        return this.getDisplayString();
    }

    public long getStartPosition() {
        return this.genomeLocation.getStart();
    }

    public long getStopPosition() {
        return this.genomeLocation.getStop();
    }

    public int getAlignmentStartHapwrtRef() {
        return this.alignmentStartHapwrtRef;
    }

    public void setAlignmentStartHapwrtRef(int alignmentStartHapwrtRef) {
        this.alignmentStartHapwrtRef = alignmentStartHapwrtRef;
    }

    public Cigar getCigar() {
        return this.cigar;
    }

    public void setCigar(Cigar cigar) {
        this.cigar = cigar;
    }

    public boolean isArtificialHaplotype() {
        return this.artificialEvent != null;
    }

    public Event getArtificialEvent() {
        return this.artificialEvent;
    }

    public Allele getArtificialRefAllele() {
        return this.artificialEvent.ref;
    }

    public Allele getArtificialAltAllele() {
        return this.artificialEvent.alt;
    }

    public int getArtificialAllelePosition() {
        return this.artificialEvent.pos;
    }

    public void setArtificialEvent(Event artificialEvent) {
        this.artificialEvent = artificialEvent;
    }

    @Requires(value={"refInsertLocation >= 0"})
    public Haplotype insertAllele(Allele refAllele, Allele altAllele, int refInsertLocation, int genomicInsertLocation) {
        int haplotypeInsertLocation = ReadUtils.getReadCoordinateForReferenceCoordinate(this.alignmentStartHapwrtRef, this.cigar, refInsertLocation, ReadUtils.ClippingTail.RIGHT_TAIL, true);
        byte[] myBases = this.getBases();
        if (haplotypeInsertLocation == -1 || haplotypeInsertLocation + refAllele.length() >= myBases.length) {
            return null;
        }
        byte[] newHaplotypeBases = new byte[]{};
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, ArrayUtils.subarray(myBases, 0, haplotypeInsertLocation));
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, altAllele.getBases());
        newHaplotypeBases = ArrayUtils.addAll(newHaplotypeBases, ArrayUtils.subarray(myBases, haplotypeInsertLocation + refAllele.length(), myBases.length));
        return new Haplotype(newHaplotypeBases, new Event(refAllele, altAllele, genomicInsertLocation));
    }

    public static LinkedHashMap<Allele, Haplotype> makeHaplotypeListFromAlleles(List<Allele> alleleList, int startPos, ReferenceContext ref, int haplotypeSize, int numPrefBases) {
        LinkedHashMap<Allele, Haplotype> haplotypeMap = new LinkedHashMap<Allele, Haplotype>();
        Allele refAllele = null;
        for (Allele a : alleleList) {
            if (!a.isReference()) continue;
            refAllele = a;
            break;
        }
        if (refAllele == null) {
            throw new ReviewedStingException("BUG: no ref alleles in input to makeHaplotypeListfrom Alleles at loc: " + startPos);
        }
        byte[] refBases = ref.getBases();
        int startIdxInReference = 1 + startPos - numPrefBases - ref.getWindow().getStart();
        String basesBeforeVariant = new String(Arrays.copyOfRange(refBases, startIdxInReference, startIdxInReference + numPrefBases));
        int startAfter = Math.min(startIdxInReference + numPrefBases + refAllele.getBases().length - 1, refBases.length);
        String basesAfterVariant = new String(Arrays.copyOfRange(refBases, startAfter, refBases.length));
        int startLoc = ref.getWindow().getStart() + startIdxInReference;
        int stopLoc = startLoc + haplotypeSize - 1;
        GenomeLoc locus = ref.getGenomeLocParser().createGenomeLoc(ref.getLocus().getContig(), startLoc, stopLoc);
        for (Allele a : alleleList) {
            byte[] alleleBases = a.getBases();
            String haplotypeString = basesBeforeVariant + new String(Arrays.copyOfRange(alleleBases, 1, alleleBases.length)) + basesAfterVariant;
            haplotypeString = haplotypeString.substring(0, haplotypeSize);
            haplotypeMap.put(a, new Haplotype(haplotypeString.getBytes(), locus));
        }
        return haplotypeMap;
    }

    private static class Event {
        public Allele ref;
        public Allele alt;
        public int pos;

        public Event(Allele ref, Allele alt, int pos) {
            this.ref = ref;
            this.alt = alt;
            this.pos = pos;
        }
    }

    public static class HaplotypeBaseComparator
    implements Comparator<Haplotype>,
    Serializable {
        @Override
        public int compare(Haplotype hap1, Haplotype hap2) {
            return HaplotypeBaseComparator.compareHaplotypeBases(hap1, hap2);
        }

        public static int compareHaplotypeBases(Haplotype hap1, Haplotype hap2) {
            byte[] arr1 = hap1.getBases();
            byte[] arr2 = hap2.getBases();
            int len = Math.min(arr1.length, arr2.length);
            for (int iii = 0; iii < len; ++iii) {
                int cmp = arr1[iii] - arr2[iii];
                if (cmp == 0) continue;
                return cmp;
            }
            return arr2.length - arr1.length;
        }
    }
}

