/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.R;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.R.RScriptExecutorException;
import org.broadinstitute.sting.utils.R.RScriptLibrary;
import org.broadinstitute.sting.utils.exceptions.StingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.io.IOUtils;
import org.broadinstitute.sting.utils.io.Resource;
import org.broadinstitute.sting.utils.runtime.ProcessController;
import org.broadinstitute.sting.utils.runtime.ProcessSettings;
import org.broadinstitute.sting.utils.runtime.RuntimeUtils;

public class RScriptExecutor {
    private static final String RSCRIPT_BINARY = "Rscript";
    private static final File RSCRIPT_PATH = RuntimeUtils.which("Rscript");
    public static final boolean RSCRIPT_EXISTS = RSCRIPT_PATH != null;
    private static final String RSCRIPT_MISSING_MESSAGE = "Please add the Rscript directory to your environment ${PATH}";
    private static Logger logger = Logger.getLogger(RScriptExecutor.class);
    private boolean exceptOnError = false;
    private final List<RScriptLibrary> libraries = new ArrayList<RScriptLibrary>();
    private final List<Resource> scriptResources = new ArrayList<Resource>();
    private final List<File> scriptFiles = new ArrayList<File>();
    private final List<String> args = new ArrayList<String>();

    public void setExceptOnError(boolean exceptOnError) {
        this.exceptOnError = exceptOnError;
    }

    public void addLibrary(RScriptLibrary library) {
        this.libraries.add(library);
    }

    public void addScript(Resource script) {
        this.scriptResources.add(script);
    }

    public void addScript(File script) {
        this.scriptFiles.add(script);
    }

    public void addArgs(Object ... args) {
        for (Object arg : args) {
            this.args.add(arg.toString());
        }
    }

    public String getApproximateCommandLine() {
        StringBuilder command = new StringBuilder(RSCRIPT_BINARY);
        for (Resource resource : this.scriptResources) {
            command.append(" (resource)").append(resource.getFullPath());
        }
        for (File file : this.scriptFiles) {
            command.append(" ").append(file.getAbsolutePath());
        }
        for (String string : this.args) {
            command.append(" ").append(string);
        }
        return command.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public boolean exec() {
        if (!RSCRIPT_EXISTS) {
            if (this.exceptOnError) {
                throw new UserException.CannotExecuteRScript(RSCRIPT_MISSING_MESSAGE);
            }
            logger.warn("Skipping: " + this.getApproximateCommandLine());
            return false;
        }
        ArrayList<File> tempFiles = new ArrayList<File>();
        try {
            void var6_19;
            File tempLibSourceDir = IOUtils.tempDir("RlibSources.", "");
            File tempLibInstallationDir = IOUtils.tempDir("Rlib.", "");
            tempFiles.add(tempLibSourceDir);
            tempFiles.add(tempLibInstallationDir);
            StringBuilder expression = new StringBuilder("tempLibDir = '").append(tempLibInstallationDir).append("';");
            if (this.libraries.size() > 0) {
                ArrayList<String> tempLibraryPaths = new ArrayList<String>();
                for (RScriptLibrary library : this.libraries) {
                    File tempLibrary = library.writeLibrary(tempLibSourceDir);
                    tempFiles.add(tempLibrary);
                    tempLibraryPaths.add(tempLibrary.getAbsolutePath());
                }
                expression.append("install.packages(");
                expression.append("pkgs=c('").append(StringUtils.join(tempLibraryPaths, "', '")).append("'), lib=tempLibDir, repos=NULL, type='source', ");
                expression.append("INSTALL_opts=c('--no-libs', '--no-data', '--no-help', '--no-demo', '--no-exec')");
                expression.append(");");
                for (RScriptLibrary library : this.libraries) {
                    expression.append("library('").append(library.getLibraryName()).append("', lib.loc=tempLibDir);");
                }
            }
            for (Resource resource : this.scriptResources) {
                File tempScript = IOUtils.writeTempResource(resource);
                tempFiles.add(tempScript);
                expression.append("source('").append(tempScript.getAbsolutePath()).append("');");
            }
            for (File file : this.scriptFiles) {
                expression.append("source('").append(file.getAbsolutePath()).append("');");
            }
            String[] cmd = new String[this.args.size() + 3];
            int n = 0;
            cmd[n] = RSCRIPT_BINARY;
            cmd[++var6_17] = "-e";
            ++var6_19;
            cmd[++var6_18] = expression.toString();
            for (String arg : this.args) {
                cmd[++var6_20] = arg;
            }
            ProcessSettings processSettings = new ProcessSettings(cmd);
            if (logger.isDebugEnabled()) {
                processSettings.getStdoutSettings().printStandard(true);
                processSettings.getStderrSettings().printStandard(true);
            }
            ProcessController controller = ProcessController.getThreadLocal();
            if (logger.isDebugEnabled()) {
                logger.debug("Executing:");
                for (String arg : cmd) {
                    logger.debug("  " + arg);
                }
            }
            int exitValue = controller.exec(processSettings).getExitValue();
            logger.debug("Result: " + exitValue);
            if (exitValue != 0) {
                throw new RScriptExecutorException("RScript exited with " + exitValue + (logger.isDebugEnabled() ? "" : ". Run with -l DEBUG for more info."));
            }
            boolean bl = true;
            return bl;
        }
        catch (StingException e) {
            if (this.exceptOnError) {
                throw e;
            }
            logger.warn(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            for (File temp : tempFiles) {
                FileUtils.deleteQuietly(temp);
            }
        }
    }
}

