/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.activeregion;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.activeregion.ActiveRegion;
import org.broadinstitute.sting.utils.activeregion.ActivityProfileState;

public class ActivityProfile {
    private static final int MAX_PROB_PROPOGATION_DISTANCE = 50;
    protected static final double ACTIVE_PROB_THRESHOLD = 0.002;
    protected final List<ActivityProfileState> stateList;
    protected final GenomeLocParser parser;
    protected final GenomeLocSortedSet restrictToIntervals;
    protected GenomeLoc regionStartLoc = null;
    protected GenomeLoc regionStopLoc = null;
    protected int contigLength = -1;

    public ActivityProfile(GenomeLocParser parser) {
        this(parser, null);
    }

    public ActivityProfile(GenomeLocParser parser, GenomeLocSortedSet intervals) {
        if (parser == null) {
            throw new IllegalArgumentException("parser cannot be null");
        }
        this.parser = parser;
        this.stateList = new ArrayList<ActivityProfileState>();
        this.restrictToIntervals = intervals;
    }

    public String toString() {
        return "ActivityProfile{start=" + this.regionStartLoc + ", stop=" + this.regionStopLoc + '}';
    }

    @Ensures(value={"result >= 0"})
    public int getMaxProbPropagationDistance() {
        return 50;
    }

    @Ensures(value={"result >= 0"})
    public int size() {
        return this.stateList.size();
    }

    @Ensures(value={"isEmpty() == (size() == 0)"})
    public boolean isEmpty() {
        return this.stateList.isEmpty();
    }

    public GenomeLoc getSpan() {
        return this.isEmpty() ? null : this.regionStartLoc.endpointSpan(this.regionStopLoc);
    }

    @Requires(value={"! isEmpty()"})
    public int getContigIndex() {
        return this.regionStartLoc.getContigIndex();
    }

    @Requires(value={"! isEmpty()"})
    public int getStop() {
        return this.regionStopLoc.getStop();
    }

    @Ensures(value={"result != null"})
    protected List<ActivityProfileState> getStateList() {
        return this.stateList;
    }

    @Ensures(value={"result != null"})
    protected double[] getProbabilitiesAsArray() {
        double[] probs = new double[this.getStateList().size()];
        int i = 0;
        for (ActivityProfileState state : this.getStateList()) {
            probs[i++] = state.isActiveProb;
        }
        return probs;
    }

    @Requires(value={"relativeLoc != null"})
    protected GenomeLoc getLocForOffset(GenomeLoc relativeLoc, int offset) {
        int start = relativeLoc.getStart() + offset;
        if (start < 0 || start > this.getCurrentContigLength()) {
            return null;
        }
        return this.parser.createGenomeLoc(this.regionStartLoc.getContig(), this.regionStartLoc.getContigIndex(), start, start);
    }

    @Requires(value={"regionStartLoc != null"})
    @Ensures(value={"result > 0"})
    private int getCurrentContigLength() {
        return this.contigLength;
    }

    @Requires(value={"state != null"})
    public void add(ActivityProfileState state) {
        GenomeLoc loc = state.getLoc();
        if (this.regionStartLoc == null) {
            this.regionStartLoc = loc;
            this.regionStopLoc = loc;
            this.contigLength = this.parser.getContigInfo(this.regionStartLoc.getContig()).getSequenceLength();
        } else {
            if (this.regionStopLoc.getStart() != loc.getStart() - 1) {
                throw new IllegalArgumentException("Bad add call to ActivityProfile: loc " + loc + " not immediate after last loc " + this.regionStopLoc);
            }
            this.regionStopLoc = loc;
        }
        Collection<ActivityProfileState> processedStates = this.processState(state);
        for (ActivityProfileState processedState : processedStates) {
            this.incorporateSingleState(processedState);
        }
    }

    @Requires(value={"stateToAdd != null"})
    private void incorporateSingleState(ActivityProfileState stateToAdd) {
        int position = stateToAdd.getOffset(this.regionStartLoc);
        if (position > this.size()) {
            throw new IllegalArgumentException("Must add state contiguous to existing states: adding " + stateToAdd);
        }
        if (position >= 0) {
            if (position < this.size()) {
                this.stateList.get((int)position).isActiveProb += stateToAdd.isActiveProb;
            } else {
                if (position != this.size()) {
                    throw new IllegalStateException("position == size but it wasn't");
                }
                this.stateList.add(stateToAdd);
            }
        }
    }

    protected Collection<ActivityProfileState> processState(ActivityProfileState justAddedState) {
        if (justAddedState.resultState.equals((Object)ActivityProfileState.Type.HIGH_QUALITY_SOFT_CLIPS)) {
            LinkedList<ActivityProfileState> states = new LinkedList<ActivityProfileState>();
            int numHQClips = Math.min(justAddedState.resultValue.intValue(), this.getMaxProbPropagationDistance());
            for (int jjj = -numHQClips; jjj <= numHQClips; ++jjj) {
                GenomeLoc loc = this.getLocForOffset(justAddedState.getLoc(), jjj);
                if (loc == null) continue;
                states.add(new ActivityProfileState(loc, justAddedState.isActiveProb));
            }
            return states;
        }
        return Collections.singletonList(justAddedState);
    }

    @Ensures(value={"result != null"})
    public List<ActiveRegion> popReadyActiveRegions(int activeRegionExtension, int minRegionSize, int maxRegionSize, boolean forceConversion) {
        if (activeRegionExtension < 0) {
            throw new IllegalArgumentException("activeRegionExtension must be >= 0 but got " + activeRegionExtension);
        }
        if (minRegionSize < 1) {
            throw new IllegalArgumentException("minRegionSize must be >= 1 but got " + minRegionSize);
        }
        if (maxRegionSize < 1) {
            throw new IllegalArgumentException("maxRegionSize must be >= 1 but got " + maxRegionSize);
        }
        LinkedList<ActiveRegion> regions = new LinkedList<ActiveRegion>();
        ActiveRegion nextRegion;
        while ((nextRegion = this.popNextReadyActiveRegion(activeRegionExtension, minRegionSize, maxRegionSize, forceConversion)) != null) {
            if (this.restrictToIntervals == null) {
                regions.add(nextRegion);
                continue;
            }
            regions.addAll(nextRegion.splitAndTrimToIntervals(this.restrictToIntervals));
        }
        return regions;
    }

    private ActiveRegion popNextReadyActiveRegion(int activeRegionExtension, int minRegionSize, int maxRegionSize, boolean forceConversion) {
        if (this.stateList.isEmpty()) {
            return null;
        }
        ActivityProfileState first = this.stateList.get(0);
        boolean isActiveRegion = first.isActiveProb > 0.002;
        int offsetOfNextRegionEnd = this.findEndOfRegion(isActiveRegion, minRegionSize, maxRegionSize, forceConversion);
        if (offsetOfNextRegionEnd == -1) {
            return null;
        }
        List<ActivityProfileState> sub = this.stateList.subList(0, offsetOfNextRegionEnd + 1);
        ArrayList<ActivityProfileState> supportingStates = new ArrayList<ActivityProfileState>(sub);
        sub.clear();
        if (this.stateList.isEmpty()) {
            this.regionStopLoc = null;
            this.regionStartLoc = null;
        } else {
            this.regionStartLoc = this.stateList.get(0).getLoc();
        }
        GenomeLoc regionLoc = this.parser.createGenomeLoc(first.getLoc().getContig(), first.getLoc().getStart(), first.getLoc().getStart() + offsetOfNextRegionEnd);
        return new ActiveRegion(regionLoc, supportingStates, isActiveRegion, this.parser, activeRegionExtension);
    }

    @Ensures(value={"result >= -1", "result == -1 || result < maxRegionSize", "! (result == -1 && forceConversion)"})
    private int findEndOfRegion(boolean isActiveRegion, int minRegionSize, int maxRegionSize, boolean forceConversion) {
        if (!forceConversion && this.stateList.size() < maxRegionSize + this.getMaxProbPropagationDistance()) {
            return -1;
        }
        int endOfActiveRegion = this.findFirstActivityBoundary(isActiveRegion, maxRegionSize);
        if (isActiveRegion && endOfActiveRegion == maxRegionSize) {
            endOfActiveRegion = this.findBestCutSite(endOfActiveRegion, minRegionSize);
        }
        return endOfActiveRegion - 1;
    }

    @Requires(value={"endOfActiveRegion >= minRegionSize", "minRegionSize >= 0"})
    @Ensures(value={"result >= minRegionSize", "result <= endOfActiveRegion"})
    private int findBestCutSite(int endOfActiveRegion, int minRegionSize) {
        int minI = endOfActiveRegion - 1;
        double minP = Double.MAX_VALUE;
        for (int i = minI; i >= minRegionSize - 1; --i) {
            double cur = this.getProb(i);
            if (!(cur < minP) || !this.isMinimum(i)) continue;
            minP = cur;
            minI = i;
        }
        return minI + 1;
    }

    @Requires(value={"maxRegionSize > 0"})
    @Ensures(value={"result >= 0", "result <= stateList.size()"})
    private int findFirstActivityBoundary(boolean isActiveRegion, int maxRegionSize) {
        int endOfActiveRegion;
        int nStates = this.stateList.size();
        for (endOfActiveRegion = 0; endOfActiveRegion < nStates && endOfActiveRegion < maxRegionSize && this.getProb(endOfActiveRegion) > 0.002 == isActiveRegion; ++endOfActiveRegion) {
        }
        return endOfActiveRegion;
    }

    @Requires(value={"index >= 0", "index < stateList.size()"})
    private double getProb(int index) {
        return this.stateList.get((int)index).isActiveProb;
    }

    @Requires(value={"index >= 0", "index < stateList.size()"})
    private boolean isMinimum(int index) {
        if (index == this.stateList.size() - 1) {
            return false;
        }
        if (index < 1) {
            return false;
        }
        double indexP = this.getProb(index);
        return indexP <= this.getProb(index + 1) && indexP < this.getProb(index - 1);
    }
}

