/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.genotyper;

import com.google.java.contract.Ensures;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.sting.gatk.downsampling.AlleleBiasedDownsamplingUtils;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.pileup.ReadBackedPileup;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;
import org.broadinstitute.variant.variantcontext.Allele;

public class PerReadAlleleLikelihoodMap {
    public static final double INFORMATIVE_LIKELIHOOD_THRESHOLD = 0.2;
    protected List<Allele> alleles;
    protected Map<GATKSAMRecord, Map<Allele, Double>> likelihoodReadMap = new LinkedHashMap<GATKSAMRecord, Map<Allele, Double>>();

    public PerReadAlleleLikelihoodMap() {
        this.alleles = new ArrayList<Allele>();
    }

    public void add(GATKSAMRecord read, Allele a, Double likelihood) {
        if (read == null) {
            throw new IllegalArgumentException("Cannot add a null read to the allele likelihood map");
        }
        if (a == null) {
            throw new IllegalArgumentException("Cannot add a null allele to the allele likelihood map");
        }
        if (likelihood == null) {
            throw new IllegalArgumentException("Likelihood cannot be null");
        }
        if (likelihood > 0.0) {
            throw new IllegalArgumentException("Likelihood must be negative (L = log(p))");
        }
        Map<Allele, Double> likelihoodMap = this.likelihoodReadMap.get(read);
        if (likelihoodMap == null) {
            likelihoodMap = new LinkedHashMap<Allele, Double>();
        }
        this.likelihoodReadMap.put(read, likelihoodMap);
        likelihoodMap.put(a, likelihood);
        if (!this.alleles.contains(a)) {
            this.alleles.add(a);
        }
    }

    public ReadBackedPileup createPerAlleleDownsampledBasePileup(ReadBackedPileup pileup, double downsamplingFraction, PrintStream log) {
        return AlleleBiasedDownsamplingUtils.createAlleleBiasedBasePileup(pileup, downsamplingFraction, log);
    }

    public void performPerAlleleDownsampling(double downsamplingFraction, PrintStream log) {
        if (downsamplingFraction <= 0.0) {
            return;
        }
        if (downsamplingFraction >= 1.0) {
            this.likelihoodReadMap.clear();
            return;
        }
        Map<Allele, List<GATKSAMRecord>> alleleReadMap = this.getAlleleStratifiedReadMap();
        List<GATKSAMRecord> readsToRemove = AlleleBiasedDownsamplingUtils.selectAlleleBiasedReads(alleleReadMap, downsamplingFraction, log);
        for (GATKSAMRecord read : readsToRemove) {
            this.likelihoodReadMap.remove(read);
        }
    }

    protected Map<Allele, List<GATKSAMRecord>> getAlleleStratifiedReadMap() {
        HashMap<Allele, List<GATKSAMRecord>> alleleReadMap = new HashMap<Allele, List<GATKSAMRecord>>(this.alleles.size());
        for (Allele allele : this.alleles) {
            alleleReadMap.put(allele, new ArrayList());
        }
        for (Map.Entry entry : this.likelihoodReadMap.entrySet()) {
            Allele bestAllele;
            if (((GATKSAMRecord)entry.getKey()).isReducedRead() || (bestAllele = PerReadAlleleLikelihoodMap.getMostLikelyAllele((Map)entry.getValue())) == Allele.NO_CALL) continue;
            ((List)alleleReadMap.get(bestAllele)).add(entry.getKey());
        }
        return alleleReadMap;
    }

    @Ensures(value={"result >=0"})
    public int size() {
        return this.likelihoodReadMap.size();
    }

    public void add(PileupElement p, Allele a, Double likelihood) {
        if (p == null) {
            throw new IllegalArgumentException("Pileup element cannot be null");
        }
        if (p.getRead() == null) {
            throw new IllegalArgumentException("Read underlying pileup element cannot be null");
        }
        if (a == null) {
            throw new IllegalArgumentException("Allele for add() cannot be null");
        }
        this.add(p.getRead(), a, likelihood);
    }

    public boolean containsPileupElement(PileupElement p) {
        return this.likelihoodReadMap.containsKey(p.getRead());
    }

    public boolean isEmpty() {
        return this.likelihoodReadMap.isEmpty();
    }

    public Map<GATKSAMRecord, Map<Allele, Double>> getLikelihoodReadMap() {
        return this.likelihoodReadMap;
    }

    public void clear() {
        this.alleles.clear();
        this.likelihoodReadMap.clear();
    }

    public Set<GATKSAMRecord> getStoredElements() {
        return this.likelihoodReadMap.keySet();
    }

    public Collection<Map<Allele, Double>> getLikelihoodMapValues() {
        return this.likelihoodReadMap.values();
    }

    public int getNumberOfStoredElements() {
        return this.likelihoodReadMap.size();
    }

    public Map<Allele, Double> getLikelihoodsAssociatedWithPileupElement(PileupElement p) {
        if (!this.likelihoodReadMap.containsKey(p.getRead())) {
            return null;
        }
        return this.likelihoodReadMap.get(p.getRead());
    }

    @Ensures(value={"result != null"})
    public static Allele getMostLikelyAllele(Map<Allele, Double> alleleMap) {
        if (alleleMap == null) {
            throw new IllegalArgumentException("The allele to likelihood map cannot be null");
        }
        double maxLike = Double.NEGATIVE_INFINITY;
        double prevMaxLike = Double.NEGATIVE_INFINITY;
        Allele mostLikelyAllele = Allele.NO_CALL;
        for (Map.Entry<Allele, Double> el : alleleMap.entrySet()) {
            if (el.getValue() > maxLike) {
                prevMaxLike = maxLike;
                maxLike = el.getValue();
                mostLikelyAllele = el.getKey();
                continue;
            }
            if (!(el.getValue() > prevMaxLike)) continue;
            prevMaxLike = el.getValue();
        }
        return maxLike - prevMaxLike > 0.2 ? mostLikelyAllele : Allele.NO_CALL;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Alelles in map:");
        for (Allele allele : this.alleles) {
            sb.append(allele.getDisplayString() + ",");
        }
        sb.append("\n");
        for (Map.Entry entry : this.getLikelihoodReadMap().entrySet()) {
            for (Map.Entry eli : ((Map)entry.getValue()).entrySet()) {
                sb.append("Read " + ((GATKSAMRecord)entry.getKey()).getReadName() + ". Allele:" + ((Allele)eli.getKey()).getDisplayString() + " has likelihood=" + Double.toString((Double)eli.getValue()) + "\n");
            }
        }
        return sb.toString();
    }
}

