/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.nanoScheduler;

import com.google.java.contract.Ensures;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.utils.MultiThreadedErrorTracker;
import org.broadinstitute.sting.utils.nanoScheduler.MapResult;
import org.broadinstitute.sting.utils.nanoScheduler.MapResultsQueue;
import org.broadinstitute.sting.utils.nanoScheduler.NSReduceFunction;

class Reducer<MapType, ReduceType> {
    private static final Logger logger = Logger.getLogger(Reducer.class);
    private final NSReduceFunction<MapType, ReduceType> reduce;
    private final MultiThreadedErrorTracker errorTracker;
    private final Lock reduceLock = new ReentrantLock();
    ReduceType sum;

    public Reducer(NSReduceFunction<MapType, ReduceType> reduce, MultiThreadedErrorTracker errorTracker, ReduceType initialSum) {
        if (errorTracker == null) {
            throw new IllegalArgumentException("Error tracker cannot be null");
        }
        if (reduce == null) {
            throw new IllegalArgumentException("Reduce function cannot be null");
        }
        this.errorTracker = errorTracker;
        this.reduce = reduce;
        this.sum = initialSum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ensures(value={"result >= 0"})
    public int reduceAsMuchAsPossible(MapResultsQueue<MapType> mapResultQueue, boolean waitForLock) {
        if (mapResultQueue == null) {
            throw new IllegalArgumentException("mapResultQueue cannot be null");
        }
        int nReducesNow = 0;
        boolean haveLock = this.acquireReduceLock(waitForLock);
        try {
            if (haveLock) {
                while (mapResultQueue.nextValueIsAvailable()) {
                    MapResult<MapType> result = mapResultQueue.take();
                    if (result.isEOFMarker()) continue;
                    ++nReducesNow;
                    this.sum = this.reduce.apply(result.getValue(), this.sum);
                }
            }
        }
        catch (Exception ex) {
            this.errorTracker.notifyOfError(ex);
        }
        finally {
            if (haveLock) {
                this.releaseReduceLock();
            }
        }
        return nReducesNow;
    }

    protected boolean acquireReduceLock(boolean blockUntilAvailable) {
        if (blockUntilAvailable) {
            this.reduceLock.lock();
            return true;
        }
        return this.reduceLock.tryLock();
    }

    protected void releaseReduceLock() {
        this.reduceLock.unlock();
    }

    public ReduceType getReduceResult() {
        return this.sum;
    }
}

