/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.pairhmm;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import org.broadinstitute.sting.utils.QualityUtils;
import org.broadinstitute.sting.utils.pairhmm.PairHMM;

public class LoglessCachingPairHMM
extends PairHMM {
    protected static final double SCALE_FACTOR_LOG10 = 300.0;
    double[][] constantMatrix = null;
    double[][] distanceMatrix = null;
    boolean constantsAreInitialized = false;
    protected static final double[] firstRowConstantMatrix = new double[]{QualityUtils.qualToProb((byte)90), QualityUtils.qualToProb((byte)10), QualityUtils.qualToErrorProb((byte)45), QualityUtils.qualToErrorProb((byte)10), 1.0, 1.0};

    @Override
    public void initialize(int readMaxLength, int haplotypeMaxLength) {
        super.initialize(readMaxLength, haplotypeMaxLength);
        this.constantMatrix = new double[this.X_METRIC_MAX_LENGTH][6];
        this.distanceMatrix = new double[this.X_METRIC_MAX_LENGTH][this.Y_METRIC_MAX_LENGTH];
    }

    @Override
    public double subComputeReadLikelihoodGivenHaplotypeLog10(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP, int hapStartIndex, boolean recacheReadValues) {
        if (!this.constantsAreInitialized || recacheReadValues) {
            this.initializeConstants(haplotypeBases.length, readBases.length, insertionGOP, deletionGOP, overallGCP);
        }
        this.initializeDistanceMatrix(haplotypeBases, readBases, readQuals, hapStartIndex);
        int readXMetricLength = readBases.length + 2;
        int hapYMetricLength = haplotypeBases.length + 2;
        for (int i = 2; i < readXMetricLength; ++i) {
            for (int j = hapStartIndex + 1; j < hapYMetricLength; ++j) {
                this.updateCell(i, j, this.distanceMatrix[i][j], this.constantMatrix[i], this.matchMetricArray, this.XMetricArray, this.YMetricArray);
            }
        }
        int endI = readXMetricLength - 1;
        int endJ = hapYMetricLength - 1;
        return Math.log10(this.matchMetricArray[endI][endJ] + this.XMetricArray[endI][endJ] + this.YMetricArray[endI][endJ]) - 300.0;
    }

    public void initializeDistanceMatrix(byte[] haplotypeBases, byte[] readBases, byte[] readQuals, int startIndex) {
        for (int i = 0; i < readBases.length; ++i) {
            byte x = readBases[i];
            byte qual = readQuals[i];
            for (int j = startIndex; j < haplotypeBases.length; ++j) {
                byte y = haplotypeBases[j];
                this.distanceMatrix[i + 2][j + 2] = x == y || x == 78 || y == 78 ? QualityUtils.qualToProb(qual) : QualityUtils.qualToErrorProb(qual);
            }
        }
    }

    @Requires(value={"haplotypeSize > 0", "readSize > 0", "insertionGOP != null && insertionGOP.length == readSize", "deletionGOP != null && deletionGOP.length == readSize", "overallGCP != null && overallGCP.length == readSize"})
    @Ensures(value={"constantsAreInitialized"})
    private void initializeConstants(int haplotypeSize, int readSize, byte[] insertionGOP, byte[] deletionGOP, byte[] overallGCP) {
        this.matchMetricArray[1][1] = Math.pow(10.0, 300.0) / (double)this.getNPotentialXStarts(haplotypeSize, readSize);
        for (int jjj = 2; jjj < this.Y_METRIC_MAX_LENGTH; ++jjj) {
            this.updateCell(1, jjj, 1.0, firstRowConstantMatrix, this.matchMetricArray, this.XMetricArray, this.YMetricArray);
        }
        int l = insertionGOP.length;
        this.constantMatrix[1] = firstRowConstantMatrix;
        for (int i = 0; i < l; ++i) {
            int qualIndexGOP = Math.min(insertionGOP[i] + deletionGOP[i], 127);
            this.constantMatrix[i + 2][0] = QualityUtils.qualToProb((byte)qualIndexGOP);
            this.constantMatrix[i + 2][1] = QualityUtils.qualToProb(overallGCP[i]);
            this.constantMatrix[i + 2][2] = QualityUtils.qualToErrorProb(insertionGOP[i]);
            this.constantMatrix[i + 2][3] = QualityUtils.qualToErrorProb(overallGCP[i]);
            this.constantMatrix[i + 2][4] = QualityUtils.qualToErrorProb(deletionGOP[i]);
            this.constantMatrix[i + 2][5] = QualityUtils.qualToErrorProb(overallGCP[i]);
        }
        this.constantMatrix[l + 1][4] = 1.0;
        this.constantMatrix[l + 1][5] = 1.0;
        this.constantsAreInitialized = true;
    }

    private void updateCell(int indI, int indJ, double prior, double[] constants, double[][] matchMetricArray, double[][] XMetricArray, double[][] YMetricArray) {
        matchMetricArray[indI][indJ] = prior * (matchMetricArray[indI - 1][indJ - 1] * constants[0] + XMetricArray[indI - 1][indJ - 1] * constants[1] + YMetricArray[indI - 1][indJ - 1] * constants[1]);
        XMetricArray[indI][indJ] = matchMetricArray[indI - 1][indJ] * constants[2] + XMetricArray[indI - 1][indJ] * constants[3];
        YMetricArray[indI][indJ] = matchMetricArray[indI][indJ - 1] * constants[4] + YMetricArray[indI][indJ - 1] * constants[5];
    }
}

