/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration.covariates;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.clipping.ClippingRepresentation;
import org.broadinstitute.sting.utils.clipping.ReadClipper;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.recalibration.ReadCovariates;
import org.broadinstitute.sting.utils.recalibration.covariates.StandardCovariate;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public class ContextCovariate
implements StandardCovariate {
    private static final Logger logger = Logger.getLogger(ContextCovariate.class);
    private int mismatchesContextSize;
    private int indelsContextSize;
    private int mismatchesKeyMask;
    private int indelsKeyMask;
    private static final int LENGTH_BITS = 4;
    private static final int LENGTH_MASK = 15;
    private static final int MAX_DNA_CONTEXT = 13;
    private byte LOW_QUAL_TAIL;

    @Override
    public void initialize(RecalibrationArgumentCollection RAC) {
        this.mismatchesContextSize = RAC.MISMATCHES_CONTEXT_SIZE;
        this.indelsContextSize = RAC.INDELS_CONTEXT_SIZE;
        logger.info("\t\tContext sizes: base substitution model " + this.mismatchesContextSize + ", indel substitution model " + this.indelsContextSize);
        if (this.mismatchesContextSize > 13) {
            throw new UserException.BadArgumentValue("mismatches_context_size", String.format("context size cannot be bigger than %d, but was %d", 13, this.mismatchesContextSize));
        }
        if (this.indelsContextSize > 13) {
            throw new UserException.BadArgumentValue("indels_context_size", String.format("context size cannot be bigger than %d, but was %d", 13, this.indelsContextSize));
        }
        this.LOW_QUAL_TAIL = RAC.LOW_QUAL_TAIL;
        if (this.mismatchesContextSize <= 0 || this.indelsContextSize <= 0) {
            throw new UserException(String.format("Context size must be positive, if you don't want to use the context covariate, just turn it off instead. Mismatches: %d Indels: %d", this.mismatchesContextSize, this.indelsContextSize));
        }
        this.mismatchesKeyMask = ContextCovariate.createMask(this.mismatchesContextSize);
        this.indelsKeyMask = ContextCovariate.createMask(this.indelsContextSize);
    }

    @Override
    public void recordValues(GATKSAMRecord read, ReadCovariates values) {
        int i;
        byte[] originalBases = (byte[])read.getReadBases().clone();
        GATKSAMRecord clippedRead = ReadClipper.clipLowQualEnds(read, this.LOW_QUAL_TAIL, ClippingRepresentation.WRITE_NS);
        boolean negativeStrand = clippedRead.getReadNegativeStrandFlag();
        byte[] bases = clippedRead.getReadBases();
        if (negativeStrand) {
            bases = BaseUtils.simpleReverseComplement(bases);
        }
        ArrayList<Integer> mismatchKeys = ContextCovariate.contextWith(bases, this.mismatchesContextSize, this.mismatchesKeyMask);
        ArrayList<Integer> indelKeys = ContextCovariate.contextWith(bases, this.indelsContextSize, this.indelsKeyMask);
        int readLength = bases.length;
        if (readLength != originalBases.length) {
            for (i = 0; i < originalBases.length; ++i) {
                values.addCovariate(0, 0, 0, i);
            }
        }
        for (i = 0; i < readLength; ++i) {
            int readOffset = negativeStrand ? readLength - i - 1 : i;
            int indelKey = indelKeys.get(i);
            values.addCovariate(mismatchKeys.get(i), indelKey, indelKey, readOffset);
        }
        read.setReadBases(originalBases);
    }

    @Override
    public final Object getValue(String str) {
        return str;
    }

    @Override
    public String formatKey(int key) {
        if (key == -1) {
            return null;
        }
        return ContextCovariate.contextFromKey(key);
    }

    @Override
    public int keyFromValue(Object value) {
        return ContextCovariate.keyFromContext((String)value);
    }

    private static int createMask(int contextSize) {
        int mask = 0;
        for (int i = 0; i < contextSize; ++i) {
            mask = mask << 2 | 3;
        }
        return mask << 4;
    }

    private static ArrayList<Integer> contextWith(byte[] bases, int contextSize, int mask) {
        int baseIndex;
        int readLength = bases.length;
        ArrayList<Integer> keys = new ArrayList<Integer>(readLength);
        for (int i = 1; i < contextSize && i <= readLength; ++i) {
            keys.add(-1);
        }
        if (readLength < contextSize) {
            return keys;
        }
        int newBaseOffset = 2 * (contextSize - 1) + 4;
        int currentKey = ContextCovariate.keyFromContext(bases, 0, contextSize);
        keys.add(currentKey);
        int currentNPenalty = 0;
        if (currentKey == -1) {
            currentKey = 0;
            currentNPenalty = contextSize - 1;
            int offset = newBaseOffset;
            while (bases[currentNPenalty] != 78) {
                baseIndex = BaseUtils.simpleBaseToBaseIndex(bases[currentNPenalty]);
                currentKey |= baseIndex << offset;
                offset -= 2;
                --currentNPenalty;
            }
        }
        for (int currentIndex = contextSize; currentIndex < readLength; ++currentIndex) {
            baseIndex = BaseUtils.simpleBaseToBaseIndex(bases[currentIndex]);
            if (baseIndex == -1) {
                currentNPenalty = contextSize;
                currentKey = 0;
            } else {
                currentKey = currentKey >> 2 & mask;
                currentKey |= baseIndex << newBaseOffset;
                currentKey |= contextSize;
            }
            if (currentNPenalty == 0) {
                keys.add(currentKey);
                continue;
            }
            --currentNPenalty;
            keys.add(-1);
        }
        return keys;
    }

    public static int keyFromContext(String dna) {
        return ContextCovariate.keyFromContext(dna.getBytes(), 0, dna.length());
    }

    private static int keyFromContext(byte[] dna, int start, int end) {
        int key = end - start;
        int bitOffset = 4;
        for (int i = start; i < end; ++i) {
            int baseIndex = BaseUtils.simpleBaseToBaseIndex(dna[i]);
            if (baseIndex == -1) {
                return -1;
            }
            key |= baseIndex << bitOffset;
            bitOffset += 2;
        }
        return key;
    }

    public static String contextFromKey(int key) {
        if (key < 0) {
            throw new ReviewedStingException("dna conversion cannot handle negative numbers. Possible overflow?");
        }
        int length = key & 0xF;
        int mask = 48;
        int offset = 4;
        StringBuilder dna = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int baseIndex = (key & mask) >> offset;
            dna.append((char)BaseUtils.baseIndexToSimpleBase(baseIndex));
            mask <<= 2;
            offset += 2;
        }
        return dna.toString();
    }

    @Override
    public int maximumKeyValue() {
        int length;
        int key = length = Math.max(this.mismatchesContextSize, this.indelsContextSize);
        int bitOffset = 4;
        for (int i = 0; i < length; ++i) {
            key |= 3 << bitOffset;
            bitOffset += 2;
        }
        return key;
    }
}

