/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import net.sf.samtools.Cigar;
import net.sf.samtools.CigarElement;
import net.sf.samtools.CigarOperator;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.pileup.PileupElement;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.sam.GATKSAMRecord;

public final class AlignmentUtils {
    private static final EnumSet<CigarOperator> ALIGNED_TO_GENOME_OPERATORS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X);
    private static final EnumSet<CigarOperator> ALIGNED_TO_GENOME_PLUS_SOFTCLIPS = EnumSet.of(CigarOperator.M, CigarOperator.EQ, CigarOperator.X, CigarOperator.S);

    private AlignmentUtils() {
    }

    public static long mismatchingQualities(GATKSAMRecord r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount((GATKSAMRecord)r, (byte[])refSeq, (int)refIndex).mismatchQualities;
    }

    public static MismatchCount getMismatchCount(GATKSAMRecord r, byte[] refSeq, int refIndex) {
        return AlignmentUtils.getMismatchCount(r, refSeq, refIndex, 0, r.getReadLength());
    }

    @Ensures(value={"result != null"})
    public static MismatchCount getMismatchCount(GATKSAMRecord r, byte[] refSeq, int refIndex, int startOnRead, int nReadBases) {
        if (r == null) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count from a read that is null");
        }
        if (refSeq == null) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a reference sequence that is null");
        }
        if (refIndex < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a reference index that is negative");
        }
        if (startOnRead < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count with a read start that is negative");
        }
        if (nReadBases < 0) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count for a negative number of read bases");
        }
        if (refSeq.length - refIndex < r.getAlignmentEnd() - r.getAlignmentStart()) {
            throw new IllegalArgumentException("attempting to calculate the mismatch count against a reference string that is smaller than the read");
        }
        MismatchCount mc = new MismatchCount();
        int readIdx = 0;
        int endOnRead = startOnRead + nReadBases - 1;
        byte[] readSeq = r.getReadBases();
        Cigar c = r.getCigar();
        byte[] readQuals = r.getBaseQualities();
        block8: for (CigarElement ce : c.getCigarElements()) {
            if (readIdx > endOnRead) break;
            int elementLength = ce.getLength();
            block0 : switch (ce.getOperator()) {
                case X: {
                    int j;
                    mc.numMismatches += elementLength;
                    for (j = 0; j < elementLength; ++j) {
                        mc.mismatchQualities += (long)readQuals[readIdx + j];
                    }
                }
                case EQ: {
                    refIndex += elementLength;
                    readIdx += elementLength;
                    break;
                }
                case M: {
                    int j = 0;
                    while (j < elementLength) {
                        if (refIndex < refSeq.length && readIdx >= startOnRead) {
                            if (readIdx > endOnRead) break block0;
                            byte readChr = readSeq[readIdx];
                            byte refChr = refSeq[refIndex];
                            if (readChr != refChr) {
                                ++mc.numMismatches;
                                mc.mismatchQualities += (long)readQuals[readIdx];
                            }
                        }
                        ++j;
                        ++refIndex;
                        ++readIdx;
                    }
                    continue block8;
                }
                case I: 
                case S: {
                    readIdx += elementLength;
                    break;
                }
                case D: 
                case N: {
                    refIndex += elementLength;
                    break;
                }
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new ReviewedStingException("The " + (Object)((Object)ce.getOperator()) + " cigar element is not currently supported");
                }
            }
        }
        return mc;
    }

    @Ensures(value={"result >= 0"})
    public static int getNumAlignmentBlocks(SAMRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("read cannot be null");
        }
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        int n = 0;
        for (CigarElement e : cigar.getCigarElements()) {
            if (!ALIGNED_TO_GENOME_OPERATORS.contains((Object)e.getOperator())) continue;
            ++n;
        }
        return n;
    }

    public static int getNumAlignedBasesCountingSoftClips(GATKSAMRecord r) {
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (!ALIGNED_TO_GENOME_PLUS_SOFTCLIPS.contains((Object)e.getOperator())) continue;
            n += e.getLength();
        }
        return n;
    }

    @Ensures(value={"result >= 0"})
    public static int getNumHardClippedBases(SAMRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        int n = 0;
        Cigar cigar = r.getCigar();
        if (cigar == null) {
            return 0;
        }
        for (CigarElement e : cigar.getCigarElements()) {
            if (e.getOperator() != CigarOperator.H) continue;
            n += e.getLength();
        }
        return n;
    }

    @Ensures(value={"result >= 0"})
    public static int calcNumHighQualitySoftClips(GATKSAMRecord read, byte qualThreshold) {
        if (read == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        if (qualThreshold < 0) {
            throw new IllegalArgumentException("Expected qualThreshold to be a positive byte but saw " + qualThreshold);
        }
        if (read.getCigar() == null) {
            return 0;
        }
        byte[] qual = read.getBaseQualities(EventType.BASE_SUBSTITUTION);
        int numHQSoftClips = 0;
        int alignPos = 0;
        block5: for (CigarElement ce : read.getCigar().getCigarElements()) {
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case S: {
                    for (int jjj = 0; jjj < elementLength; ++jjj) {
                        if (qual[alignPos++] <= qualThreshold) continue;
                        ++numHQSoftClips;
                    }
                    continue block5;
                }
                case X: 
                case EQ: 
                case M: 
                case I: {
                    alignPos += elementLength;
                    break;
                }
                case D: 
                case N: 
                case H: 
                case P: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return numHQSoftClips;
    }

    public static int calcAlignmentByteArrayOffset(Cigar cigar, PileupElement pileupElement, int alignmentStart, int refLocus) {
        return AlignmentUtils.calcAlignmentByteArrayOffset(cigar, pileupElement.getOffset(), pileupElement.isDeletion(), alignmentStart, refLocus);
    }

    @Ensures(value={"result >= 0"})
    public static int calcAlignmentByteArrayOffset(Cigar cigar, int offset, boolean isDeletion, int alignmentStart, int refLocus) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to find the alignment position from a CIGAR that is null");
        }
        if (offset < -1) {
            throw new IllegalArgumentException("attempting to find the alignment position with an offset that is negative (and not -1)");
        }
        if (alignmentStart < 0) {
            throw new IllegalArgumentException("attempting to find the alignment position from an alignment start that is negative");
        }
        if (refLocus < 0) {
            throw new IllegalArgumentException("attempting to find the alignment position from a reference position that is negative");
        }
        if (offset >= cigar.getReadLength()) {
            throw new IllegalArgumentException("attempting to find the alignment position of an offset than is larger than the read length");
        }
        int pileupOffset = offset;
        if (isDeletion) {
            pileupOffset = refLocus - alignmentStart;
            CigarElement ce = cigar.getCigarElement(0);
            if (ce.getOperator() == CigarOperator.S) {
                pileupOffset += ce.getLength();
            }
        }
        int pos = 0;
        int alignmentPos = 0;
        block6: for (int iii = 0; iii < cigar.numCigarElements(); ++iii) {
            CigarElement ce = cigar.getCigarElement(iii);
            int elementLength = ce.getLength();
            switch (ce.getOperator()) {
                case I: 
                case S: {
                    if ((pos += elementLength) < pileupOffset) continue block6;
                    return alignmentPos;
                }
                case D: {
                    if (!isDeletion) {
                        alignmentPos += elementLength;
                        continue block6;
                    }
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case X: 
                case EQ: 
                case M: {
                    if (pos + elementLength - 1 >= pileupOffset) {
                        return alignmentPos + (pileupOffset - pos);
                    }
                    pos += elementLength;
                    alignmentPos += elementLength;
                    continue block6;
                }
                case N: 
                case H: 
                case P: {
                    continue block6;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)((Object)ce.getOperator()));
                }
            }
        }
        return alignmentPos;
    }

    /*
     * Unable to fully structure code
     */
    @Ensures(value={"result != null"})
    public static byte[] readToAlignmentByteArray(Cigar cigar, byte[] read) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to generate an alignment from a CIGAR that is null");
        }
        if (read == null) {
            throw new IllegalArgumentException("attempting to generate an alignment from a read sequence that is null");
        }
        alignmentLength = cigar.getReferenceLength();
        alignment = new byte[alignmentLength];
        alignPos = 0;
        readPos = 0;
        block7: for (iii = 0; iii < cigar.numCigarElements(); ++iii) {
            ce = cigar.getCigarElement(iii);
            elementLength = ce.getLength();
            switch (1.$SwitchMap$net$sf$samtools$CigarOperator[ce.getOperator().ordinal()]) {
                case 4: {
                    if (alignPos <= 0) ** GOTO lbl27
                    prevPos = alignPos - 1;
                    if (alignment[prevPos] != BaseUtils.Base.A.base) ** GOTO lbl19
                    alignment[prevPos] = 87;
                    ** GOTO lbl27
lbl19:
                    // 1 sources

                    if (alignment[prevPos] != BaseUtils.Base.C.base) ** GOTO lbl22
                    alignment[prevPos] = 88;
                    ** GOTO lbl27
lbl22:
                    // 1 sources

                    if (alignment[prevPos] != BaseUtils.Base.T.base) ** GOTO lbl25
                    alignment[prevPos] = 89;
                    ** GOTO lbl27
lbl25:
                    // 1 sources

                    if (alignment[prevPos] == BaseUtils.Base.G.base) {
                        alignment[prevPos] = 90;
                    }
                }
lbl27:
                // 8 sources

                case 5: {
                    readPos += elementLength;
                    continue block7;
                }
                case 6: 
                case 7: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos++] = PileupElement.DELETION_BASE;
                    }
                    continue block7;
                }
                case 1: 
                case 2: 
                case 3: {
                    for (jjj = 0; jjj < elementLength; ++jjj) {
                        alignment[alignPos++] = read[readPos++];
                    }
                    continue block7;
                }
                case 8: 
                case 9: {
                    continue block7;
                }
                default: {
                    throw new ReviewedStingException("Unsupported cigar operator: " + (Object)ce.getOperator());
                }
            }
        }
        return alignment;
    }

    public static boolean isReadGenomeLocUnmapped(SAMRecord r) {
        return "*".equals(r.getReferenceName());
    }

    public static boolean isReadUnmapped(SAMRecord r) {
        if (r == null) {
            throw new IllegalArgumentException("Read cannot be null");
        }
        return r.getReadUnmappedFlag() || (r.getReferenceIndex() == null || r.getReferenceIndex() == -1) && (r.getReferenceName() == null || r.getReferenceName().equals("*")) || r.getAlignmentStart() == 0;
    }

    @Ensures(value={"result != null"})
    public static Cigar consolidateCigar(Cigar c) {
        if (c == null) {
            throw new IllegalArgumentException("Cigar cannot be null");
        }
        if (c.isEmpty()) {
            return c;
        }
        Cigar returnCigar = new Cigar();
        int sumLength = 0;
        for (int iii = 0; iii < c.numCigarElements(); ++iii) {
            sumLength += c.getCigarElement(iii).getLength();
            if (iii != c.numCigarElements() - 1 && c.getCigarElement(iii).getOperator().equals((Object)c.getCigarElement(iii + 1).getOperator())) continue;
            returnCigar.add(new CigarElement(sumLength, c.getCigarElement(iii).getOperator()));
            sumLength = 0;
        }
        return returnCigar;
    }

    @Ensures(value={"result != null"})
    public static Cigar leftAlignIndel(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex, boolean doNotThrowExceptionForMultipleIndels) {
        AlignmentUtils.ensureLeftAlignmentHasGoodArguments(cigar, refSeq, readSeq, refIndex, readIndex);
        int numIndels = AlignmentUtils.countIndelElements(cigar);
        if (numIndels == 0) {
            return cigar;
        }
        if (numIndels == 1) {
            return AlignmentUtils.leftAlignSingleIndel(cigar, refSeq, readSeq, refIndex, readIndex);
        }
        if (doNotThrowExceptionForMultipleIndels) {
            return cigar;
        }
        throw new UnsupportedOperationException("attempting to left align a CIGAR that has more than 1 indel in its alignment but this functionality has not been implemented yet");
    }

    private static void ensureLeftAlignmentHasGoodArguments(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        if (cigar == null) {
            throw new IllegalArgumentException("attempting to left align a CIGAR that is null");
        }
        if (refSeq == null) {
            throw new IllegalArgumentException("attempting to left align a reference sequence that is null");
        }
        if (readSeq == null) {
            throw new IllegalArgumentException("attempting to left align a read sequence that is null");
        }
        if (refIndex < 0) {
            throw new IllegalArgumentException("attempting to left align with a reference index less than 0");
        }
        if (readIndex < 0) {
            throw new IllegalArgumentException("attempting to left align with a read index less than 0");
        }
    }

    @Requires(value={"cigar != null"})
    @Ensures(value={"result >= 0"})
    private static int countIndelElements(Cigar cigar) {
        int indelCount = 0;
        for (CigarElement ce : cigar.getCigarElements()) {
            if (ce.getOperator() != CigarOperator.D && ce.getOperator() != CigarOperator.I) continue;
            ++indelCount;
        }
        return indelCount;
    }

    @Ensures(value={"result != null"})
    public static Cigar leftAlignSingleIndel(Cigar cigar, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        AlignmentUtils.ensureLeftAlignmentHasGoodArguments(cigar, refSeq, readSeq, refIndex, readIndex);
        int indexOfIndel = -1;
        for (int i = 0; i < cigar.numCigarElements(); ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            if (ce.getOperator() != CigarOperator.D && ce.getOperator() != CigarOperator.I) continue;
            if (indexOfIndel != -1) {
                throw new IllegalArgumentException("attempting to left align a CIGAR that has more than 1 indel in its alignment");
            }
            indexOfIndel = i;
        }
        if (indexOfIndel == -1) {
            throw new IllegalArgumentException("attempting to left align a CIGAR that has no indels in its alignment");
        }
        if (indexOfIndel == 0) {
            return cigar;
        }
        int indelLength = cigar.getCigarElement(indexOfIndel).getLength();
        byte[] altString = AlignmentUtils.createIndelString(cigar, indexOfIndel, refSeq, readSeq, refIndex, readIndex);
        if (altString == null) {
            return cigar;
        }
        Cigar newCigar = cigar;
        for (int i = 0; i < indelLength; ++i) {
            newCigar = AlignmentUtils.moveCigarLeft(newCigar, indexOfIndel);
            byte[] newAltString = AlignmentUtils.createIndelString(newCigar, indexOfIndel, refSeq, readSeq, refIndex, readIndex);
            boolean reachedEndOfRead = AlignmentUtils.cigarHasZeroSizeElement(newCigar);
            if (Arrays.equals(altString, newAltString)) {
                cigar = newCigar;
                i = -1;
                if (reachedEndOfRead) {
                    cigar = AlignmentUtils.cleanUpCigar(cigar);
                }
            }
            if (reachedEndOfRead) break;
        }
        return cigar;
    }

    @Requires(value={"c != null"})
    protected static boolean cigarHasZeroSizeElement(Cigar c) {
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getLength() != 0) continue;
            return true;
        }
        return false;
    }

    @Requires(value={"c != null"})
    @Ensures(value={"result != null"})
    private static Cigar cleanUpCigar(Cigar c) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(c.numCigarElements() - 1);
        for (CigarElement ce : c.getCigarElements()) {
            if (ce.getLength() == 0 || elements.isEmpty() && ce.getOperator() == CigarOperator.D) continue;
            elements.add(ce);
        }
        return new Cigar(elements);
    }

    @Requires(value={"cigar != null && indexOfIndel >= 0 && indexOfIndel < cigar.numCigarElements()"})
    @Ensures(value={"result != null"})
    private static Cigar moveCigarLeft(Cigar cigar, int indexOfIndel) {
        ArrayList<CigarElement> elements = new ArrayList<CigarElement>(cigar.numCigarElements());
        for (int i = 0; i < indexOfIndel - 1; ++i) {
            elements.add(cigar.getCigarElement(i));
        }
        CigarElement ce = cigar.getCigarElement(indexOfIndel - 1);
        elements.add(new CigarElement(Math.max(ce.getLength() - 1, 0), ce.getOperator()));
        elements.add(cigar.getCigarElement(indexOfIndel));
        if (indexOfIndel + 1 < cigar.numCigarElements()) {
            ce = cigar.getCigarElement(indexOfIndel + 1);
            elements.add(new CigarElement(ce.getLength() + 1, ce.getOperator()));
        } else {
            elements.add(new CigarElement(1, CigarOperator.M));
        }
        for (int i = indexOfIndel + 2; i < cigar.numCigarElements(); ++i) {
            elements.add(cigar.getCigarElement(i));
        }
        return new Cigar(elements);
    }

    @Requires(value={"cigar != null && indexOfIndel >= 0 && indexOfIndel < cigar.numCigarElements() && refSeq != null && readSeq != null && refIndex >= 0 && readIndex >= 0"})
    @Ensures(value={"result != null"})
    private static byte[] createIndelString(Cigar cigar, int indexOfIndel, byte[] refSeq, byte[] readSeq, int refIndex, int readIndex) {
        byte[] alt;
        CigarElement indel = cigar.getCigarElement(indexOfIndel);
        int indelLength = indel.getLength();
        int totalRefBases = 0;
        block5: for (int i = 0; i < indexOfIndel; ++i) {
            CigarElement ce = cigar.getCigarElement(i);
            int length = ce.getLength();
            switch (ce.getOperator()) {
                case X: 
                case EQ: 
                case M: {
                    readIndex += length;
                    refIndex += length;
                    totalRefBases += length;
                    continue block5;
                }
                case S: {
                    readIndex += length;
                    continue block5;
                }
                case N: {
                    refIndex += length;
                    totalRefBases += length;
                    continue block5;
                }
            }
        }
        if (totalRefBases + indelLength > refSeq.length) {
            indelLength -= totalRefBases + indelLength - refSeq.length;
        }
        if (refIndex > (alt = new byte[refSeq.length + indelLength * (indel.getOperator() == CigarOperator.D ? -1 : 1)]).length || refIndex > refSeq.length) {
            return null;
        }
        System.arraycopy(refSeq, 0, alt, 0, refIndex);
        int currentPos = refIndex;
        if (indel.getOperator() == CigarOperator.D) {
            refIndex += indelLength;
        } else {
            System.arraycopy(readSeq, readIndex, alt, currentPos, indelLength);
            currentPos += indelLength;
        }
        if (refSeq.length - refIndex > alt.length - currentPos) {
            return null;
        }
        System.arraycopy(refSeq, refIndex, alt, currentPos, refSeq.length - refIndex);
        return alt;
    }

    public static class MismatchCount {
        public int numMismatches = 0;
        public long mismatchQualities = 0L;
    }
}

