/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.sam;

import net.sf.samtools.SAMReadGroupRecord;
import org.broadinstitute.sting.utils.NGSPlatform;

public class GATKSAMReadGroupRecord
extends SAMReadGroupRecord {
    private String mSample = null;
    private String mPlatform = null;
    private NGSPlatform mNGSPlatform = null;
    private boolean retrievedSample = false;
    private boolean retrievedPlatform = false;
    private boolean retrievedNGSPlatform = false;

    public GATKSAMReadGroupRecord(String id) {
        super(id);
    }

    public GATKSAMReadGroupRecord(SAMReadGroupRecord record) {
        super(record.getReadGroupId(), record);
    }

    public NGSPlatform getNGSPlatform() {
        if (!this.retrievedNGSPlatform) {
            this.mNGSPlatform = NGSPlatform.fromReadGroupPL(this.getPlatform());
            this.retrievedNGSPlatform = true;
        }
        return this.mNGSPlatform;
    }

    @Override
    public String getSample() {
        if (!this.retrievedSample) {
            this.mSample = super.getSample();
            this.retrievedSample = true;
        }
        return this.mSample;
    }

    @Override
    public void setSample(String s) {
        super.setSample(s);
        this.mSample = s;
        this.retrievedSample = true;
    }

    @Override
    public String getPlatform() {
        if (!this.retrievedPlatform) {
            this.mPlatform = super.getPlatform();
            this.retrievedPlatform = true;
        }
        return this.mPlatform;
    }

    @Override
    public void setPlatform(String s) {
        super.setPlatform(s);
        this.mPlatform = s;
        this.retrievedPlatform = true;
        this.retrievedNGSPlatform = false;
    }
}

