/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variant;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import org.broad.tribble.TribbleException;
import org.broad.tribble.util.popgen.HardyWeinbergCalculation;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.variant.variantcontext.Allele;
import org.broadinstitute.variant.variantcontext.CommonInfo;
import org.broadinstitute.variant.variantcontext.Genotype;
import org.broadinstitute.variant.variantcontext.GenotypeBuilder;
import org.broadinstitute.variant.variantcontext.GenotypeLikelihoods;
import org.broadinstitute.variant.variantcontext.GenotypesContext;
import org.broadinstitute.variant.variantcontext.VariantContext;
import org.broadinstitute.variant.variantcontext.VariantContextBuilder;
import org.broadinstitute.variant.variantcontext.VariantContextUtils;

public class GATKVariantContextUtils {
    private static Logger logger = Logger.getLogger(GATKVariantContextUtils.class);
    public static final int DEFAULT_PLOIDY = 2;
    public static final double SUM_GL_THRESH_NOCALL = -0.1;
    private static final List<Allele> NO_CALL_ALLELES = Arrays.asList(Allele.NO_CALL, Allele.NO_CALL);
    public static final String MERGE_FILTER_PREFIX = "filterIn";
    public static final String MERGE_REF_IN_ALL = "ReferenceInAll";
    public static final String MERGE_FILTER_IN_ALL = "FilteredInAll";
    public static final String MERGE_INTERSECTION = "Intersection";

    public static final GenomeLoc getLocation(GenomeLocParser genomeLocParser, VariantContext vc) {
        return genomeLocParser.createGenomeLoc(vc.getChr(), vc.getStart(), vc.getEnd(), true);
    }

    public static BaseUtils.BaseSubstitutionType getSNPSubstitutionType(VariantContext context) {
        if (!context.isSNP() || !context.isBiallelic()) {
            throw new IllegalStateException("Requested SNP substitution type for bialleic non-SNP " + context);
        }
        return BaseUtils.SNPSubstitutionType(context.getReference().getBases()[0], context.getAlternateAllele(0).getBases()[0]);
    }

    public static boolean isTransition(VariantContext context) {
        return GATKVariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSITION;
    }

    public static boolean isTransversion(VariantContext context) {
        return GATKVariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSVERSION;
    }

    public static boolean isTransition(Allele ref, Allele alt) {
        return BaseUtils.SNPSubstitutionType(ref.getBases()[0], alt.getBases()[0]) == BaseUtils.BaseSubstitutionType.TRANSITION;
    }

    public static boolean isTransversion(Allele ref, Allele alt) {
        return BaseUtils.SNPSubstitutionType(ref.getBases()[0], alt.getBases()[0]) == BaseUtils.BaseSubstitutionType.TRANSVERSION;
    }

    public static VariantContext reverseComplement(VariantContext vc) {
        HashMap<Allele, Allele> alleleMap = new HashMap<Allele, Allele>(vc.getAlleles().size());
        for (Allele originalAllele : vc.getAlleles()) {
            Allele newAllele = originalAllele.isNoCall() ? originalAllele : Allele.create(BaseUtils.simpleReverseComplement(originalAllele.getBases()), originalAllele.isReference());
            alleleMap.put(originalAllele, newAllele);
        }
        GenotypesContext newGenotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            for (Allele allele : genotype.getAlleles()) {
                Allele newAllele = (Allele)alleleMap.get(allele);
                if (newAllele == null) {
                    newAllele = Allele.NO_CALL;
                }
                newAlleles.add(newAllele);
            }
            newGenotypes.add(new GenotypeBuilder(genotype).alleles(newAlleles).make());
        }
        return new VariantContextBuilder(vc).alleles(alleleMap.values()).genotypes(newGenotypes).make();
    }

    @Requires(value={"vc != null", "refBasesStartingAtVCWithPad != null && refBasesStartingAtVCWithPad.length > 0"})
    public static boolean isTandemRepeat(VariantContext vc, byte[] refBasesStartingAtVCWithPad) {
        String refBasesStartingAtVCWithoutPad = new String(refBasesStartingAtVCWithPad).substring(1);
        if (!vc.isIndel()) {
            return false;
        }
        Allele ref = vc.getReference();
        for (Allele allele : vc.getAlternateAlleles()) {
            if (GATKVariantContextUtils.isRepeatAllele(ref, allele, refBasesStartingAtVCWithoutPad)) continue;
            return false;
        }
        return true;
    }

    @Requires(value={"vc != null", "refBasesStartingAtVCWithPad != null && refBasesStartingAtVCWithPad.length > 0"})
    public static Pair<List<Integer>, byte[]> getNumTandemRepeatUnits(VariantContext vc, byte[] refBasesStartingAtVCWithPad) {
        boolean VERBOSE = false;
        String refBasesStartingAtVCWithoutPad = new String(refBasesStartingAtVCWithPad).substring(1);
        if (!vc.isIndel()) {
            return null;
        }
        Allele refAllele = vc.getReference();
        byte[] refAlleleBases = Arrays.copyOfRange(refAllele.getBases(), 1, refAllele.length());
        byte[] repeatUnit = null;
        ArrayList<Integer> lengths = new ArrayList<Integer>();
        for (Allele allele : vc.getAlternateAlleles()) {
            Pair<int[], byte[]> result = GATKVariantContextUtils.getNumTandemRepeatUnits(refAlleleBases, Arrays.copyOfRange(allele.getBases(), 1, allele.length()), refBasesStartingAtVCWithoutPad.getBytes());
            int[] repetitionCount = (int[])result.first;
            if (repetitionCount[0] == 0 || repetitionCount[1] == 0) {
                return null;
            }
            if (lengths.size() == 0) {
                lengths.add(repetitionCount[0]);
            }
            lengths.add(repetitionCount[1]);
            repeatUnit = (byte[])result.second;
        }
        return new Pair(lengths, repeatUnit);
    }

    public static Pair<int[], byte[]> getNumTandemRepeatUnits(byte[] refBases, byte[] altBases, byte[] remainingRefContext) {
        byte[] longB = altBases.length > refBases.length ? altBases : refBases;
        int repeatUnitLength = GATKVariantContextUtils.findRepeatedSubstring(longB);
        byte[] repeatUnit = Arrays.copyOf(longB, repeatUnitLength);
        int[] repetitionCount = new int[2];
        int repetitionsInRef = GATKVariantContextUtils.findNumberofRepetitions(repeatUnit, refBases, true);
        repetitionCount[0] = GATKVariantContextUtils.findNumberofRepetitions(repeatUnit, ArrayUtils.addAll(refBases, remainingRefContext), true) - repetitionsInRef;
        repetitionCount[1] = GATKVariantContextUtils.findNumberofRepetitions(repeatUnit, ArrayUtils.addAll(altBases, remainingRefContext), true) - repetitionsInRef;
        return new Pair<int[], byte[]>(repetitionCount, repeatUnit);
    }

    public static int findRepeatedSubstring(byte[] bases) {
        int repLength;
        for (repLength = 1; repLength <= bases.length; ++repLength) {
            byte[] candidateRepeatUnit = Arrays.copyOf(bases, repLength);
            boolean allBasesMatch = true;
            for (int start = repLength; start < bases.length; start += repLength) {
                byte[] basePiece = Arrays.copyOfRange(bases, start, start + candidateRepeatUnit.length);
                if (Arrays.equals(candidateRepeatUnit, basePiece)) continue;
                allBasesMatch = false;
                break;
            }
            if (!allBasesMatch) continue;
            return repLength;
        }
        return repLength;
    }

    public static int findNumberofRepetitions(byte[] repeatUnit, byte[] testString, boolean lookForward) {
        int end;
        byte[] unit;
        int numRepeats = 0;
        if (lookForward) {
            int end2;
            byte[] unit2;
            for (int start = 0; start < testString.length && Arrays.equals(unit2 = Arrays.copyOfRange(testString, start, end2 = start + repeatUnit.length), repeatUnit); start += repeatUnit.length) {
                ++numRepeats;
            }
            return numRepeats;
        }
        for (int start = testString.length - repeatUnit.length; start >= 0 && Arrays.equals(unit = Arrays.copyOfRange(testString, start, end = start + repeatUnit.length), repeatUnit); start -= repeatUnit.length) {
            ++numRepeats;
        }
        return numRepeats;
    }

    protected static boolean isRepeatAllele(Allele ref, Allele alt, String refBasesStartingAtVCWithoutPad) {
        if (!Allele.oneIsPrefixOfOther(ref, alt)) {
            return false;
        }
        if (ref.length() > alt.length()) {
            return GATKVariantContextUtils.basesAreRepeated(ref.getBaseString(), alt.getBaseString(), refBasesStartingAtVCWithoutPad, 2);
        }
        return GATKVariantContextUtils.basesAreRepeated(alt.getBaseString(), ref.getBaseString(), refBasesStartingAtVCWithoutPad, 1);
    }

    protected static boolean basesAreRepeated(String l, String s, String ref, int minNumberOfMatches) {
        String potentialRepeat = l.substring(s.length());
        for (int i = 0; i < minNumberOfMatches; ++i) {
            int start = i * potentialRepeat.length();
            int end = (i + 1) * potentialRepeat.length();
            if (ref.length() < end) {
                return false;
            }
            String refSub = ref.substring(start, end);
            if (refSub.equals(potentialRepeat)) continue;
            return false;
        }
        return true;
    }

    public static GenotypesContext subsetDiploidAlleles(VariantContext vc, List<Allele> allelesToUse, boolean assignGenotypes) {
        GenotypesContext oldGTs = vc.getGenotypes();
        List<String> sampleIndices = oldGTs.getSampleNamesOrderedByName();
        GenotypesContext newGTs = GenotypesContext.create();
        int numOriginalAltAlleles = vc.getAlternateAlleles().size();
        int numNewAltAlleles = allelesToUse.size() - 1;
        ArrayList<Integer> likelihoodIndexesToUse = null;
        if (numNewAltAlleles != numOriginalAltAlleles && numNewAltAlleles > 0) {
            likelihoodIndexesToUse = new ArrayList<Integer>(30);
            boolean[] altAlleleIndexToUse = new boolean[numOriginalAltAlleles];
            for (int i = 0; i < numOriginalAltAlleles; ++i) {
                if (!allelesToUse.contains(vc.getAlternateAllele(i))) continue;
                altAlleleIndexToUse[i] = true;
            }
            int numLikelihoods = GenotypeLikelihoods.numLikelihoods(1 + numOriginalAltAlleles, 2);
            for (int PLindex = 0; PLindex < numLikelihoods; ++PLindex) {
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
                if (alleles.alleleIndex1 != 0 && !altAlleleIndexToUse[alleles.alleleIndex1 - 1] || alleles.alleleIndex2 != 0 && !altAlleleIndexToUse[alleles.alleleIndex2 - 1]) continue;
                likelihoodIndexesToUse.add(PLindex);
            }
        }
        for (int k = 0; k < oldGTs.size(); ++k) {
            double[] newLikelihoods;
            Genotype g = oldGTs.get(sampleIndices.get(k));
            if (!g.hasLikelihoods()) {
                newGTs.add(GenotypeBuilder.create(g.getSampleName(), NO_CALL_ALLELES));
                continue;
            }
            double[] originalLikelihoods = g.getLikelihoods().getAsVector();
            if (likelihoodIndexesToUse == null) {
                newLikelihoods = originalLikelihoods;
            } else {
                newLikelihoods = new double[likelihoodIndexesToUse.size()];
                int newIndex = 0;
                Iterator i$ = likelihoodIndexesToUse.iterator();
                while (i$.hasNext()) {
                    int oldIndex = (Integer)i$.next();
                    newLikelihoods[newIndex++] = originalLikelihoods[oldIndex];
                }
                newLikelihoods = MathUtils.normalizeFromLog10(newLikelihoods, false, true);
            }
            if (MathUtils.sum(newLikelihoods) > -0.1) {
                newGTs.add(GenotypeBuilder.create(g.getSampleName(), NO_CALL_ALLELES));
                continue;
            }
            GenotypeBuilder gb = new GenotypeBuilder(g);
            if (numNewAltAlleles == 0) {
                gb.noPL();
            } else {
                gb.PL(newLikelihoods);
            }
            if (!assignGenotypes || MathUtils.sum(newLikelihoods) > -0.1) {
                gb.alleles(NO_CALL_ALLELES);
            } else {
                int PLindex = numNewAltAlleles == 0 ? 0 : MathUtils.maxElementIndex(newLikelihoods);
                GenotypeLikelihoods.GenotypeLikelihoodsAllelePair alleles = GenotypeLikelihoods.getAllelePair(PLindex);
                gb.alleles(Arrays.asList(allelesToUse.get(alleles.alleleIndex1), allelesToUse.get(alleles.alleleIndex2)));
                if (numNewAltAlleles != 0) {
                    gb.log10PError(GenotypeLikelihoods.getGQLog10FromLikelihoods(PLindex, newLikelihoods));
                }
            }
            newGTs.add(gb.make());
        }
        return newGTs;
    }

    public static GenotypesContext assignDiploidGenotypes(VariantContext vc) {
        return GATKVariantContextUtils.subsetDiploidAlleles(vc, vc.getAlleles(), true);
    }

    public static List<VariantContext> splitVariantContextToBiallelics(VariantContext vc) {
        return GATKVariantContextUtils.splitVariantContextToBiallelics(vc, false);
    }

    public static List<VariantContext> splitVariantContextToBiallelics(VariantContext vc, boolean trimLeft) {
        if (!vc.isVariant() || vc.isBiallelic()) {
            return Collections.singletonList(vc);
        }
        LinkedList<VariantContext> biallelics = new LinkedList<VariantContext>();
        for (Allele alt : vc.getAlternateAlleles()) {
            VariantContextBuilder builder = new VariantContextBuilder(vc);
            List<Allele> alleles = Arrays.asList(vc.getReference(), alt);
            builder.alleles((Collection<Allele>)alleles);
            builder.genotypes(GATKVariantContextUtils.subsetDiploidAlleles(vc, alleles, false));
            VariantContextUtils.calculateChromosomeCounts(builder, true);
            VariantContext trimmed = GATKVariantContextUtils.trimAlleles(builder.make(), trimLeft, true);
            biallelics.add(trimmed);
        }
        return biallelics;
    }

    public static Genotype removePLsAndAD(Genotype g) {
        return g.hasLikelihoods() || g.hasAD() ? new GenotypeBuilder(g).noPL().noAD().make() : g;
    }

    public static VariantContext simpleMerge(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean annotateOrigin, boolean printMessages, String setKey, boolean filteredAreUncalled, boolean mergeInfoWithMaxAC) {
        int originalNumOfVCs = priorityListOfVCs == null ? 0 : priorityListOfVCs.size();
        return GATKVariantContextUtils.simpleMerge(unsortedVCs, priorityListOfVCs, originalNumOfVCs, filteredRecordMergeType, genotypeMergeOptions, annotateOrigin, printMessages, setKey, filteredAreUncalled, mergeInfoWithMaxAC);
    }

    public static VariantContext simpleMerge(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, int originalNumOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean annotateOrigin, boolean printMessages, String setKey, boolean filteredAreUncalled, boolean mergeInfoWithMaxAC) {
        if (unsortedVCs == null || unsortedVCs.size() == 0) {
            return null;
        }
        if (priorityListOfVCs != null && originalNumOfVCs != priorityListOfVCs.size()) {
            throw new IllegalArgumentException("the number of the original VariantContexts must be the same as the number of VariantContexts in the priority list");
        }
        if (annotateOrigin && priorityListOfVCs == null && originalNumOfVCs == 0) {
            throw new IllegalArgumentException("Cannot merge calls and annotate their origins without a complete priority list of VariantContexts or the number of original VariantContexts");
        }
        List<VariantContext> preFilteredVCs = GATKVariantContextUtils.sortVariantContextsByPriority(unsortedVCs, priorityListOfVCs, genotypeMergeOptions);
        ArrayList<VariantContext> VCs = new ArrayList<VariantContext>();
        for (VariantContext vc : preFilteredVCs) {
            if (filteredAreUncalled && !vc.isNotFiltered()) continue;
            VCs.add(vc);
        }
        if (VCs.size() == 0) {
            return null;
        }
        VariantContext first = (VariantContext)VCs.get(0);
        String name = first.getSource();
        Allele refAllele = GATKVariantContextUtils.determineReferenceAllele(VCs);
        LinkedHashSet<Allele> alleles = new LinkedHashSet<Allele>();
        HashSet<String> filters = new HashSet<String>();
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        HashSet<String> inconsistentAttributes = new HashSet<String>();
        HashSet<String> variantSources = new HashSet<String>();
        LinkedHashSet<String> rsIDs = new LinkedHashSet<String>(1);
        VariantContext longestVC = first;
        int depth = 0;
        int maxAC = -1;
        LinkedHashMap<String, Object> attributesWithMaxAC = new LinkedHashMap<String, Object>();
        double log10PError = 1.0;
        VariantContext vcWithMaxAC = null;
        GenotypesContext genotypes = GenotypesContext.create();
        int nFiltered = 0;
        boolean remapped = false;
        for (VariantContext vc : VCs) {
            if (longestVC.getStart() != vc.getStart()) {
                throw new IllegalStateException("BUG: attempting to merge VariantContexts with different start sites: first=" + first.toString() + " second=" + vc.toString());
            }
            if (VariantContextUtils.getSize(vc) > VariantContextUtils.getSize(longestVC)) {
                longestVC = vc;
            }
            nFiltered += vc.isFiltered() ? 1 : 0;
            if (vc.isVariant()) {
                variantSources.add(vc.getSource());
            }
            AlleleMapper alleleMapping = GATKVariantContextUtils.resolveIncompatibleAlleles(refAllele, vc, alleles);
            remapped = remapped || alleleMapping.needsRemapping();
            alleles.addAll(alleleMapping.values());
            GATKVariantContextUtils.mergeGenotypes(genotypes, vc, alleleMapping, genotypeMergeOptions == GenotypeMergeType.UNIQUIFY);
            if (log10PError == 1.0) {
                log10PError = vc.getLog10PError();
            }
            filters.addAll(vc.getFilters());
            if (vc.hasAttribute("DP")) {
                depth += vc.getAttributeAsInt("DP", 0);
            }
            if (vc.hasID()) {
                rsIDs.add(vc.getID());
            }
            if (mergeInfoWithMaxAC && vc.hasAttribute("AC")) {
                String rawAlleleCounts = vc.getAttributeAsString("AC", null);
                if (rawAlleleCounts.contains(",")) {
                    List<String> alleleCountArray = Arrays.asList(rawAlleleCounts.substring(1, rawAlleleCounts.length() - 1).split(","));
                    for (String alleleCount : alleleCountArray) {
                        int ac = Integer.valueOf(alleleCount.trim());
                        if (ac <= maxAC) continue;
                        maxAC = ac;
                        vcWithMaxAC = vc;
                    }
                } else {
                    int ac = Integer.valueOf(rawAlleleCounts);
                    if (ac > maxAC) {
                        maxAC = ac;
                        vcWithMaxAC = vc;
                    }
                }
            }
            for (Map.Entry<String, Object> p : vc.getAttributes().entrySet()) {
                boolean boundIsMissingValue;
                String key = p.getKey();
                if (inconsistentAttributes.contains(key)) continue;
                boolean alreadyFound = attributes.containsKey(key);
                Object boundValue = attributes.get(key);
                boolean bl = boundIsMissingValue = alreadyFound && boundValue.equals(".");
                if (alreadyFound && !boundValue.equals(p.getValue()) && !boundIsMissingValue) {
                    inconsistentAttributes.add(key);
                    attributes.remove(key);
                    continue;
                }
                if (alreadyFound && !boundIsMissingValue) continue;
                attributes.put(key, p.getValue());
            }
        }
        for (VariantContext vc : VCs) {
            if (vc.getAlleles().size() == 1 || !GATKVariantContextUtils.hasPLIncompatibleAlleles(alleles, vc.getAlleles())) continue;
            if (!genotypes.isEmpty()) {
                logger.debug(String.format("Stripping PLs at %s:%d-%d due to incompatible alleles merged=%s vs. single=%s", vc.getChr(), vc.getStart(), vc.getEnd(), alleles, vc.getAlleles()));
            }
            genotypes = GATKVariantContextUtils.stripPLsAndAD(genotypes);
            VariantContextUtils.calculateChromosomeCounts(vc, attributes, true);
            break;
        }
        if (mergeInfoWithMaxAC && vcWithMaxAC != null) {
            attributesWithMaxAC.putAll(vcWithMaxAC.getAttributes());
        }
        if (filteredRecordMergeType == FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED && nFiltered != VCs.size() || filteredRecordMergeType == FilteredRecordMergeType.KEEP_UNCONDITIONAL) {
            filters.clear();
        }
        if (annotateOrigin) {
            String setValue;
            if (nFiltered == 0 && variantSources.size() == originalNumOfVCs) {
                setValue = MERGE_INTERSECTION;
            } else if (nFiltered == VCs.size()) {
                setValue = MERGE_FILTER_IN_ALL;
            } else if (variantSources.isEmpty()) {
                setValue = MERGE_REF_IN_ALL;
            } else {
                LinkedHashSet<String> s = new LinkedHashSet<String>();
                for (VariantContext vc : VCs) {
                    if (!vc.isVariant()) continue;
                    s.add(vc.isFiltered() ? MERGE_FILTER_PREFIX + vc.getSource() : vc.getSource());
                }
                setValue = Utils.join("-", s);
            }
            if (setKey != null) {
                attributes.put(setKey, setValue);
                if (mergeInfoWithMaxAC && vcWithMaxAC != null) {
                    attributesWithMaxAC.put(setKey, setValue);
                }
            }
        }
        if (depth > 0) {
            attributes.put("DP", String.valueOf(depth));
        }
        String ID = rsIDs.isEmpty() ? "." : Utils.join(",", rsIDs);
        VariantContextBuilder builder = new VariantContextBuilder().source(name).id(ID);
        builder.loc(longestVC.getChr(), longestVC.getStart(), longestVC.getEnd());
        builder.alleles(alleles);
        builder.genotypes(genotypes);
        builder.log10PError(log10PError);
        builder.filters(filters.isEmpty() ? filters : new TreeSet(filters));
        builder.attributes(new TreeMap<String, Object>(mergeInfoWithMaxAC ? attributesWithMaxAC : attributes));
        VariantContext merged = builder.make();
        if (printMessages && remapped) {
            System.out.printf("Remapped => %s%n", merged);
        }
        return merged;
    }

    private static final boolean hasPLIncompatibleAlleles(Collection<Allele> alleleSet1, Collection<Allele> alleleSet2) {
        Iterator<Allele> it1 = alleleSet1.iterator();
        Iterator<Allele> it2 = alleleSet2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Allele a2;
            Allele a1 = it1.next();
            if (a1.equals(a2 = it2.next())) continue;
            return true;
        }
        return it1.hasNext() || it2.hasNext();
    }

    public static GenotypesContext stripPLsAndAD(GenotypesContext genotypes) {
        GenotypesContext newGs = GenotypesContext.create(genotypes.size());
        for (Genotype g : genotypes) {
            newGs.add(GATKVariantContextUtils.removePLsAndAD(g));
        }
        return newGs;
    }

    private static Allele determineReferenceAllele(List<VariantContext> VCs) {
        Allele ref = null;
        for (VariantContext vc : VCs) {
            Allele myRef = vc.getReference();
            if (ref == null || ref.length() < myRef.length()) {
                ref = myRef;
                continue;
            }
            if (ref.length() != myRef.length() || ref.equals(myRef)) continue;
            throw new TribbleException(String.format("The provided variant file(s) have inconsistent references for the same position(s) at %s:%d, %s vs. %s", vc.getChr(), vc.getStart(), ref, myRef));
        }
        return ref;
    }

    private static AlleleMapper resolveIncompatibleAlleles(Allele refAllele, VariantContext vc, Set<Allele> allAlleles) {
        if (refAllele.equals(vc.getReference())) {
            return new AlleleMapper(vc);
        }
        Allele myRef = vc.getReference();
        if (refAllele.length() <= myRef.length()) {
            throw new IllegalStateException("BUG: myRef=" + myRef + " is longer than refAllele=" + refAllele);
        }
        byte[] extraBases = Arrays.copyOfRange(refAllele.getBases(), myRef.length(), refAllele.length());
        HashMap<Allele, Allele> map = new HashMap<Allele, Allele>();
        for (Allele a : vc.getAlleles()) {
            if (a.isReference()) {
                map.put(a, refAllele);
                continue;
            }
            Allele extended = Allele.extend(a, extraBases);
            for (Allele b : allAlleles) {
                if (!extended.equals(b)) continue;
                extended = b;
            }
            map.put(a, extended);
        }
        return new AlleleMapper(map);
    }

    public static List<VariantContext> sortVariantContextsByPriority(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, GenotypeMergeType mergeOption) {
        if (mergeOption == GenotypeMergeType.PRIORITIZE && priorityListOfVCs == null) {
            throw new IllegalArgumentException("Cannot merge calls by priority with a null priority list");
        }
        if (priorityListOfVCs == null || mergeOption == GenotypeMergeType.UNSORTED) {
            return new ArrayList<VariantContext>(unsortedVCs);
        }
        ArrayList<VariantContext> sorted = new ArrayList<VariantContext>(unsortedVCs);
        Collections.sort(sorted, new CompareByPriority(priorityListOfVCs));
        return sorted;
    }

    private static void mergeGenotypes(GenotypesContext mergedGenotypes, VariantContext oneVC, AlleleMapper alleleMapping, boolean uniqifySamples) {
        for (Genotype g : oneVC.getGenotypes()) {
            String name = GATKVariantContextUtils.mergedSampleName(oneVC.getSource(), g.getSampleName(), uniqifySamples);
            if (mergedGenotypes.containsSample(name)) continue;
            Genotype newG = g;
            if (uniqifySamples || alleleMapping.needsRemapping()) {
                List<Allele> alleles = alleleMapping.needsRemapping() ? alleleMapping.remap(g.getAlleles()) : g.getAlleles();
                newG = new GenotypeBuilder(g).name(name).alleles(alleles).make();
            }
            mergedGenotypes.add(newG);
        }
    }

    public static String mergedSampleName(String trackName, String sampleName, boolean uniqify) {
        return uniqify ? sampleName + "." + trackName : sampleName;
    }

    public static VariantContext reverseTrimAlleles(VariantContext inputVC) {
        return GATKVariantContextUtils.trimAlleles(inputVC, false, true);
    }

    public static VariantContext forwardTrimAlleles(VariantContext inputVC) {
        return GATKVariantContextUtils.trimAlleles(inputVC, true, false);
    }

    @Ensures(value={"result != null"})
    public static VariantContext trimAlleles(VariantContext inputVC, boolean trimForward, boolean trimReverse) {
        if (inputVC == null) {
            throw new IllegalArgumentException("inputVC cannot be null");
        }
        if (inputVC.getNAlleles() <= 1) {
            return inputVC;
        }
        int revTrim = trimReverse ? GATKVariantContextUtils.computeReverseClipping(inputVC.getAlleles(), inputVC.getReference().getDisplayString().getBytes()) : 0;
        VariantContext revTrimVC = GATKVariantContextUtils.trimAlleles(inputVC, -1, revTrim);
        int fwdTrim = trimForward ? GATKVariantContextUtils.computeForwardClipping(revTrimVC.getAlleles()) : -1;
        return GATKVariantContextUtils.trimAlleles(revTrimVC, fwdTrim, 0);
    }

    @Requires(value={"inputVC != null"})
    @Ensures(value={"result != null"})
    protected static VariantContext trimAlleles(VariantContext inputVC, int fwdTrimEnd, int revTrim) {
        if (fwdTrimEnd == -1 && revTrim == 0) {
            return inputVC;
        }
        LinkedList<Allele> alleles = new LinkedList<Allele>();
        GenotypesContext genotypes = GenotypesContext.create();
        HashMap<Allele, Allele> originalToTrimmedAlleleMap = new HashMap<Allele, Allele>();
        for (Allele a : inputVC.getAlleles()) {
            if (a.isSymbolic()) {
                alleles.add(a);
                originalToTrimmedAlleleMap.put(a, a);
                continue;
            }
            byte[] newBases = Arrays.copyOfRange(a.getBases(), fwdTrimEnd + 1, a.length() - revTrim);
            Allele trimmedAllele = Allele.create(newBases, a.isReference());
            alleles.add(trimmedAllele);
            originalToTrimmedAlleleMap.put(a, trimmedAllele);
        }
        for (Genotype genotype : inputVC.getGenotypes()) {
            List<Allele> originalAlleles = genotype.getAlleles();
            ArrayList<Allele> trimmedAlleles = new ArrayList<Allele>();
            for (Allele a : originalAlleles) {
                if (a.isCalled()) {
                    trimmedAlleles.add((Allele)originalToTrimmedAlleleMap.get(a));
                    continue;
                }
                trimmedAlleles.add(Allele.NO_CALL);
            }
            genotypes.add(new GenotypeBuilder(genotype).alleles(trimmedAlleles).make());
        }
        int start = inputVC.getStart() + (fwdTrimEnd + 1);
        VariantContextBuilder builder = new VariantContextBuilder(inputVC);
        builder.start(start);
        builder.stop(start + ((Allele)alleles.get(0)).length() - 1);
        builder.alleles((Collection<Allele>)alleles);
        builder.genotypes(genotypes);
        return builder.make();
    }

    public static int computeReverseClipping(List<Allele> unclippedAlleles, byte[] ref) {
        int clipping = 0;
        boolean stillClipping = true;
        while (stillClipping) {
            for (Allele a : unclippedAlleles) {
                if (a.isSymbolic()) continue;
                if (a.length() - clipping == 0) {
                    return clipping - 1;
                }
                if (a.length() - clipping <= 0 || a.length() == 0) {
                    stillClipping = false;
                    continue;
                }
                if (ref.length == clipping) {
                    return -1;
                }
                if (a.getBases()[a.length() - clipping - 1] == ref[ref.length - clipping - 1]) continue;
                stillClipping = false;
            }
            if (!stillClipping) continue;
            ++clipping;
        }
        return clipping;
    }

    public static int computeForwardClipping(List<Allele> unclippedAlleles) {
        if (unclippedAlleles.size() <= 1) {
            return -1;
        }
        int minAlleleLength = Integer.MAX_VALUE;
        for (Allele a : unclippedAlleles) {
            if (a.isSymbolic()) {
                return -1;
            }
            minAlleleLength = Math.min(minAlleleLength, a.length());
        }
        byte[] firstAlleleBases = unclippedAlleles.get(0).getBases();
        int indexOflastSharedBase = -1;
        int i = 0;
        while (i < minAlleleLength - 1) {
            byte base = firstAlleleBases[i];
            for (Allele allele : unclippedAlleles) {
                if (allele.getBases()[i] == base) continue;
                return indexOflastSharedBase;
            }
            indexOflastSharedBase = i++;
        }
        return indexOflastSharedBase;
    }

    public static double computeHardyWeinbergPvalue(VariantContext vc) {
        if (vc.getCalledChrCount() == 0) {
            return 0.0;
        }
        return HardyWeinbergCalculation.hwCalculate(vc.getHomRefCount(), vc.getHetCount(), vc.getHomVarCount());
    }

    public static boolean requiresPaddingBase(List<String> alleles) {
        for (String allele : alleles) {
            if (!allele.isEmpty()) continue;
            return true;
        }
        int clipping = 0;
        Character currentBase = null;
        while (true) {
            for (String allele : alleles) {
                if (allele.length() - clipping == 0) {
                    return true;
                }
                char myBase = allele.charAt(clipping);
                if (currentBase == null) {
                    currentBase = Character.valueOf(myBase);
                    continue;
                }
                if (currentBase.charValue() == myBase) continue;
                return false;
            }
            ++clipping;
            currentBase = null;
        }
    }

    private static final Map<String, Object> subsetAttributes(CommonInfo igc, Collection<String> keysToPreserve) {
        HashMap<String, Object> attributes = new HashMap<String, Object>(keysToPreserve.size());
        for (String key : keysToPreserve) {
            if (!igc.hasAttribute(key)) continue;
            attributes.put(key, igc.getAttribute(key));
        }
        return attributes;
    }

    @Deprecated
    public static VariantContext pruneVariantContext(VariantContext vc, Collection<String> keysToPreserve) {
        return GATKVariantContextUtils.pruneVariantContext(new VariantContextBuilder(vc), keysToPreserve).make();
    }

    public static VariantContextBuilder pruneVariantContext(VariantContextBuilder builder, Collection<String> keysToPreserve) {
        VariantContext vc = builder.make();
        if (keysToPreserve == null) {
            keysToPreserve = Collections.emptyList();
        }
        Map<String, Object> attributes = GATKVariantContextUtils.subsetAttributes(vc.getCommonInfo(), keysToPreserve);
        GenotypesContext genotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype g : vc.getGenotypes()) {
            GenotypeBuilder gb = new GenotypeBuilder(g);
            gb.noAD().noDP().noPL().noAttributes();
            genotypes.add(gb.make());
        }
        return builder.genotypes(genotypes).attributes(attributes);
    }

    public static boolean allelesAreSubset(VariantContext vc1, VariantContext vc2) {
        if (!vc1.getReference().equals(vc2.getReference())) {
            return false;
        }
        for (Allele a : vc1.getAlternateAlleles()) {
            if (vc2.getAlternateAlleles().contains(a)) continue;
            return false;
        }
        return true;
    }

    public static Map<VariantContext.Type, List<VariantContext>> separateVariantContextsByType(Collection<VariantContext> VCs) {
        HashMap<VariantContext.Type, List<VariantContext>> mappedVCs = new HashMap<VariantContext.Type, List<VariantContext>>();
        for (VariantContext vc : VCs) {
            boolean addtoOwnList = true;
            block1: for (VariantContext.Type type : VariantContext.Type.values()) {
                if (type.equals((Object)vc.getType()) || !mappedVCs.containsKey((Object)type)) continue;
                List<VariantContext> vcList = mappedVCs.get((Object)type);
                for (int k = 0; k < vcList.size(); ++k) {
                    VariantContext otherVC = vcList.get(k);
                    if (GATKVariantContextUtils.allelesAreSubset(otherVC, vc)) {
                        vcList.remove(k);
                        if (vcList.size() == 0) {
                            mappedVCs.remove((Object)type);
                        }
                        if (!mappedVCs.containsKey((Object)vc.getType())) {
                            mappedVCs.put(vc.getType(), new ArrayList());
                        }
                        mappedVCs.get((Object)vc.getType()).add(otherVC);
                        continue block1;
                    }
                    if (!GATKVariantContextUtils.allelesAreSubset(vc, otherVC)) continue;
                    mappedVCs.get((Object)type).add(vc);
                    addtoOwnList = false;
                    continue block1;
                }
            }
            if (!addtoOwnList) continue;
            if (!mappedVCs.containsKey((Object)vc.getType())) {
                mappedVCs.put(vc.getType(), new ArrayList());
            }
            mappedVCs.get((Object)vc.getType()).add(vc);
        }
        return mappedVCs;
    }

    public static VariantContext purgeUnallowedGenotypeAttributes(VariantContext vc, Set<String> allowedAttributes) {
        if (allowedAttributes == null) {
            return vc;
        }
        GenotypesContext newGenotypes = GenotypesContext.create(vc.getNSamples());
        for (Genotype genotype : vc.getGenotypes()) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> attr : genotype.getExtendedAttributes().entrySet()) {
                if (!allowedAttributes.contains(attr.getKey())) continue;
                attrs.put(attr.getKey(), attr.getValue());
            }
            newGenotypes.add(new GenotypeBuilder(genotype).attributes(attrs).make());
        }
        return new VariantContextBuilder(vc).genotypes(newGenotypes).make();
    }

    public static VariantContext makeFromAlleles(String name, String contig, int start, List<String> alleleStrings) {
        if (alleleStrings == null || alleleStrings.isEmpty()) {
            throw new IllegalArgumentException("alleleStrings must be non-empty, non-null list");
        }
        LinkedList<Allele> alleles = new LinkedList<Allele>();
        int length = alleleStrings.get(0).length();
        boolean first = true;
        for (String alleleString : alleleStrings) {
            alleles.add(Allele.create(alleleString, first));
            first = false;
        }
        return new VariantContextBuilder(name, contig, start, start + length - 1, alleles).make();
    }

    private static class CompareByPriority
    implements Comparator<VariantContext>,
    Serializable {
        List<String> priorityListOfVCs;

        public CompareByPriority(List<String> priorityListOfVCs) {
            this.priorityListOfVCs = priorityListOfVCs;
        }

        private int getIndex(VariantContext vc) {
            int i = this.priorityListOfVCs.indexOf(vc.getSource());
            if (i == -1) {
                throw new IllegalArgumentException("Priority list " + this.priorityListOfVCs + " doesn't contain variant context " + vc.getSource());
            }
            return i;
        }

        @Override
        public int compare(VariantContext vc1, VariantContext vc2) {
            return Integer.valueOf(this.getIndex(vc1)).compareTo(this.getIndex(vc2));
        }
    }

    private static class AlleleMapper {
        private VariantContext vc = null;
        private Map<Allele, Allele> map = null;

        public AlleleMapper(VariantContext vc) {
            this.vc = vc;
        }

        public AlleleMapper(Map<Allele, Allele> map) {
            this.map = map;
        }

        public boolean needsRemapping() {
            return this.map != null;
        }

        public Collection<Allele> values() {
            return this.map != null ? this.map.values() : this.vc.getAlleles();
        }

        public Allele remap(Allele a) {
            return this.map != null && this.map.containsKey(a) ? this.map.get(a) : a;
        }

        public List<Allele> remap(List<Allele> as) {
            ArrayList<Allele> newAs = new ArrayList<Allele>();
            for (Allele a : as) {
                newAs.add(this.remap(a));
            }
            return newAs;
        }
    }

    public static enum MultipleAllelesMergeType {
        BY_TYPE,
        MIX_TYPES;

    }

    public static enum FilteredRecordMergeType {
        KEEP_IF_ANY_UNFILTERED,
        KEEP_IF_ALL_UNFILTERED,
        KEEP_UNCONDITIONAL;

    }

    public static enum GenotypeMergeType {
        UNIQUIFY,
        PRIORITIZE,
        UNSORTED,
        REQUIRE_UNIQUE;

    }
}

