/*
 * Decompiled with CFR 0.152.
 */
package org.reflections;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.reflections.ReflectionsException;
import org.reflections.util.ClasspathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectionUtils {
    private static List<String> primitiveNames;
    private static List<Class> primitiveTypes;
    private static List<String> primitiveDescriptors;

    public static Set<Class<?>> getAllSuperTypes(Class<?> type, Predicate<? super Class<?>> predicate) {
        HashSet<Class<?>> result = Sets.newHashSet();
        if (type != null) {
            result.add(type);
            result.addAll(ReflectionUtils.getAllSuperTypes(type.getSuperclass(), Predicates.alwaysTrue()));
            for (Class<?> inter : type.getInterfaces()) {
                result.addAll(ReflectionUtils.getAllSuperTypes(inter, Predicates.alwaysTrue()));
            }
        }
        return ImmutableSet.copyOf(Collections2.filter(result, predicate));
    }

    public static Set<Class<?>> getAllSuperTypes(Iterable<? extends Class<?>> types, Predicate<? super Class<?>> predicate) {
        HashSet<Class<?>> result = Sets.newHashSet();
        for (Class<?> type : types) {
            result.addAll(ReflectionUtils.getAllSuperTypes(type, predicate));
        }
        return result;
    }

    public static Set<Field> getAllFields(Class<?> type, Predicate<? super Field> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, Predicates.alwaysTrue())) {
            Collections.addAll(result, t.getDeclaredFields());
        }
        return ImmutableSet.copyOf(Collections2.filter(result, predicate));
    }

    public static Set<Field> getAllFields(Iterable<? extends Class<?>> types, Predicate<? super Field> predicate) {
        HashSet<Field> result = Sets.newHashSet();
        for (Class<?> type : types) {
            result.addAll(ReflectionUtils.getAllFields(type, predicate));
        }
        return result;
    }

    public static Set<Method> getAllMethods(Class<?> type, Predicate<? super Method> predicate) {
        HashSet result = Sets.newHashSet();
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type, Predicates.alwaysTrue())) {
            Collections.addAll(result, t.isInterface() ? t.getMethods() : t.getDeclaredMethods());
        }
        return ImmutableSet.copyOf(Collections2.filter(result, predicate));
    }

    public static Set<Method> getAllMethods(Iterable<? extends Class<?>> types, Predicate<? super Method> predicate) {
        HashSet<Method> result = Sets.newHashSet();
        for (Class<?> type : types) {
            result.addAll(ReflectionUtils.getAllMethods(type, predicate));
        }
        return ImmutableSet.copyOf(result);
    }

    public static <T extends AnnotatedElement> Set<T> getAll(Iterable<? extends T> elements, Predicate<? super T> predicate) {
        return ImmutableSet.copyOf(Iterables.filter(elements, predicate));
    }

    public static <T extends Member> Predicate<T> withName(final String name) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && input.getName().equals(name);
            }
        };
    }

    public static <T extends Member> Predicate<T> withPrefix(final String prefix) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && input.getName().startsWith(prefix);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Class<? extends Annotation> annotation) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && input.isAnnotationPresent(annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(final Class<? extends Annotation> ... annotations) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && Arrays.equals(annotations, input.getAnnotations());
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotation(final Annotation annotation) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && input.isAnnotationPresent(annotation.annotationType()) && ReflectionUtils.areAnnotationMembersMatching(input.getAnnotation(annotation.annotationType()), annotation);
            }
        };
    }

    public static <T extends AnnotatedElement> Predicate<T> withAnnotations(final Annotation ... annotations) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                Annotation[] inputAnnotations;
                if (input != null && (inputAnnotations = input.getAnnotations()).length == annotations.length) {
                    for (int i = 0; i < inputAnnotations.length; ++i) {
                        if (ReflectionUtils.areAnnotationMembersMatching(inputAnnotations[i], annotations[i])) continue;
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Predicate<Method> withParameters(final Class<?> ... types) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                return input != null && Arrays.equals(input.getParameterTypes(), types);
            }
        };
    }

    public static Predicate<Method> withParametersAssignableTo(final Class ... types) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                Class<?>[] parameterTypes;
                if (input != null && (parameterTypes = input.getParameterTypes()).length == types.length) {
                    for (int i = 0; i < parameterTypes.length; ++i) {
                        if (types[i].isAssignableFrom(parameterTypes[i])) continue;
                        return false;
                    }
                    return true;
                }
                return false;
            }
        };
    }

    public static Predicate<Method> withParametersCount(final int count) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                return input != null && input.getParameterTypes().length == count;
            }
        };
    }

    public static Predicate<Method> withParameterAnnotations(final Annotation ... annotations) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                if (input != null && annotations != null) {
                    Annotation[][] parameterAnnotations = input.getParameterAnnotations();
                    if (annotations.length == parameterAnnotations.length) {
                        for (int i = 0; i < parameterAnnotations.length; ++i) {
                            boolean any = false;
                            for (Annotation annotation : parameterAnnotations[i]) {
                                if (!ReflectionUtils.areAnnotationMembersMatching(annotations[i], annotation)) continue;
                                any = true;
                                break;
                            }
                            if (any) continue;
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static Predicate<Method> withParameterAnnotations(final Class<? extends Annotation> ... annotationClasses) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                if (input != null && annotationClasses != null) {
                    Annotation[][] parameterAnnotations = input.getParameterAnnotations();
                    if (annotationClasses.length == parameterAnnotations.length) {
                        for (int i = 0; i < parameterAnnotations.length; ++i) {
                            boolean any = false;
                            for (Annotation annotation : parameterAnnotations[i]) {
                                if (!annotationClasses[i].equals(annotation.annotationType())) continue;
                                any = true;
                                break;
                            }
                            if (any) continue;
                            return false;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public static <T> Predicate<Field> withType(final Class<T> type) {
        return new Predicate<Field>(){

            @Override
            public boolean apply(@Nullable Field input) {
                return input != null && input.getType().equals(type);
            }
        };
    }

    public static <T> Predicate<Field> withTypeAssignableTo(final Class<T> type) {
        return new Predicate<Field>(){

            @Override
            public boolean apply(@Nullable Field input) {
                return input != null && type.isAssignableFrom(input.getType());
            }
        };
    }

    public static <T> Predicate<Method> withReturnType(final Class<T> type) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                return input != null && input.getReturnType().equals(type);
            }
        };
    }

    public static <T> Predicate<Method> withReturnTypeAssignableTo(final Class<T> type) {
        return new Predicate<Method>(){

            @Override
            public boolean apply(@Nullable Method input) {
                return input != null && type.isAssignableFrom(input.getReturnType());
            }
        };
    }

    public static <T extends Member> Predicate<T> withModifier(final int mod) {
        return new Predicate<T>(){

            @Override
            public boolean apply(@Nullable T input) {
                return input != null && (input.getModifiers() & mod) != 0;
            }
        };
    }

    public static boolean areAnnotationMembersMatching(Annotation annotation1, Annotation annotation2) {
        if (annotation2 != null && annotation1.annotationType() == annotation2.annotationType()) {
            for (Method method : annotation1.annotationType().getDeclaredMethods()) {
                try {
                    if (method.invoke((Object)annotation1, new Object[0]).equals(method.invoke((Object)annotation2, new Object[0]))) continue;
                    return false;
                }
                catch (Exception e) {
                    throw new ReflectionsException(String.format("could not invoke method %s on annotation %s", method.getName(), annotation1.annotationType()), e);
                }
            }
            return true;
        }
        return false;
    }

    public static <T extends AnnotatedElement> Set<T> getMatchingAnnotations(Set<T> annotatedElements, Annotation annotation) {
        HashSet<AnnotatedElement> result = Sets.newHashSet();
        for (AnnotatedElement annotatedElement : annotatedElements) {
            Annotation annotation1 = annotatedElement.getAnnotation(annotation.annotationType());
            if (!ReflectionUtils.areAnnotationMembersMatching(annotation, annotation1)) continue;
            result.add(annotatedElement);
        }
        return result;
    }

    public static Class<?> forName(String typeName, ClassLoader ... classLoaders) {
        String type;
        if (ReflectionUtils.getPrimitiveNames().contains(typeName)) {
            return ReflectionUtils.getPrimitiveTypes().get(ReflectionUtils.getPrimitiveNames().indexOf(typeName));
        }
        if (typeName.contains("[")) {
            int i = typeName.indexOf("[");
            type = typeName.substring(0, i);
            String array = typeName.substring(i).replace("]", "");
            type = ReflectionUtils.getPrimitiveNames().contains(type) ? ReflectionUtils.getPrimitiveDescriptors().get(ReflectionUtils.getPrimitiveNames().indexOf(type)) : "L" + type + ";";
            type = array + type;
        } else {
            type = typeName;
        }
        for (ClassLoader classLoader : ClasspathHelper.classLoaders(classLoaders)) {
            try {
                return Class.forName(type, false, classLoader);
            }
            catch (Throwable e) {
            }
        }
        return null;
    }

    public static <T> List<Class<? extends T>> forNames(Iterable<String> classes, ClassLoader ... classLoaders) {
        ArrayList<Class<T>> result = new ArrayList<Class<T>>();
        for (String className : classes) {
            result.add(ReflectionUtils.forName(className, classLoaders));
        }
        return result;
    }

    public static List<String> names(Iterable<Class<?>> types) {
        ArrayList<String> result = Lists.newArrayList();
        for (Class<?> type : types) {
            result.add(type.getName());
        }
        return result;
    }

    public static List<String> getPrimitiveNames() {
        return primitiveNames == null ? (primitiveNames = Lists.newArrayList("boolean", "char", "byte", "short", "int", "long", "float", "double", "void")) : primitiveNames;
    }

    public static List<Class> getPrimitiveTypes() {
        return primitiveTypes == null ? (primitiveTypes = Lists.newArrayList(Boolean.TYPE, Character.TYPE, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE)) : primitiveTypes;
    }

    public static List<String> getPrimitiveDescriptors() {
        return primitiveDescriptors == null ? (primitiveDescriptors = Lists.newArrayList("Z", "C", "B", "S", "I", "J", "F", "D", "V")) : primitiveDescriptors;
    }
}

