SNP2Gene.match <-
function(assoc.file, snp2gene.file, boundary=20)
{
	cat('start searching at ', format(Sys.time(), "%H:%M, %b %d %Y"), ' ...\n', sep='')
	assoc <- read.table(assoc.file, header=T)
	cat("read in ", dim(assoc)[[1]], " SNPs in ", assoc.file, "\n", sep="");
	map.data <- read.table(snp2gene.file, header=T)
	cat("read in ", dim(snp2gene.file)[[1]], " records in ", snp2gene.file, "\n", sep="");
	colns = names(map.data)
	if(is.element('SNP', colns) & is.element('Dist', colns) & is.element('Gene', colns))
	{
		affy.map2 <- map.data[as.numeric(map.data$Dist)<as.numeric(1000*boundary), ]
		merge(affy.map2, assoc, by='SNP') -> gene.map
		cat('finish searching at ', format(Sys.time(), "%H:%M, %b %d %Y"), ' ...\n', sep='')
		gene.map = data.frame(Gene=gene.map$Gene, SNP=gene.map$SNP, P=gene.map$P)
		write.table(gene.map, file="gene.map.tmp", row.names=F, col.names=F, quote=F, sep="\t")
		tmp = read.table("gene.map.tmp", sep=" ")
		tmp = unique(tmp)
		write.table(tmp, file="gene.map.tmp", row.names=F, col.names=F, quote=F, sep="\t")
		gene.map = read.table("gene.map.tmp", sep="\t")
		names(gene.map) = c("Gene", "SNP", "P")
		file.remove("gene.map.tmp")
		rm(tmp)
		gene.map = gene.map[gene.map$Gene!="---", ]
		return(gene.map)
	}
	else
	{
		stop("Please make sure that a header line is provided in the snp2gene.file, including \"SNP\", \"Dist\", and \"Gene\"")
	}
}

