seedQueryJ <-
function (G, seed, search_r = 2, r = 0.1){
    net <- G
    d <- search_r
    if (!is.element("name", list.vertex.attributes(net))) {
        stop("Graph must have 'name' attribute")
    }
    if (!is.element("weight", list.vertex.attributes(net))) {
        stop("Graph must have 'weight' attribute")
    }
    seed <- match(seed, V(net)$name) - 1
    subG <- subgraph(net, seed)
    if (!is.connected(subG)) {   		#the seed must be connected
        stop("Input seeds are disjoint")
    }
    in.nodes <- V(subG)$name
    while (TRUE) {
        subx <- V(subG)$name
        for (rad in 1:d) {
            subsum <- sum(V(subG)$weight)/sqrt(length(subx)) #Peilin
            
            tmp.neigh <- unlist(neighborhood(net, order = rad, nodes = match(V(subG)$name, V(net)$name) - 1))
            pot.nodes <- V(net)[tmp.neigh]$name
            pot.nodes <- setdiff(pot.nodes, in.nodes)
            if (length(pot.nodes) == 0) break
            sub.weg <- V(net)$weight[match(pot.nodes, V(net)$name)]
            best.nodes <- pot.nodes[which(sub.weg == max(sub.weg))]
            
            subsum.u <- (sum(V(subG)$weight) + V(net)$weight[match(best.nodes[1],V(net)$name)])/sqrt(length(subx)+1)
            
            if (subsum.u > subsum * (1 + r)) {
                tmp <- unlist(lapply(best.nodes, function(x) node2treePath(net,V(subG)$name, x)))
                in.nodes <- c(tmp, V(subG)$name)
                tmpG = subgraph(net, match(in.nodes, V(net)$name) - 1)
                tmp.subsum.u <- sum(V(tmpG)$weight)/sqrt(length(V(tmpG)$name))
                subG <- subgraph(net, match(in.nodes, V(net)$name) - 1)
                break
            }
        }
        if (length(subx) == vcount(subG)) break
    }
    return(subG)
}

