simpleChoose <-
function(res.list, top=100, plot=FALSE)
{
	match(res.list$zi.ordered[1:top,1], names(res.list$genesets.clear)) -> idx
	genes=unique(unlist(res.list$genesets.clear[idx]))
	idx <- match(genes, V(res.list$GWPI)$name) - 1
	subG <- subgraph(res.list$GWPI, idx)
	results = list(modules=res.list$genesets.clear[idx], subnetwork=subG)
	x = V(subG)$weight
	nx = (x-min(x))/(max(x)-min(x))
	if(plot)tkplot(subG, vertex.label=V(subG)$name, vertex.size=5, vertex.color=gray(nx), vertex.label.dist=1, layout=layout.fruchterman.reingold)
	return(results)
}

